/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.ArrayList;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.rasanovum.viaromana.PlatformUtils;
import net.rasanovum.viaromana.core.ChartingHandler;
import net.rasanovum.viaromana.core.DimensionHandler;
import net.rasanovum.viaromana.core.PathRecord;
import net.rasanovum.viaromana.core.ResetVariables;
import net.rasanovum.viaromana.core.SignCheck;
import net.rasanovum.viaromana.core.TeleportHandler;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.TimerUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class SignInteract {
    public static void placed(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || !SignCheck.isSignBlock(world, x, y, z) || VariableAccess.playerVariables.hasReceivedTutorial(entity)) {
            return;
        }
        if (PlatformUtils.isModLoaded("patchouli")) {
            SignInteract.giveGuideBook(world, entity);
            SignInteract.playPickupSound(world, entity);
        }
        VariableAccess.playerVariables.setReceivedTutorial(entity, true);
        VariableAccess.playerVariables.setAwaitingToast(entity, true);
        VariableAccess.playerVariables.syncAndSave(entity);
    }

    public static void broken(LevelAccessor world, double x, double y, double z, Entity entity) {
        String tagValue;
        if (entity == null) {
            return;
        }
        if (SignCheck.isSignBlock(world, x, y, z) && !(tagValue = PlatformUtils.getString(world, BlockPos.m_274561_((double)x, (double)y, (double)z), SignCheck.getTarget(world, x, y, z, entity))).isEmpty()) {
            Player player;
            SignInteract.unlinkPath(world, x, y, z, entity);
            ResetVariables.execute(world, entity);
            if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"sign_unlinked_message").getString()), true);
            }
        }
    }

    public static void clicked(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (SignCheck.isSignBlock(world, x, y, z)) {
            if (VariableAccess.playerVariables.isChartingPath(entity)) {
                if (TimerUtils.checkLeftClickTimer(entity)) {
                    TimerUtils.startLeftClickTimer(entity);
                    if (entity.m_6144_()) {
                        if (SignCheck.isSameSign(world, x, y, z, entity)) {
                            Player _player;
                            if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                                _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"cancel_path_message").getString()), true);
                            }
                            ResetVariables.execute(world, entity);
                        } else if (SignCheck.isTargettingLinked(world, x, y, z, entity)) {
                            Player _player;
                            if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                                _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"sign_already_linked").getString()), true);
                            }
                        } else {
                            SignInteract.mainLogic(world, x, y, z, entity);
                        }
                    } else {
                        if (SignCheck.isSameSign(world, x, y, z, entity)) {
                            Player _player;
                            if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                                _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"cannot_break_root_sign").getString()), true);
                            }
                            PlatformUtils.cancelClickEvent(true);
                            return;
                        }
                        if (SignCheck.isTargettingLinked(world, x, y, z, entity)) {
                            Player _player;
                            if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                                _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"cannot_warp_when_recording").getString()), true);
                            }
                        } else {
                            return;
                        }
                    }
                }
                PlatformUtils.cancelClickEvent(true);
                return;
            }
            if (SignCheck.isTargettingLinked(world, x, y, z, entity) && !entity.m_6144_() || !SignCheck.isTargettingLinked(world, x, y, z, entity) && entity.m_6144_()) {
                if (TimerUtils.checkLeftClickTimer(entity)) {
                    TimerUtils.startLeftClickTimer(entity);
                    SignInteract.mainLogic(world, x, y, z, entity);
                }
                PlatformUtils.cancelClickEvent(true);
                return;
            }
            if (SignCheck.isTargettingLinked(world, x, y, z, entity) && entity.m_6144_() && !TimerUtils.checkLeftClickTimer(entity)) {
                PlatformUtils.cancelClickEvent(true);
                return;
            }
        }
    }

    private static void giveGuideBook(LevelAccessor world, Entity entity) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            String command = "/give " + entity.m_5446_().getString() + " patchouli:guide_book{\"patchouli:book\":\"via_romana:guide\"}";
            CommandSourceStack source = new CommandSourceStack(CommandSource.f_80164_, new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()), Vec2.f_82462_, serverLevel, 4, "", (Component)Component.m_237113_((String)""), serverLevel.m_7654_(), null).m_81324_();
            serverLevel.m_7654_().m_129892_().m_230957_(source, command);
        }
    }

    private static void playPickupSound(LevelAccessor world, Entity entity) {
        if (world instanceof Level) {
            Level level = (Level)world;
            ResourceLocation soundLoc = new ResourceLocation("entity.item.pickup");
            BlockPos pos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_());
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundLoc), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundLoc), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
    }

    public static void unlinkPath(LevelAccessor world, double x, double y, double z, Entity entity) {
        block6: {
            if (entity == null) {
                return;
            }
            String nbtKey = SignCheck.getTarget(world, x, y, z, entity);
            String pathStoredData = PlatformUtils.getString(world, BlockPos.m_274561_((double)x, (double)y, (double)z), nbtKey);
            ArrayList<Object> linkedSignData = PathUtils.decodePathData(pathStoredData);
            String linkedSignNbtKey = "";
            try {
                Player player;
                BlockPos targetPos;
                BlockEntity blockEntity;
                double targetX = (Double)linkedSignData.get(3);
                double targetY = (Double)linkedSignData.get(4);
                double targetZ = (Double)linkedSignData.get(5);
                if (linkedSignData.size() <= 6 || !(linkedSignData.get(6) instanceof String)) {
                    throw new ClassCastException("Missing or invalid NBT key index 6");
                }
                linkedSignNbtKey = (String)linkedSignData.get(6);
                if (!world.m_5776_() && (blockEntity = world.m_7702_(targetPos = BlockPos.m_274561_((double)targetX, (double)targetY, (double)targetZ))) != null) {
                    PlatformUtils.setString(world, targetPos, linkedSignNbtKey, "");
                }
                if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
                    player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"sign_unlinked_message").getString()), true);
                }
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                Player player;
                if (!(entity instanceof Player) || (player = (Player)entity).m_9236_().m_5776_()) break block6;
                player.m_5661_((Component)Component.m_237113_((String)"Error: Could not unlink sign due to invalid/missing data."), true);
            }
        }
    }

    public static void mainLogic(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (DimensionHandler.isValid(world, entity)) {
            Player _player;
            TimerUtils.startMessageTimer(entity);
            if (entity.m_6144_()) {
                Player _player2;
                if (!SignCheck.isTargettingLinked(world, x, y, z, entity)) {
                    Player _player3;
                    if (PathUtils.calculateInfrastructureQuality(world, entity) >= VariableAccess.mapVariables.getInfrastructureCheckQuality(world)) {
                        Player _player4;
                        if (!VariableAccess.playerVariables.isChartingPath(entity)) {
                            Player _player5;
                            if (entity instanceof Player && !(_player5 = (Player)entity).m_9236_().m_5776_()) {
                                _player5.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"path_charting").getString()), true);
                            }
                            PathRecord.start(world, x, y, z, entity);
                            ChartingHandler.display(world, entity);
                        } else if (PathUtils.calculatePathStartDistance(entity) >= VariableAccess.mapVariables.getPathDistanceMinimum(world)) {
                            if (SignCheck.isSignFound(world, x, y, z, entity) && PathUtils.calculateNodeDistance(entity) <= VariableAccess.mapVariables.getNodeDistanceMaximum(world)) {
                                PathRecord.end(world, x, y, z, entity);
                                ChartingHandler.display(world, entity);
                            }
                        } else if (entity instanceof Player && !(_player4 = (Player)entity).m_9236_().m_5776_()) {
                            _player4.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"path_invalid_minimum").getString()), true);
                        }
                    } else if (entity instanceof Player && !(_player3 = (Player)entity).m_9236_().m_5776_()) {
                        _player3.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"low_quality_message").getString()), true);
                    }
                } else if (entity instanceof Player && !(_player2 = (Player)entity).m_9236_().m_5776_()) {
                    _player2.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"sign_already_linked").getString()), true);
                }
            } else if (!VariableAccess.playerVariables.isChartingPath(entity)) {
                if (SignCheck.isTargettingLinked(world, x, y, z, entity)) {
                    Player _player6;
                    if (!PlatformUtils.hasEffect(entity, "travellers_fatigue")) {
                        TeleportHandler.start(world, x, y, z, entity);
                    } else if (entity instanceof Player && !(_player6 = (Player)entity).m_9236_().m_5776_()) {
                        _player6.m_5661_((Component)Component.m_237113_((String)"Cannot warp while fatigued"), true);
                    }
                }
            } else if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"cannot_warp_when_recording").getString()), true);
            }
        }
    }
}

