/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.rasanovum.viaromana.PlatformUtils;
import net.rasanovum.viaromana.core.ResetVariables;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.TimerUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class SignCheck {
    public static boolean isSignBlock(LevelAccessor world, double x, double y, double z) {
        BlockState TargetBlock = Blocks.f_50016_.m_49966_();
        TargetBlock = world.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z));
        if (new ItemStack((ItemLike)TargetBlock.m_60734_()).m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("via_romana:warp_sign")))) {
            return true;
        }
        for (int index0 = 0; index0 < VariableAccess.mapVariables.getValidSignList(world).size(); ++index0) {
            String _s;
            String _s2;
            Object object;
            if (!BuiltInRegistries.f_256975_.m_7981_((Object)TargetBlock.m_60734_()).toString().contains((object = VariableAccess.mapVariables.getValidSignList(world).get(index0)) instanceof String ? (_s2 = (String)object) : "") || ((object = VariableAccess.mapVariables.getValidSignList(world).get(index0)) instanceof String ? (_s = (String)object) : "").isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSignFound(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return false;
        }
        ArrayList<Object> TeleportData = new ArrayList();
        String TeleportDataEncoded = "";
        double TargetX = 0.0;
        double TargetY = 0.0;
        double TargetZ = 0.0;
        TeleportDataEncoded = VariableAccess.playerVariables.getPathData(entity);
        TeleportData = PathUtils.decodePathData(TeleportDataEncoded);
        try {
            TargetX = (Double)TeleportData.get(3);
            TargetY = (Double)TeleportData.get(4);
            TargetZ = (Double)TeleportData.get(5);
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            Player _player;
            if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                _player.m_5661_((Component)Component.m_237113_((String)"Error: Invalid path data format."), true);
            }
            ResetVariables.execute(world, entity);
            return false;
        }
        if (VariableAccess.playerVariables.isChartingPath(entity)) {
            if (!SignCheck.isSignBlock(world, TargetX, TargetY, TargetZ)) {
                Player _player;
                if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                    _player.m_5661_((Component)Component.m_237113_((String)"Starting sign not found, charting cancelled"), true);
                }
                TimerUtils.startLeftClickTimer(entity);
                ResetVariables.execute(world, entity);
                return false;
            }
        } else {
            String signNbtKey = "";
            if (TeleportData.size() <= 6 || !(TeleportData.get(6) instanceof String)) {
                Player _player;
                if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                    _player.m_5661_((Component)Component.m_237113_((String)"Error: Missing sign data."), true);
                }
                ResetVariables.execute(world, entity);
                return false;
            }
            signNbtKey = (String)TeleportData.get(6);
            if (new Object(){

                public String getValue(LevelAccessor world, BlockPos pos, String tag) {
                    return PlatformUtils.getString(world, pos, tag);
                }
            }.getValue(world, BlockPos.m_274561_((double)TargetX, (double)TargetY, (double)TargetZ), signNbtKey).equals("")) {
                Player _player;
                BlockPos _bp;
                BlockEntity _blockEntity;
                if (!world.m_5776_() && (_blockEntity = world.m_7702_(_bp = BlockPos.m_274561_((double)x, (double)y, (double)z))) != null) {
                    PlatformUtils.setString(world, BlockPos.m_274561_((double)x, (double)y, (double)z), SignCheck.getTarget(world, x, y, z, entity), "");
                }
                if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                    _player.m_5661_((Component)Component.m_237113_((String)("Linked sign not found, " + Component.m_237115_((String)"sign_unlinked_message").getString())), true);
                }
                ResetVariables.execute(world, entity);
                return false;
            }
        }
        return true;
    }

    public static boolean isSameSign(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return false;
        }
        String PathStoredData = "";
        ArrayList<Object> PathStoredArrayList = new ArrayList();
        PathStoredData = VariableAccess.playerVariables.getPathData(entity);
        PathStoredArrayList = PathUtils.decodePathData(PathStoredData);
        try {
            String signTag;
            Object e;
            Double startX = (Double)PathStoredArrayList.get(3);
            Double startY = (Double)PathStoredArrayList.get(4);
            Double startZ = (Double)PathStoredArrayList.get(5);
            if (startX == x && startY == y && startZ == z && PathStoredArrayList.size() >= 7 && (e = PathStoredArrayList.get(6)) instanceof String && (signTag = (String)e).equals(SignCheck.getTarget(world, x, y, z, entity))) {
                return true;
            }
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            return false;
        }
        return false;
    }

    public static boolean isIncludedInSign(double x, double y, double z, Entity entity) {
        if (entity == null) {
            return false;
        }
        String PathStoredData = "";
        ArrayList<Object> PathStoredArrayList = new ArrayList();
        PathStoredData = VariableAccess.playerVariables.getPathData(entity);
        PathStoredArrayList = PathUtils.decodePathData(PathStoredData);
        try {
            Double startX = (Double)PathStoredArrayList.get(3);
            Double startY = (Double)PathStoredArrayList.get(4);
            Double startZ = (Double)PathStoredArrayList.get(5);
            if (startX == x && startY == y && startZ == z) {
                return true;
            }
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            return false;
        }
        return false;
    }

    public static boolean isSupplementariesSign(LevelAccessor world, double x, double y, double z) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)world.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_60734_()).toString().contains("supplementaries");
    }

    public static boolean isTopSign(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return false;
        }
        double hitY = 0.0;
        Vec3 eyePosition = entity.m_20299_(1.0f);
        Vec3 viewVector = entity.m_20252_(1.0f).m_82490_(5.0);
        Vec3 targetPosition = eyePosition.m_82549_(viewVector);
        ClipContext clipContext = new ClipContext(eyePosition, targetPosition, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity);
        BlockHitResult hitResult = entity.m_9236_().m_45547_(clipContext);
        Direction hitDirection = hitResult.m_82434_();
        if (hitDirection == Direction.UP) {
            return true;
        }
        if (hitDirection == Direction.DOWN) {
            return false;
        }
        hitY = hitResult.m_82450_().f_82480_;
        return hitY - y >= 0.5;
    }

    public static String getTarget(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return "";
        }
        if (SignCheck.isSupplementariesSign(world, x, y, z)) {
            if (SignCheck.isTopSign(world, x, y, z, entity)) {
                return "linkedSignTop";
            }
            return "linkedSignBottom";
        }
        return "linkedSign";
    }

    public static boolean isSignLinked(LevelAccessor world, double x, double y, double z) {
        return !new Object(){

            public String getValue(LevelAccessor world, BlockPos pos, String tag) {
                return PlatformUtils.getString(world, pos, tag);
            }
        }.getValue(world, BlockPos.m_274561_((double)x, (double)y, (double)z), "linkedSignTop").equals("") || !new Object(){

            public String getValue(LevelAccessor world, BlockPos pos, String tag) {
                return PlatformUtils.getString(world, pos, tag);
            }
        }.getValue(world, BlockPos.m_274561_((double)x, (double)y, (double)z), "linkedSignBottom").equals("") || !new Object(){

            public String getValue(LevelAccessor world, BlockPos pos, String tag) {
                return PlatformUtils.getString(world, pos, tag);
            }
        }.getValue(world, BlockPos.m_274561_((double)x, (double)y, (double)z), "linkedSign").equals("");
    }

    public static boolean isFullyLinked(LevelAccessor world, double x, double y, double z) {
        if (!SignCheck.isSignLinked(world, x, y, z)) {
            return false;
        }
        if (!SignCheck.isSupplementariesSign(world, x, y, z) && !new Object(){

            public String getValue(LevelAccessor world, BlockPos pos, String tag) {
                return PlatformUtils.getString(world, pos, tag);
            }
        }.getValue(world, BlockPos.m_274561_((double)x, (double)y, (double)z), "linkedSign").equals("")) {
            return true;
        }
        return !new Object(){

            public String getValue(LevelAccessor world, BlockPos pos, String tag) {
                return PlatformUtils.getString(world, pos, tag);
            }
        }.getValue(world, BlockPos.m_274561_((double)x, (double)y, (double)z), "linkedSignTop").equals("") && !new Object(){

            public String getValue(LevelAccessor world, BlockPos pos, String tag) {
                return PlatformUtils.getString(world, pos, tag);
            }
        }.getValue(world, BlockPos.m_274561_((double)x, (double)y, (double)z), "linkedSignBottom").equals("");
    }

    public static boolean isTargettingLinked(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return false;
        }
        return !new Object(){

            public String getValue(LevelAccessor world, BlockPos pos, String tag) {
                return PlatformUtils.getString(world, pos, tag);
            }
        }.getValue(world, BlockPos.m_274561_((double)x, (double)y, (double)z), SignCheck.getTarget(world, x, y, z, entity)).equals("");
    }
}

