/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.rasanovum.viaromana.PlatformUtils;
import net.rasanovum.viaromana.core.ChartingHandler;
import net.rasanovum.viaromana.core.ResetVariables;
import net.rasanovum.viaromana.core.SignCheck;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class PathRecord {
    public static void start(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        VariableAccess.playerVariables.setPathData(entity, PathUtils.encodePathData(world, x, y, z, entity));
        ChartingHandler.updateLastNode(entity);
        VariableAccess.playerVariables.setChartingPath(entity, true);
        VariableAccess.playerVariables.syncAndSave(entity);
    }

    public static void end(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        ArrayList<Object> pathData = PathUtils.decodePathData(VariableAccess.playerVariables.getPathData(entity));
        if (!PathRecord.isValidPathData(pathData, entity)) {
            PathRecord.handleError(entity, "Error: Invalid path data format during record end.");
            return;
        }
        double startX = (Double)pathData.get(3);
        double startY = (Double)pathData.get(4);
        double startZ = (Double)pathData.get(5);
        String startSignNbtKey = PathRecord.getStartSignNbtKey(pathData, entity);
        if (startSignNbtKey == null) {
            return;
        }
        PathRecord.updateBlockEntity(world, x, y, z, SignCheck.getTarget(world, x, y, z, entity), VariableAccess.playerVariables.getPathData(entity));
        PathRecord.updateBlockEntity(world, startX, startY, startZ, startSignNbtKey, PathUtils.encodePathData(world, x, y, z, entity));
        ResetVariables.execute(world, entity);
    }

    private static boolean isValidPathData(List<Object> pathData, Entity entity) {
        try {
            pathData.get(3);
            pathData.get(4);
            pathData.get(5);
            return true;
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            PathRecord.handleError(entity, "Error: Invalid path data format during record end.");
            return false;
        }
    }

    private static String getStartSignNbtKey(List<Object> pathData, Entity entity) {
        if (pathData.size() > 6 && pathData.get(6) instanceof String) {
            return (String)pathData.get(6);
        }
        PathRecord.handleError(entity, "Error: Missing start sign data during record end.");
        return null;
    }

    private static void updateBlockEntity(LevelAccessor world, double x, double y, double z, String key, String value) {
        BlockPos pos;
        BlockEntity blockEntity;
        if (!world.m_5776_() && (blockEntity = world.m_7702_(pos = BlockPos.m_274561_((double)x, (double)y, (double)z))) != null) {
            PlatformUtils.setString(world, pos, key, value);
        }
    }

    private static void handleError(Entity entity, String message) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
            player.m_5661_((Component)Component.m_237113_((String)message), true);
        }
        ResetVariables.execute((LevelAccessor)entity.m_9236_(), entity);
    }
}

