/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.core.SignCheck;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.TimerUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class ChartingHandler {
    public static void chartPath(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (VariableAccess.playerVariables.isChartingPath(entity)) {
            if (PathUtils.calculateNodeDistance(entity) > VariableAccess.mapVariables.getNodeDistanceMaximum(world)) {
                Player _player;
                if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                    _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"too_far_from_node_message").getString()), true);
                }
            } else if (PathUtils.calculateInfrastructureQuality(world, entity) < VariableAccess.mapVariables.getInfrastructureCheckQuality(world)) {
                Player _player;
                if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                    _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"low_quality_message").getString()), true);
                }
            } else {
                if (PathUtils.calculateNodeDistance(entity) < VariableAccess.mapVariables.getNodeDistanceMinimum(world)) {
                    if (TimerUtils.checkMessageTimer(entity)) {
                        Player _player;
                        if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                            _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"path_charting").getString()), true);
                        }
                        TimerUtils.startMessageTimer(entity);
                    }
                    return;
                }
                if (PathUtils.calculatePathStartDistance(entity) >= VariableAccess.mapVariables.getPathDistanceMaximum(world)) {
                    Player _player;
                    if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                        _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"path_invalid_maximum").getString()), true);
                    }
                } else if (SignCheck.isSignFound(world, x, y, z, entity)) {
                    ChartingHandler.display(world, entity);
                    return;
                }
            }
        }
    }

    public static void display(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        if (VariableAccess.playerVariables.isChartingPath(entity)) {
            if (world instanceof Level) {
                Level _level = (Level)world;
                if (!_level.m_5776_()) {
                    _level.m_5594_(null, BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_()), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("ui.cartography_table.take_result")), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("ui.cartography_table.take_result")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
            ChartingHandler.updateLastNode(entity);
        } else {
            Player _player;
            if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
                _player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"path_charted").getString()), true);
            }
            if (world instanceof Level) {
                Level _level = (Level)world;
                if (!_level.m_5776_()) {
                    _level.m_5594_(null, BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_()), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("ui.cartography_table.take_result")), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("ui.cartography_table.take_result")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
            if (entity instanceof ServerPlayer) {
                _player = (ServerPlayer)entity;
                Advancement _adv = _player.f_8924_.m_129889_().m_136041_(new ResourceLocation("via_romana:a_strand_type_game"));
                AdvancementProgress _ap = _player.m_8960_().m_135996_(_adv);
                if (!_ap.m_8193_()) {
                    for (String criteria : _ap.m_8219_()) {
                        _player.m_8960_().m_135988_(_adv, criteria);
                    }
                }
            }
        }
    }

    public static void updateLastNode(Entity entity) {
        if (entity == null) {
            return;
        }
        VariableAccess.playerVariables.setLastNodeX(entity, entity.m_20185_());
        VariableAccess.playerVariables.setLastNodeZ(entity, entity.m_20189_());
    }
}

