/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class IOUtils {
    public static void pipeData(InputStream in, OutputStream out) throws IOException {
        int r;
        byte[] buf = new byte[1024];
        while ((r = in.read(buf)) > 0) {
            out.write(buf, 0, r);
        }
    }

    public static byte[] pipeOut(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.pipeData(in, baos);
        return baos.toByteArray();
    }

    public static void deleteFolder(Path file) throws IOException {
        Files.walk(file, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(File::delete);
        IOUtils.deleteDirs(file.toFile());
    }

    private static void deleteDirs(File dir) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                IOUtils.deleteDirs(file);
            }
        }
        dir.delete();
    }
}

