/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.reader;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.core.js.CallerSpec;
import org.zeith.hammerlib.core.js.ExpressionFixer;
import org.zeith.hammerlib.core.js.ExpressionParser;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.tuples.Tuple2;

public class JsContext {
    private static final Pattern LAMBDA = Pattern.compile("^\\s*\\((?<args>[^)]*)\\)\\s*=>\\s*");
    private final Map<CachedType, ScriptType> scriptCache = new HashMap<CachedType, ScriptType>();

    public static boolean isScript(String expression) {
        return LAMBDA.matcher(expression).find();
    }

    public <T> T eval(Class<T> interfaceType, String input, CallerSpec spec) {
        ScriptType se = this.scriptCache.computeIfAbsent(new CachedType(interfaceType, input, spec), JsContext::load);
        return Cast.cast(se.itf(), interfaceType);
    }

    private static ScriptType load(CachedType expression) {
        try {
            String text = expression.input();
            Matcher lambda = LAMBDA.matcher(text);
            if (!lambda.find()) {
                throw new IllegalArgumentException("JS expression must start with lambda: " + text);
            }
            String args = lambda.group("args");
            text = text.substring(lambda.end());
            text = ExpressionFixer.fixExpression(text);
            List<String> usedArgs = Arrays.stream(args.split(",")).map(String::strip).toList();
            Tuple2<ScriptEngine, ?> tup = ExpressionParser.parse(text, expression.spec(), usedArgs, expression.type());
            return new ScriptType(tup.b(), usedArgs, tup.a());
        }
        catch (Exception e) {
            HammerLib.LOG.error("Failed to parse script <{}>", (Object)expression.input(), (Object)e);
            return new ScriptType(null, List.of(), null);
        }
    }

    public void clear() {
        this.scriptCache.clear();
    }

    private record CachedType(Class<?> type, String input, CallerSpec spec) {
    }

    private record ScriptType(Object itf, List<String> usedArgs, ScriptEngine engine) {
    }
}

