/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.quark_ponders.ponder.scenes.mobs;

import com.leobeliik.quark_ponders.ponder.PonderAux;
import java.util.Objects;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.EntityElement;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.createmod.ponder.foundation.PonderSceneBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.content.mobs.entity.Foxhound;
import org.violetmoon.quark.content.mobs.module.FoxhoundModule;

public class FoxHoundScene {
    public static void Working(SceneBuilder builder, SceneBuildingUtil util) {
        PonderSceneBuilder scene = new PonderSceneBuilder(builder.getScene());
        PonderAux.setAgentScene(scene, util, "quark_foxhound");
        BlockPos fox = util.grid().at(0, 1, 2);
        ElementLink hound = scene.world().createEntity(level -> PonderAux.newEntity(FoxhoundModule.foxhoundType, level, fox.m_252807_().m_82520_(-0.5, 0.0, -0.5), -90));
        scene.overlay().showText(60).text("quark_foxhound.text_1").attachKeyFrame().placeNearTarget().independent(10);
        scene.idle(80);
        ElementLink player = scene.world().createEntity(level -> PonderAux.spawnPlayer(scene, level, fox.m_122030_(3).m_252807_().m_82520_(-0.5, 0.0, -0.5), 90));
        scene.overlay().showText(60).text("quark_foxhound.text_2").attachKeyFrame().placeNearTarget().independent(10);
        scene.idle(80);
        PonderAux.entityMove((ElementLink<EntityElement>)hound, scene, 1, Direction.WEST);
        FoxHoundScene.jumpFox((ElementLink<EntityElement>)hound, scene, Direction.EAST);
        FoxHoundScene.jumpFox((ElementLink<EntityElement>)player, scene, Direction.EAST);
        scene.world().modifyEntity(player, entity -> entity.m_7311_(5));
        scene.effects().emitParticles(util.grid().at(4, 1, 2).m_252807_().m_82520_(0.0, 0.5, 0.0), scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)ParticleTypes.f_123744_.m_6012_(), Vec3.f_82478_), 2.0f, 40);
        scene.idle(45);
        scene.rotateCameraY(360.0f);
        scene.world().modifyEntities(Entity.class, Entity::m_146870_);
        hound = scene.world().createEntity(level -> PonderAux.newEntity(FoxhoundModule.foxhoundType, level, fox.m_122030_(3).m_252807_().m_82520_(0.0, -0.5, 0.0), 90));
        player = scene.world().createEntity(level -> PonderAux.spawnPlayer(scene, level, fox.m_252807_().m_82520_(0.0, -0.5, 0.0), -90));
        scene.idle(40);
        scene.overlay().showText(80).text("quark_foxhound.text_3").attachKeyFrame().placeNearTarget().independent(10);
        scene.idle(90);
        scene.overlay().showControls(fox.m_122030_(3).m_252807_(), Pointing.DOWN, 20).withItem(Items.f_42413_.m_7968_()).showing((ScreenElement)PonderGuiTextures.ICON_DISABLE);
        PonderAux.setSmoke(scene, fox.m_122030_(3));
        scene.overlay().showText(60).text("quark_foxhound.text_4").attachKeyFrame().placeNearTarget().independent(10);
        scene.idle(80);
        ElementLink pot = scene.world().createEntity(level -> FoxHoundScene.potion(level, fox.m_6630_(2).m_252807_()));
        PonderAux.entityMove((ElementLink<EntityElement>)pot, scene, 2, Direction.DOWN);
        scene.world().modifyEntity(pot, Entity::m_146870_);
        scene.effects().emitParticles(fox.m_252807_(), scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)ParticleTypes.f_123806_.m_6012_(), Vec3.f_82478_), 2.0f, 60);
        scene.idle(20);
        scene.overlay().showControls(fox.m_122030_(3).m_252807_(), Pointing.DOWN, 20).withItem(Items.f_42413_.m_7968_());
        scene.effects().emitParticles(fox.m_122030_(3).m_252807_(), scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)ParticleTypes.f_123750_.m_6012_(), Vec3.f_82478_), 5.0f, 3);
        scene.idle(40);
        scene.overlay().showText(40).text("quark_foxhound.text_5").attachKeyFrame().placeNearTarget().independent(10);
        scene.idle(60);
        scene.world().setBlock(util.grid().at(2, 1, 2), (BlockState)((BlockState)Blocks.f_50094_.m_49966_().m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)Direction.NORTH)).m_61124_((Property)FurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(true)), false);
        scene.world().modifyEntity(player, Entity::m_146870_);
        PonderAux.entityMove((ElementLink<EntityElement>)hound, scene, 1, Direction.UP);
        FoxHoundScene.jumpFox((ElementLink<EntityElement>)hound, scene, Direction.WEST);
        scene.world().modifyEntity(hound, entity -> ((Foxhound)entity).m_21837_(true));
        scene.overlay().showText(60).text("quark_foxhound.text_6").attachKeyFrame().placeNearTarget().pointAt(util.grid().at(2, 2, 2).m_252807_());
        scene.idle(80);
        if (FoxhoundModule.foxhoundsSpeedUpFurnaces) {
            scene.overlay().showText(80).text("quark_foxhound.text_7").attachKeyFrame().placeNearTarget().pointAt(util.grid().at(2, 2, 2).m_252807_());
            scene.idle(100);
            scene.overlay().showText(80).text("quark_foxhound.text_8").placeNearTarget().pointAt(util.grid().at(2, 2, 2).m_252807_());
        }
        scene.markAsFinished();
    }

    private static void jumpFox(ElementLink<EntityElement> entityElement, PonderSceneBuilder scene, Direction dir) {
        double v = dir == Direction.EAST ? 0.2 : -0.2;
        int i = 0;
        while (i < 6) {
            scene.idle(1);
            int finalI = i++;
            scene.world().modifyEntity(entityElement, entity -> entity.m_6478_(MoverType.SELF, new Vec3(v, finalI > 2 ? -0.2 : 0.2, 0.0)));
        }
        scene.world().modifyEntity(entityElement, e -> {
            e.m_146884_(e.m_20182_());
            e.f_19854_ = e.m_20182_().f_82479_;
            e.f_19855_ = e.m_20182_().f_82480_;
            e.f_19856_ = e.m_20182_().f_82481_;
        });
    }

    private static Entity potion(Level level, Vec3 pos) {
        Entity mob = EntityType.f_20486_.m_20615_(level);
        Objects.requireNonNull(mob).m_146884_(pos);
        mob.f_19854_ = pos.f_82479_;
        mob.f_19855_ = pos.f_82480_;
        mob.f_19856_ = pos.f_82481_;
        mob.f_19859_ = 0.0f;
        mob.m_146922_(0.0f);
        return mob;
    }
}

