/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.quark_ponders.ponder.scenes.automation;

import com.leobeliik.quark_ponders.ponder.PonderAux;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.EntityElement;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.foundation.PonderSceneBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.violetmoon.quark.content.automation.block.FeedingTroughBlock;
import org.violetmoon.quark.content.automation.module.FeedingTroughModule;

public class FeedingTroughScene {
    public static void Working(SceneBuilder builder, SceneBuildingUtil util) {
        PonderSceneBuilder scene = new PonderSceneBuilder(builder.getScene());
        BlockPos ft = util.grid().at(2, 1, 2);
        PonderAux.setAgentScene(scene, util, "quark_feeding_trough");
        scene.overlay().showText(40).text("quark_feeding_trough.text_1").attachKeyFrame().placeNearTarget().pointAt(ft.m_252807_());
        scene.idle(60);
        scene.overlay().showText(60).text("quark_feeding_trough.text_2", new Object[]{FeedingTroughModule.range}).attachKeyFrame().placeNearTarget().pointAt(ft.m_252807_());
        scene.idle(80);
        ArrayList<ElementLink<EntityElement>> animals = new ArrayList<ElementLink<EntityElement>>();
        FeedingTroughScene.cowGen(animals, scene);
        scene.idle(20);
        scene.overlay().showControls(ft.m_252807_(), Pointing.DOWN, 20).withItem(Items.f_42405_.m_7968_());
        scene.world().modifyBlock(ft, s -> (BlockState)s.m_61124_((Property)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(30);
        FeedingTroughScene.moveCows(animals, scene);
        FeedingTroughScene.cowBreed(animals, scene, util, ft);
        scene.idle(30);
        scene.rotateCameraY(360.0f);
        scene.setSceneOffsetY(0.0f);
        scene.idle(20);
        scene.effects().emitParticles(ft.m_122029_().m_252807_(), scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f), 1.0f), Vec3.f_82478_), 150.0f, 1);
        scene.effects().emitParticles(ft.m_122024_().m_252807_(), scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f), 1.0f), Vec3.f_82478_), 150.0f, 1);
        scene.effects().emitParticles(ft.m_7494_().m_252807_(), scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f), 1.0f), Vec3.f_82478_), 150.0f, 1);
        scene.world().modifyBlock(ft, s -> (BlockState)s.m_61124_((Property)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(false)), false);
        scene.idle(5);
        for (ElementLink elementLink : animals) {
            scene.world().modifyEntity(elementLink, cow -> {
                cow.m_6842_(true);
                cow.m_6074_();
            });
        }
        animals.clear();
        scene.idle(45);
        FeedingTroughScene.cowGen(animals, scene);
        scene.overlay().showText(60).text("quark_feeding_trough.text_3").attachKeyFrame().placeNearTarget().pointAt(ft.m_252807_());
        scene.idle(80);
        scene.overlay().showControls(ft.m_252807_(), Pointing.DOWN, 20).withItem(Items.f_42405_.m_7968_());
        scene.idle(20);
        scene.world().modifyBlock(ft, s -> (BlockState)s.m_61124_((Property)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(30);
        FeedingTroughScene.moveCows(animals, scene);
        scene.idle(10);
        FeedingTroughScene.cowEating(animals, scene, 5);
        scene.world().modifyBlock(ft, s -> (BlockState)s.m_61124_((Property)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(false)), false);
        scene.idle(20);
        scene.overlay().showControls(ft.m_252807_(), Pointing.UP, 20).withItem(Items.f_42405_.m_7968_());
        scene.world().modifyBlock(ft, s -> (BlockState)s.m_61124_((Property)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(20);
        FeedingTroughScene.cowBreed(animals, scene, util, ft);
        scene.overlay().showText(80).text("quark_feeding_trough.text_4", new Object[]{FeedingTroughModule.maxAnimals, FeedingTroughModule.range}).attachKeyFrame().placeNearTarget().pointAt(ft.m_252807_());
        scene.idle(100);
        scene.markAsFinished();
    }

    private static void cowBreed(List<ElementLink<EntityElement>> animals, PonderSceneBuilder scene, SceneBuildingUtil util, BlockPos pos) {
        FeedingTroughScene.cowEating(animals, scene, 1);
        scene.effects().emitParticles(pos.m_7494_().m_252807_(), scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123750_, util.vector().of(0.0, 0.0, 0.0)), 3.0f, 5);
        scene.idle(15);
        animals.add((ElementLink<EntityElement>)scene.world().createEntity(l -> {
            Cow cow = (Cow)PonderAux.newEntity(EntityType.f_20557_, l, new Vec3(2.5, 1.75, 2.5), 90);
            cow.m_6863_(true);
            return cow;
        }));
    }

    private static void cowEating(List<ElementLink<EntityElement>> animals, PonderSceneBuilder scene, int munch) {
        for (int i = 0; i <= munch; ++i) {
            for (ElementLink<EntityElement> animal : animals) {
                int finalI = i;
                scene.world().modifyEntity(animal, cow -> cow.m_146926_(finalI % 2 == 0 ? 45.0f : 0.0f));
                scene.idle(2);
            }
        }
    }

    private static void moveCows(List<ElementLink<EntityElement>> animals, PonderSceneBuilder scene) {
        for (int i = 0; i < 10; ++i) {
            scene.idle(1);
            scene.world().modifyEntity(animals.get(0), cow -> cow.m_6478_(MoverType.SELF, new Vec3(0.2, 0.0, 0.0)));
            scene.world().modifyEntity(animals.get(1), cow -> cow.m_6478_(MoverType.SELF, new Vec3(-0.2, 0.0, 0.0)));
        }
        for (ElementLink<EntityElement> entity : animals) {
            scene.world().modifyEntity(entity, e -> {
                e.m_146884_(e.m_20182_());
                e.f_19854_ = e.m_20182_().f_82479_;
            });
        }
    }

    private static void cowGen(List<ElementLink<EntityElement>> animals, PonderSceneBuilder scene) {
        animals.add((ElementLink<EntityElement>)scene.world().createEntity(l -> PonderAux.newEntity(EntityType.f_20557_, l, new Vec3(0.0, 1.0, 2.5), -90)));
        animals.add((ElementLink<EntityElement>)scene.world().createEntity(l -> PonderAux.newEntity(EntityType.f_20557_, l, new Vec3(5.0, 1.0, 2.5), 90)));
    }
}

