/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.quark_ponders.ponder;

import java.util.Objects;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.EntityElement;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.foundation.PonderSceneBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;

public class PonderAux {
    public static Block getBlock(String block) {
        Block quarkBlock = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)block));
        return quarkBlock == null ? Blocks.f_50016_ : quarkBlock;
    }

    public static void setScene(PonderSceneBuilder scene, SceneBuildingUtil util, String name) {
        scene.title(name, "header");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world().showSection(util.select().position(5, 5, 5), Direction.DOWN);
        scene.idle(5);
    }

    public static void setAgentScene(PonderSceneBuilder scene, SceneBuildingUtil util, String name) {
        PonderAux.setScene(scene, util, name);
        scene.world().showIndependentSection(util.select().fromTo(0, 1, 0, 5, 5, 5), Direction.DOWN);
        scene.idle(25);
    }

    public static Entity newEntity(EntityType entity, Level level, Vec3 pos, int rotation) {
        LivingEntity mob = (LivingEntity)entity.m_20615_(level);
        WalkAnimationState animation = Objects.requireNonNull(mob).f_267362_;
        animation.m_267566_(-animation.m_267756_(), 1.0f);
        animation.m_267771_(1.0f);
        mob.m_146884_(pos);
        mob.f_19854_ = pos.f_82479_;
        mob.f_19855_ = pos.f_82480_;
        mob.f_19856_ = pos.f_82481_;
        mob.f_19859_ = rotation;
        mob.m_146922_((float)rotation);
        mob.f_20886_ = rotation;
        mob.f_20885_ = rotation;
        return mob;
    }

    public static Entity staticItem(Level level, Vec3 pos, int rot, ItemStack item) {
        ArmorStand stand = (ArmorStand)EntityType.f_20529_.m_20615_(level);
        SynchedEntityData dataManager = Objects.requireNonNull(stand).m_20088_();
        dataManager.m_135381_(ArmorStand.f_31524_, (Object)1);
        stand.m_146884_(pos);
        stand.f_19854_ = pos.f_82479_;
        stand.f_19855_ = pos.f_82480_;
        stand.f_19856_ = pos.f_82481_;
        stand.m_146922_((float)rot);
        stand.f_19859_ = rot;
        stand.m_6842_(true);
        stand.m_8061_(EquipmentSlot.MAINHAND, item);
        stand.f_19794_ = true;
        return stand;
    }

    public static void entityMove(ElementLink<EntityElement> entityElement, PonderSceneBuilder scene, int dist, Direction dir) {
        double z;
        double y;
        double x;
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            x = 0.0;
            y = 0.0;
            z = dir == Direction.NORTH ? -0.2 : 0.2;
        } else if (dir == Direction.EAST || dir == Direction.WEST) {
            x = dir == Direction.EAST ? -0.2 : 0.2;
            y = 0.0;
            z = 0.0;
        } else {
            z = 0.0;
            y = dir == Direction.UP ? 0.2 : -0.2;
            x = 0.0;
        }
        for (int i = 0; i < dist * 5; ++i) {
            scene.idle(1);
            scene.world().modifyEntity(entityElement, entity -> entity.m_6478_(MoverType.SELF, new Vec3(x, y, z)));
        }
        scene.world().modifyEntity(entityElement, e -> {
            e.m_146884_(e.m_20182_());
            e.f_19854_ = e.m_20182_().f_82479_;
            e.f_19855_ = e.m_20182_().f_82480_;
            e.f_19856_ = e.m_20182_().f_82481_;
        });
    }

    public static void clickLampButton(PonderSceneBuilder scene, SceneBuildingUtil util, BlockPos button, BlockPos lamp, boolean lit, boolean pointFromAbove) {
        if (lit) {
            scene.overlay().showControls(button.m_252807_().m_82549_(pointFromAbove ? util.vector().of(0.75, -0.4, 0.5) : util.vector().of(0.75, -0.65, 0.5)), pointFromAbove ? Pointing.DOWN : Pointing.UP, 25).rightClick();
        }
        scene.world().toggleRedstonePower(util.select().position(button));
        for (int i = 0; i < 10; ++i) {
            scene.world().modifyBlock(lamp, s -> (BlockState)s.m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(lit)), false);
        }
    }

    public static void clickLampButtonTop(PonderSceneBuilder scene, SceneBuildingUtil util, BlockPos button, boolean lit, boolean pointFromAbove) {
        if (lit) {
            scene.overlay().showControls(button.m_252807_(), pointFromAbove ? Pointing.DOWN : Pointing.UP, 25).rightClick();
        }
        scene.world().toggleRedstonePower(util.select().position(button));
        scene.world().modifyBlock(button.m_7495_(), s -> (BlockState)s.m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(lit)), false);
    }

    public static Entity spawnPlayer(PonderSceneBuilder scene, Level level, Vec3 pos, int rot) {
        Entity armorStand = PonderAux.newEntity(EntityType.f_20529_, level, pos, rot);
        armorStand.m_6842_(true);
        ItemStack head = Items.f_42680_.m_7968_();
        CompoundTag tag = head.m_41784_();
        ListTag enchantments = tag.m_128437_("Enchantments", 10);
        CompoundTag bindingCurse = new CompoundTag();
        bindingCurse.m_128359_("id", "minecraft:binding_curse");
        bindingCurse.m_128376_("lvl", (short)1);
        enchantments.add((Object)bindingCurse);
        tag.m_128365_("Enchantments", (Tag)enchantments);
        head.m_41751_(tag);
        armorStand.m_8061_(EquipmentSlot.HEAD, head);
        armorStand.m_8061_(EquipmentSlot.CHEST, Items.f_42469_.m_7968_());
        armorStand.m_8061_(EquipmentSlot.LEGS, Items.f_42470_.m_7968_());
        armorStand.m_8061_(EquipmentSlot.FEET, Items.f_42471_.m_7968_());
        return armorStand;
    }

    public static void setSmoke(PonderSceneBuilder scene, BlockPos pos) {
        scene.effects().emitParticles(pos.m_252807_(), scene.effects().particleEmitterWithinBlockSpace((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f), 1.0f), Vec3.f_82478_), 150.0f, 1);
    }
}

