/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.util;

import com.jab125.mpuc.api.MarkdownRenderer;
import com.jab125.mpuc.api.ModpackInfo;
import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.client.gui.widget.flow.FlowMarkdownUtils;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MpucApiImpl
implements MpucApi {
    public static final MpucApi INSTANCE = new MpucApiImpl();
    private static final String MODID = "modpackupdatechecker";
    private static final Platform.Mod FAIL = new Platform.Mod(){

        @Override
        public String getId() {
            return MpucApiImpl.MODID;
        }

        @Override
        public String getVersion() {
            return "0.0NONE";
        }
    };

    private static MpucConfig getConfig() {
        return ConfigInstances.getModpackUpdateCheckerConfig();
    }

    @Override
    public String getModpackName() {
        return MpucApiImpl.getConfig().modpackName;
    }

    @Override
    public String getCurrentModpackVersion() {
        return MpucApiImpl.getConfig().currentVersion;
    }

    @Override
    public String getLatestModpackVersion() {
        OnlineInfo associatedOnlineInfo = MpucApiImpl.getConfig().getAssociatedOnlineInfo();
        if (associatedOnlineInfo.isErrored() || associatedOnlineInfo.isDisabled()) {
            return this.getCurrentModpackVersion();
        }
        return MpucApiImpl.getConfig().getAssociatedOnlineInfo().latestVersion;
    }

    @Override
    public String getModpackReleaseType() {
        return MpucApiImpl.getConfig().modpackReleaseType;
    }

    @Override
    public String getModVersion() {
        return Platform.getModList().stream().filter(a -> MODID.equals(a.getId())).findFirst().orElse(FAIL).getVersion();
    }

    @Override
    public ModpackInfo getModpackInfo(Object object) {
        if (object instanceof ModpackInfo) {
            return (ModpackInfo)object;
        }
        throw new IllegalStateException(String.valueOf(object.getClass()) + " doesn't implement ModpackInfo!");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerMarkdownRenderer(String id, MarkdownRenderer renderer) {
        FlowMarkdownUtils.COMPILERS.put(id, renderer);
    }
}

