/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.util;

import com.jab125.mpuc.config.MpucConfig;
import java.lang.reflect.Array;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class Events {
    public static Event<ReloadConfig> CONFIG_RELOADED = new Event<ReloadConfig>(ReloadConfig.class, reloadConfigs -> config -> {
        for (ReloadConfig reloadConfig : reloadConfigs) {
            reloadConfig.onReload(config);
        }
    });

    public static <T> T invoker(Event<T> event) {
        return event.invoker();
    }

    public static class Event<T> {
        private final Function<T[], T> function;
        private final Class<T> clazz;
        private T invoker;
        private CopyOnWriteArrayList<T> subscribers = new CopyOnWriteArrayList();

        public void subscribe(T subscriber) {
            this.subscribers.add(subscriber);
            this.updateInvoker();
        }

        public Event(Class<T> clazz, Function<T[], T> function) {
            this.clazz = clazz;
            this.function = function;
            this.updateInvoker();
        }

        private void updateInvoker() {
            this.invoker = this.function.apply((Object[][])this.subscribers.toArray((Object[])Array.newInstance(this.clazz, 0)));
        }

        private T invoker() {
            return this.invoker;
        }
    }

    @FunctionalInterface
    public static interface ReloadConfig {
        public void onReload(MpucConfig var1);
    }
}

