/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.widgets;

import com.jab125.mpuc.client.gui.widget.flow.CoordWrapper;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.Widget;
import com.jab125.mpuc.client.util.Context;
import java.util.Optional;
import net.minecraft.client.Minecraft;

public class FlexFlowWidget
extends FlowWidget {
    private final int maxWidth;
    private final int maxHeight;
    protected int previousRequestedWidth;
    protected int previousRequestedHeight;
    protected int requestedWidth;
    protected int requestedHeight;

    public FlexFlowWidget(Minecraft client, int maxWidth, int maxHeight, FlowWidget.Direction direction) {
        super(client, 0, 0, direction);
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    @Override
    public void markDirty() {
        super.markDirty();
        if (this.parent != null) {
            this.parent.markDirty();
        }
    }

    @Override
    public void bake(int w, int h) {
        super.bake(w, h);
        Optional<Integer> width = this.bakedWidgets.stream().map(CoordWrapper::getRightX).min((a, b) -> b - a);
        Optional<Integer> height = this.bakedWidgets.stream().map(CoordWrapper::getBottomY).min((a, b) -> b - a);
        this.requestedWidth = width.orElse(0);
        this.requestedHeight = height.orElse(0);
    }

    @Override
    public void addChild(Widget widget) {
        super.addChild(widget);
        this.bake(this.maxWidth, this.maxHeight);
    }

    @Override
    public int getRequestedWidth() {
        return this.maxWidth == 0 ? this.requestedWidth : Math.min(this.requestedWidth, this.maxWidth);
    }

    @Override
    public int getRequestedHeight() {
        return this.maxHeight == 0 ? this.requestedHeight : Math.min(this.requestedHeight, this.maxHeight);
    }

    @Override
    public void render(Context context, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.render(context, width, height, mouseX, mouseY, hovered, tickDelta);
    }

    @Override
    public void passThrough() {
        super.passThrough();
        if (!this.baked) {
            this.bake(this.maxWidth, this.maxHeight);
            if (this.parent != null) {
                this.parent.markDirty();
            }
        }
        if (this.requestedHeight != this.previousRequestedHeight || this.requestedWidth != this.previousRequestedWidth) {
            if (this.parent != null) {
                this.parent.markDirty();
            }
            this.previousRequestedWidth = this.requestedWidth;
            this.previousRequestedHeight = this.requestedHeight;
        }
    }
}

