/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.mixins.enhanced_fps_limiter;

import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={RenderSystem.class}, remap=false)
public class RenderSystemMixin {
    @Unique
    private static final long MILLIS_IN_A_SECOND = 1000L;
    @Unique
    private static final long NANOS_IN_A_SECOND = 1000000000L;
    @Unique
    private static final double MICROSECOND = 1.0E-6;
    @Unique
    private static final double AHEAD_THRESHOLD = 9.999999999999999E-6;
    @Unique
    private static final double SLEEP_OFFSET = 5.0E-4;
    @Unique
    private static final double SLEEP_THRESHOLD = 0.0015;
    @Shadow
    private static double lastDrawTime;

    @Overwrite
    public static void limitDisplayFPS(int i) {
        double frameTime = 1.0 / (double)i;
        double target = lastDrawTime + frameTime;
        double now = GLFW.glfwGetTime();
        double wait = target - now;
        if (wait > 0.0015) {
            long millis = (long)((wait -= 5.0E-4) * 1000.0);
            int nanos = (int)(wait * 1.0E9 - (double)millis * 1000000.0);
            try {
                Thread.sleep(millis, nanos);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        lastDrawTime = now = RenderSystemMixin.ixeris$busyWait(target);
    }

    @Unique
    private static double ixeris$busyWait(double target) {
        double now;
        while (target - (now = GLFW.glfwGetTime()) > 9.999999999999999E-6) {
        }
        return now;
    }
}

