/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.annotations.CStub;
import me.decce.ixeris.core.shadow.classtransform.exceptions.TransformerException;
import me.decce.ixeris.core.shadow.classtransform.transformer.types.RemovingAnnotationHandler;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.Codifier;
import me.decce.ixeris.core.shadow.classtransform.utils.MemberDeclaration;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@ParametersAreNonnullByDefault
public class CStubAnnotationHandler
extends RemovingAnnotationHandler<CStub> {
    public CStubAnnotationHandler() {
        super(CStub.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void transform(CStub annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod) {
        MethodNode method2;
        BiConsumer<MethodNode, InsnList> instructionGenerator;
        block34: {
            boolean isStatic;
            ClassNode stubOwner;
            MemberDeclaration memberDeclaration;
            Type stubReturn;
            Type[] stubArgs;
            block35: {
                Type memberType;
                block36: {
                    if (!Modifier.isStatic(transformerMethod.access)) {
                        throw TransformerException.wrongStaticAccess(transformerMethod, transformer, true);
                    }
                    stubArgs = Type.getArgumentTypes((String)transformerMethod.desc);
                    stubReturn = Type.getReturnType((String)transformerMethod.desc);
                    memberDeclaration = ASMUtils.splitMemberDeclaration(annotation.value());
                    if (memberDeclaration == null) {
                        throw TransformerException.invalidMemberDeclaration(transformerMethod, transformer, annotation.value());
                    }
                    stubOwner = null;
                    if (annotation.memberValidation()) {
                        try {
                            stubOwner = ASMUtils.fromBytes(transformerManager.getClassProvider().getClass(memberDeclaration.getOwner()));
                        }
                        catch (Throwable t) {
                            throw new TransformerException(transformerMethod, transformer, "has unknown stub class '" + memberDeclaration.getOwner() + "'");
                        }
                    }
                    if (!memberDeclaration.isFieldMapping()) break block35;
                    if (annotation.memberValidation()) {
                        FieldNode field = ASMUtils.getField(stubOwner, memberDeclaration.getName(), memberDeclaration.getDesc());
                        if (field == null) {
                            throw new TransformerException(transformerMethod, transformer, "has unknown stub field '" + memberDeclaration.getName() + "'");
                        }
                        isStatic = Modifier.isStatic(field.access);
                        if (annotation.access() == CStub.Access.STATIC && !isStatic) {
                            throw new TransformerException(transformerMethod, transformer, "has static stub field '" + memberDeclaration.getName() + "' but the field is not static");
                        }
                        if (annotation.access() == CStub.Access.NON_STATIC && isStatic) {
                            throw new TransformerException(transformerMethod, transformer, "has non-static stub field '" + memberDeclaration.getName() + "' but the field is static");
                        }
                    } else {
                        if (annotation.access() == CStub.Access.AUTO) {
                            throw new TransformerException(transformerMethod, transformer, "has invalid access type AUTO");
                        }
                        isStatic = annotation.access() == CStub.Access.STATIC;
                    }
                    memberType = Type.getType((String)memberDeclaration.getDesc());
                    if (!isStatic) break block36;
                    if (stubArgs.length == 0 && ASMUtils.compareType(memberType, stubReturn)) {
                        instructionGenerator = (method, instructions) -> {
                            instructions.add((AbstractInsnNode)new FieldInsnNode(178, memberDeclaration.getOwner(), memberDeclaration.getName(), memberDeclaration.getDesc()));
                            if (!stubReturn.equals((Object)memberType)) {
                                instructions.add(ASMUtils.getCast(stubReturn));
                            }
                        };
                        break block34;
                    } else if (stubArgs.length == 1 && ASMUtils.compareType(memberType, stubArgs[0]) && stubReturn.equals((Object)Type.VOID_TYPE)) {
                        instructionGenerator = (method, instructions) -> {
                            if (!stubArgs[0].equals((Object)memberType)) {
                                instructions.add(ASMUtils.getCast(memberType));
                            }
                            instructions.add((AbstractInsnNode)new FieldInsnNode(179, memberDeclaration.getOwner(), memberDeclaration.getName(), memberDeclaration.getDesc()));
                        };
                        break block34;
                    } else {
                        String getHelp = Codifier.get().access(264).returnType(memberType).name(transformerMethod.name).build();
                        String setHelp = Codifier.get().access(264).returnType(Type.VOID_TYPE).param(memberType).name(transformerMethod.name).build();
                        throw new TransformerException(transformerMethod, transformer, "has invalid signature").help("'" + getHelp + "' or '" + setHelp + "'");
                    }
                }
                Type memberOwnerType = Type.getObjectType((String)memberDeclaration.getOwner());
                if (stubArgs.length == 1 && ASMUtils.compareType(memberOwnerType, stubArgs[0]) && ASMUtils.compareType(memberType, stubReturn)) {
                    instructionGenerator = (method, instructions) -> {
                        if (!memberOwnerType.equals((Object)stubArgs[0])) {
                            instructions.add(ASMUtils.getCast(memberOwnerType));
                        }
                        instructions.add((AbstractInsnNode)new FieldInsnNode(180, memberDeclaration.getOwner(), memberDeclaration.getName(), memberDeclaration.getDesc()));
                        if (!stubReturn.equals((Object)memberType)) {
                            instructions.add(ASMUtils.getCast(stubReturn));
                        }
                    };
                    break block34;
                } else if (stubArgs.length == 2 && ASMUtils.compareType(memberOwnerType, stubArgs[0]) && ASMUtils.compareType(memberType, stubArgs[1]) && stubReturn.equals((Object)Type.VOID_TYPE)) {
                    instructionGenerator = (method, instructions) -> {
                        if (!memberOwnerType.equals((Object)stubArgs[0])) {
                            instructions.add(ASMUtils.swap(stubArgs[0], stubArgs[1]));
                            instructions.add(ASMUtils.getCast(memberOwnerType));
                            instructions.add(ASMUtils.swap(stubArgs[1], memberOwnerType));
                        }
                        if (!memberType.equals((Object)stubArgs[1])) {
                            instructions.add(ASMUtils.getCast(memberType));
                        }
                        instructions.add((AbstractInsnNode)new FieldInsnNode(181, memberDeclaration.getOwner(), memberDeclaration.getName(), memberDeclaration.getDesc()));
                    };
                    break block34;
                } else {
                    String getHelp = Codifier.get().access(264).returnType(memberType).param(memberOwnerType).name(transformerMethod.name).build();
                    String setHelp = Codifier.get().access(264).returnType(Type.VOID_TYPE).params(memberOwnerType, memberType).name(transformerMethod.name).build();
                    throw new TransformerException(transformerMethod, transformer, "has invalid parameters").help("'" + getHelp + "' or '" + setHelp + "'");
                }
            }
            if (annotation.memberValidation()) {
                method2 = ASMUtils.getMethod(stubOwner, memberDeclaration.getName(), memberDeclaration.getDesc());
                if (method2 == null) {
                    throw new TransformerException(transformerMethod, transformer, "has unknown stub method '" + memberDeclaration.getName() + "'");
                }
                isStatic = Modifier.isStatic(method2.access);
                if (annotation.access() == CStub.Access.STATIC && !isStatic) {
                    throw new TransformerException(transformerMethod, transformer, "has static stub method '" + memberDeclaration.getName() + "' but the method is not static");
                }
                if (annotation.access() == CStub.Access.NON_STATIC && isStatic) {
                    throw new TransformerException(transformerMethod, transformer, "has non-static stub method '" + memberDeclaration.getName() + "' but the method is static");
                }
            } else {
                if (annotation.access() == CStub.Access.AUTO) {
                    throw new TransformerException(transformerMethod, transformer, "has invalid access type AUTO");
                }
                isStatic = annotation.access() == CStub.Access.STATIC;
            }
            Type[] memberArgs = Type.getArgumentTypes((String)memberDeclaration.getDesc());
            Type memberReturn = Type.getReturnType((String)memberDeclaration.getDesc());
            if (isStatic) {
                if (ASMUtils.compareTypes(stubArgs, memberArgs) && ASMUtils.compareType(stubReturn, memberReturn)) {
                    instructionGenerator = (method, instructions) -> {
                        int i;
                        int currentArgIndex = ASMUtils.getFreeVarIndex(method);
                        int[] argsIndices = new int[stubArgs.length];
                        for (i = stubArgs.length - 1; i >= 0; --i) {
                            argsIndices[i] = currentArgIndex;
                            instructions.add((AbstractInsnNode)new VarInsnNode(stubArgs[i].getOpcode(54), currentArgIndex));
                            currentArgIndex += stubArgs[i].getSize();
                        }
                        for (i = 0; i < memberArgs.length; ++i) {
                            instructions.add((AbstractInsnNode)new VarInsnNode(memberArgs[i].getOpcode(21), argsIndices[i]));
                            if (memberArgs[i].equals((Object)stubArgs[i])) continue;
                            instructions.add(ASMUtils.getCast(memberArgs[i]));
                        }
                        instructions.add((AbstractInsnNode)new MethodInsnNode(184, memberDeclaration.getOwner(), memberDeclaration.getName(), memberDeclaration.getDesc()));
                    };
                    break block34;
                } else {
                    throw new TransformerException(transformerMethod, transformer, "has invalid parameters").help(Codifier.get().access(264).returnType(memberReturn).params(memberArgs).name(transformerMethod.name));
                }
            }
            Type memberOwnerType = Type.getObjectType((String)memberDeclaration.getOwner());
            if (ASMUtils.compareTypes(memberArgs, stubArgs, true, memberOwnerType) && ASMUtils.compareType(stubReturn, memberReturn)) {
                instructionGenerator = (method, instructions) -> {
                    int i;
                    int currentArgIndex = ASMUtils.getFreeVarIndex(method);
                    int[] argsIndices = new int[stubArgs.length];
                    for (i = stubArgs.length - 1; i >= 0; --i) {
                        argsIndices[i] = currentArgIndex;
                        instructions.add((AbstractInsnNode)new VarInsnNode(stubArgs[i].getOpcode(54), currentArgIndex));
                        currentArgIndex += stubArgs[i].getSize();
                    }
                    instructions.add((AbstractInsnNode)new VarInsnNode(memberOwnerType.getOpcode(21), argsIndices[0]));
                    if (!memberOwnerType.equals((Object)stubArgs[0])) {
                        instructions.add(ASMUtils.getCast(memberOwnerType));
                    }
                    for (i = 0; i < memberArgs.length; ++i) {
                        instructions.add((AbstractInsnNode)new VarInsnNode(memberArgs[i].getOpcode(21), argsIndices[i + 1]));
                        if (memberArgs[i].equals((Object)stubArgs[i + 1])) continue;
                        instructions.add(ASMUtils.getCast(memberArgs[i]));
                    }
                    instructions.add((AbstractInsnNode)new MethodInsnNode(182, memberDeclaration.getOwner(), memberDeclaration.getName(), memberDeclaration.getDesc()));
                };
            } else {
                throw new TransformerException(transformerMethod, transformer, "has invalid parameters").help(Codifier.get().access(264).returnType(memberReturn).param(memberOwnerType).params(memberArgs).name(transformerMethod.name));
            }
        }
        Iterator iterator = transformer.methods.iterator();
        block2: while (iterator.hasNext()) {
            method2 = (MethodNode)iterator.next();
            AbstractInsnNode[] abstractInsnNodeArray = method2.instructions.toArray();
            int n = abstractInsnNodeArray.length;
            int n2 = 0;
            while (true) {
                MethodInsnNode methodInsn;
                if (n2 >= n) continue block2;
                AbstractInsnNode instruction = abstractInsnNodeArray[n2];
                if (instruction instanceof MethodInsnNode && (methodInsn = (MethodInsnNode)instruction).getOpcode() == 184 && methodInsn.owner.equals(transformer.name) && methodInsn.name.equals(transformerMethod.name) && methodInsn.desc.equals(transformerMethod.desc)) {
                    InsnList instructions2 = new InsnList();
                    instructionGenerator.accept(method2, instructions2);
                    method2.instructions.insert(instruction, instructions2);
                    method2.instructions.remove(instruction);
                }
                ++n2;
            }
            break;
        }
        return;
    }
}

