/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.annotations.CSlice;
import me.decce.ixeris.core.shadow.classtransform.annotations.CTarget;
import me.decce.ixeris.core.shadow.classtransform.annotations.injection.CModifyConstant;
import me.decce.ixeris.core.shadow.classtransform.exceptions.TransformerException;
import me.decce.ixeris.core.shadow.classtransform.targets.IInjectionTarget;
import me.decce.ixeris.core.shadow.classtransform.transformer.coprocessor.AnnotationCoprocessorList;
import me.decce.ixeris.core.shadow.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.Codifier;
import me.decce.ixeris.core.shadow.classtransform.utils.Types;
import me.decce.ixeris.core.shadow.classtransform.utils.annotations.IParsedAnnotation;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@ParametersAreNonnullByDefault
public class CModifyConstantAnnotationHandler
extends RemovingTargetAnnotationHandler<CModifyConstant>
implements IInjectionTarget {
    public CModifyConstantAnnotationHandler() {
        super(CModifyConstant.class, CModifyConstant::method);
    }

    @Override
    public void transform(CModifyConstant annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        Type constantType;
        boolean hasTypeValue;
        boolean hasStringValue;
        boolean hasDoubleValue;
        boolean hasFloatValue;
        boolean hasLongValue;
        boolean hasIntValue;
        AnnotationCoprocessorList coprocessors = transformerManager.getCoprocessors();
        transformerMethod = coprocessors.preprocess(transformerManager, transformedClass, target, transformer, transformerMethod);
        IParsedAnnotation parsedAnnotation = (IParsedAnnotation)((Object)annotation);
        boolean hasNullValue = parsedAnnotation.wasSet("nullValue");
        if (this.getTrueCount(hasNullValue, hasIntValue = parsedAnnotation.wasSet("intValue"), hasLongValue = parsedAnnotation.wasSet("longValue"), hasFloatValue = parsedAnnotation.wasSet("floatValue"), hasDoubleValue = parsedAnnotation.wasSet("doubleValue"), hasStringValue = parsedAnnotation.wasSet("stringValue"), hasTypeValue = parsedAnnotation.wasSet("typeValue")) != 1) {
            throw new TransformerException(transformerMethod, transformer, "must have exactly one target constant");
        }
        if (hasNullValue) {
            constantType = null;
        } else if (hasIntValue) {
            constantType = Type.INT_TYPE;
        } else if (hasLongValue) {
            constantType = Type.LONG_TYPE;
        } else if (hasFloatValue) {
            constantType = Type.FLOAT_TYPE;
        } else if (hasDoubleValue) {
            constantType = Type.DOUBLE_TYPE;
        } else if (hasStringValue) {
            constantType = Types.type(String.class);
        } else if (hasTypeValue) {
            constantType = Types.type(Class.class);
        } else {
            throw new IllegalStateException("Unknown return type wanted because of unknown constant. If you see this, please report this to the developer.");
        }
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        Type[] transformerArguments = Types.argumentTypes(transformerMethod.desc);
        if (constantType != null) {
            if (!(transformerArguments.length == 0 || transformerArguments.length == 1 && transformerArguments[0].equals((Object)constantType))) {
                throw new TransformerException(transformerMethod, transformer, "must have no arguments or the constant as argument").help(Codifier.of(transformerMethod).param(null).param(constantType));
            }
            if (!Types.returnType(transformerMethod.desc).equals((Object)constantType)) {
                throw new TransformerException(transformerMethod, transformer, "must have return type of modified constant").help(Codifier.of(transformerMethod).returnType(constantType));
            }
        } else {
            if (transformerArguments.length != 0) {
                throw new TransformerException(transformerMethod, transformer, "must have no arguments").help(Codifier.of(transformerMethod).param(null));
            }
            Type methodReturnType = Types.returnType(transformerMethod.desc);
            if (methodReturnType.equals((Object)Type.VOID_TYPE) || methodReturnType.getDescriptor().length() == 1) {
                throw new TransformerException(transformerMethod, transformer, "must have any object return type").help(Codifier.of(transformerMethod).returnType(Types.type(Object.class)));
            }
        }
        MethodNode copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CModifyConstant");
        ArrayList<AbstractInsnNode> toReplace = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode instruction : this.getSlice(transformerManager.getInjectionTargets(), target, annotation.slice())) {
            Number number;
            if (hasNullValue) {
                if (instruction.getOpcode() != 1 || !annotation.nullValue()) continue;
                toReplace.add(instruction);
                continue;
            }
            if (hasIntValue) {
                number = ASMUtils.getNumber(instruction);
                if (!(number instanceof Byte) && !(number instanceof Short) && !(number instanceof Integer) || number.intValue() != annotation.intValue()) continue;
                toReplace.add(instruction);
                continue;
            }
            if (hasLongValue) {
                number = ASMUtils.getNumber(instruction);
                if (!(number instanceof Long) || number.longValue() != annotation.longValue()) continue;
                toReplace.add(instruction);
                continue;
            }
            if (hasFloatValue) {
                number = ASMUtils.getNumber(instruction);
                if (!(number instanceof Float) || number.floatValue() != annotation.floatValue()) continue;
                toReplace.add(instruction);
                continue;
            }
            if (hasDoubleValue) {
                number = ASMUtils.getNumber(instruction);
                if (!(number instanceof Double) || number.doubleValue() != annotation.doubleValue()) continue;
                toReplace.add(instruction);
                continue;
            }
            if (hasStringValue) {
                if (instruction.getOpcode() != 18 || !((LdcInsnNode)instruction).cst.equals(annotation.stringValue())) continue;
                toReplace.add(instruction);
                continue;
            }
            if (!hasTypeValue || instruction.getOpcode() != 18 || !((LdcInsnNode)instruction).cst.equals(Types.type(parsedAnnotation.getValues().get("typeValue")))) continue;
            toReplace.add(instruction);
        }
        if (toReplace.isEmpty() && !annotation.optional()) {
            throw new TransformerException(transformerMethod, transformer, "target constant could not be found").help("e.g. intValue = 0");
        }
        ArrayList<MethodInsnNode> transformerMethodCalls = new ArrayList<MethodInsnNode>();
        for (int i = 0; i < toReplace.size(); ++i) {
            MethodInsnNode invoke;
            AbstractInsnNode instruction = (AbstractInsnNode)toReplace.get(i);
            if (annotation.ordinal() != -1 && i != annotation.ordinal()) continue;
            if (!Modifier.isStatic(transformerMethod.access)) {
                target.instructions.insertBefore(instruction, (AbstractInsnNode)new VarInsnNode(25, 0));
                invoke = new MethodInsnNode(Modifier.isInterface(transformedClass.access) ? 185 : 182, transformedClass.name, transformerMethod.name, transformerMethod.desc);
            } else {
                invoke = new MethodInsnNode(184, transformedClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(transformedClass.access));
            }
            if (transformerArguments.length == 1) {
                target.instructions.insert(instruction, (AbstractInsnNode)invoke);
            } else {
                target.instructions.set(instruction, (AbstractInsnNode)invoke);
            }
            transformerMethodCalls.add(invoke);
        }
        coprocessors.postprocess(transformerManager, transformedClass, target, transformerMethodCalls, transformer, copiedTransformerMethod);
    }

    private int getTrueCount(boolean ... booleans) {
        int count = 0;
        for (boolean b : booleans) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<AbstractInsnNode> getTargets(Map<String, IInjectionTarget> injectionTargets, MethodNode method, CTarget target, @Nullable CSlice slice) {
        return null;
    }
}

