/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.mappings.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import me.decce.ixeris.core.shadow.classtransform.mappings.AMapper;
import me.decce.ixeris.core.shadow.classtransform.mappings.MapperConfig;
import me.decce.ixeris.core.shadow.classtransform.utils.IOSupplier;

@ParametersAreNonnullByDefault
public class SrgMapper
extends AMapper {
    private static final String CLASS_LINE = "^CL: (\\S+) (\\S+)$";
    private static final String FIELD_LINE = "^FD: (\\S+)/(\\S+) (\\S+)/(\\S+)$";
    private static final String METHOD_LINE = "^MD: (\\S+)/(\\S+) (\\(\\S*\\)\\S+) (\\S+)/(\\S+) (\\(\\S*\\)\\S+)$";
    private final IOSupplier<InputStream> mappingsSupplier;

    public SrgMapper(MapperConfig config, @WillClose InputStream mappingsStream) {
        super(config);
        this.mappingsSupplier = () -> mappingsStream;
    }

    public SrgMapper(MapperConfig config, File mappingsFile) {
        super(config);
        this.mappingsSupplier = () -> new FileInputStream(mappingsFile);
    }

    @Override
    protected void init() throws Throwable {
        for (String line : this.readLines(this.mappingsSupplier.get())) {
            String obfName;
            String obfOwner;
            Matcher m;
            if (line.trim().isEmpty()) continue;
            String error = null;
            if (line.matches(CLASS_LINE)) {
                m = Pattern.compile(CLASS_LINE).matcher(line);
                if (m.find()) {
                    String obfName2 = m.group(1);
                    String deobfName = m.group(2);
                    this.remapper.addClassMapping(obfName2, deobfName);
                } else {
                    error = "Could not parse class line: " + line;
                }
            } else if (line.matches(FIELD_LINE)) {
                m = Pattern.compile(FIELD_LINE).matcher(line);
                if (m.find()) {
                    obfOwner = m.group(1);
                    obfName = m.group(2);
                    String deobfName = m.group(4);
                    this.remapper.addFieldMapping(obfOwner, obfName, deobfName);
                } else {
                    error = "Could not parse field line: " + line;
                }
            } else if (line.matches(METHOD_LINE)) {
                m = Pattern.compile(METHOD_LINE).matcher(line);
                if (m.find()) {
                    obfOwner = m.group(1);
                    obfName = m.group(2);
                    String obfDesc = m.group(3);
                    String deobfName = m.group(5);
                    this.remapper.addMethodMapping(obfOwner, obfName, obfDesc, deobfName);
                } else {
                    error = "Could not parse method line: " + line;
                }
            } else {
                error = "Unknown line: " + line;
            }
            if (error == null) continue;
            throw new IllegalStateException(error);
        }
    }
}

