/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.api;

import java.util.function.Supplier;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.threading.MainThreadDispatcher;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;

public class IxerisApi {
    private static final IxerisApi instance = new IxerisApi();

    public static IxerisApi getInstance() {
        return instance;
    }

    public String getMainThreadName() {
        return "Ixeris Event Polling Thread";
    }

    public boolean isInitialized() {
        return Ixeris.mainThread != null;
    }

    public boolean isOnMainThreadOrInit() {
        return Ixeris.isOnMainThread();
    }

    public boolean isOnMainThread() {
        return this.isOnMainThreadOrInit() && this.isInitialized();
    }

    public void runOnMainThread(Runnable runnable) {
        MainThreadDispatcher.run(runnable);
    }

    public void runNowOnMainThread(Runnable runnable) {
        MainThreadDispatcher.runNow(runnable);
    }

    public void runLaterOnMainThread(Runnable runnable) {
        MainThreadDispatcher.runLater(runnable);
    }

    public <T> T query(Supplier<T> supplier) {
        return MainThreadDispatcher.query(supplier);
    }

    public void runLaterOnRenderThread(Runnable runnable) {
        RenderThreadDispatcher.runLater(runnable);
    }
}

