/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import malfu.bc_particle.config.ParticleSettings;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class ParticleSettingsLoader
implements SimpleSynchronousResourceReloadListener {
    public static final ParticleSettingsLoader INSTANCE = new ParticleSettingsLoader();
    private Map<String, List<ParticleSettings>> settingsMap = new HashMap<String, List<ParticleSettings>>();

    public void method_14491(class_3300 resourceManager) {
        HashMap<String, List<ParticleSettings>> combinedMap = new HashMap<String, List<ParticleSettings>>();
        Map resourceMap = resourceManager.method_14488("bc_particle", path -> path.method_12832().endsWith(".json"));
        for (class_2960 resourceId : resourceMap.keySet()) {
            String path2 = resourceId.method_12832();
            if (!path2.endsWith("particle_settings.json")) continue;
            try {
                class_3298 resource = (class_3298)resourceMap.get(resourceId);
                try {
                    InputStream stream = resource.method_14482();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject rootObject = class_3518.method_15255((Reader)reader);
                        JsonObject valuesObject = class_3518.method_15296((JsonObject)rootObject, (String)"values");
                        for (String animationName : valuesObject.keySet()) {
                            JsonElement element = valuesObject.get(animationName);
                            ArrayList<ParticleSettings> settingsList = new ArrayList<ParticleSettings>();
                            if (element.isJsonArray()) {
                                JsonArray settingsArray = element.getAsJsonArray();
                                for (JsonElement settingElement : settingsArray) {
                                    JsonObject settingsObject = settingElement.getAsJsonObject();
                                    ParticleSettings settings = this.parseSettings(settingsObject);
                                    settingsList.add(settings);
                                }
                            } else if (element.isJsonObject()) {
                                JsonObject settingsObject = element.getAsJsonObject();
                                ParticleSettings settings = this.parseSettings(settingsObject);
                                settingsList.add(settings);
                            }
                            combinedMap.put(animationName, settingsList);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse particle settings from: " + String.valueOf(resourceId));
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load particle settings from: " + String.valueOf(resourceId));
                e.printStackTrace();
            }
        }
        this.settingsMap = combinedMap;
        System.out.println("[BC Particles] Loaded settings for " + combinedMap.size() + " animations from client");
    }

    private ParticleSettings parseSettings(JsonObject json) {
        return new ParticleSettings(class_3518.method_15253((JsonObject)json, (String)"particle_type", (String)"none"), class_3518.method_15277((JsonObject)json, (String)"z_addition", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"x_addition", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"y_addition", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"local_yaw", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"pitch_addition", (float)0.0f), class_3518.method_15277((JsonObject)json, (String)"roll_set", (float)0.0f));
    }

    public class_2960 getFabricId() {
        return new class_2960("bc_particle", "settings_loader");
    }

    public List<ParticleSettings> getSettings(String animationName) {
        return this.settingsMap.getOrDefault(animationName, List.of(ParticleSettings.DEFAULT));
    }

    public static void loadNow() {
        class_310 client = class_310.method_1551();
        if (client != null && client.method_1478() != null) {
            INSTANCE.method_14491(client.method_1478());
        }
    }
}

