/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time;

import betterdays.BetterDays;
import betterdays.config.ConfigHandler;
import betterdays.platform.Services;
import betterdays.registry.RegistryObject;
import betterdays.registry.TimeEffectsRegistry;
import betterdays.time.MonotonicInterpolator;
import betterdays.time.SleepStatus;
import betterdays.time.Time;
import betterdays.time.TimeContext;
import betterdays.time.effects.TimeEffect;
import betterdays.utils.MathUtils;
import betterdays.wrappers.ServerLevelWrapper;
import betterdays.wrappers.TimePacketWrapper;
import java.util.Collection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;

public class TimeService {
    public static final Time DAY_START = new Time(ConfigHandler.Common.dayStart());
    public static final Time NIGHT_START = new Time(ConfigHandler.Common.nightStart());
    private static final int OVERFLOW_THRESHOLD = 2147328000;
    private static MonotonicInterpolator monotonicInterpolator;
    public final ServerLevelWrapper level;
    public final SleepStatus sleepStatus;
    private double timeDecimalAccumulator = 0.0;

    public TimeService(ServerLevelWrapper level) {
        this.level = level;
        this.sleepStatus = new SleepStatus(ConfigHandler.Common::enableSleepFeature);
        this.level.setSleepStatus(this.sleepStatus);
        if (ConfigHandler.Common.enableInterpolatedTime()) {
            monotonicInterpolator = new MonotonicInterpolator(ConfigHandler.Common.interpolatedTimePairs(), ConfigHandler.Common.interpolatedTimeSmoothingFactor());
        }
    }

    public void tick() {
        if (!this.level.daylightRuleEnabled()) {
            return;
        }
        Time oldTime = this.getDayTime();
        Time deltaTime = this.tickTime();
        Time time = this.getDayTime();
        TimeContext context = new TimeContext(this, time, deltaTime);
        this.getActiveTimeEffects().forEach(effect -> ((TimeEffect)effect.get()).onTimeTick(context));
        if (ConfigHandler.Common.enableSleepFeature() && !this.sleepStatus.allAwake() && Time.crossedMorning(oldTime, time)) {
            this.handleMorning();
        }
        this.preventTimeOverflow();
        this.broadcastTime();
        this.vanillaTimeCompensation();
    }

    private void handleMorning() {
        long time = ((ServerLevel)this.level.get()).m_46468_();
        Services.PLATFORM.onSleepFinished(this.level, time);
        this.sleepStatus.m_144001_();
        this.level.wakeUpAllPlayers();
        if (this.level.weatherRuleEnabled() && ConfigHandler.Common.clearWeatherOnWake()) {
            this.level.stopWeather();
        }
        BetterDays.LOGGER.debug("Sleep cycle complete on dimension: {}.", (Object)((ServerLevel)this.level.get()).m_46472_().m_135782_());
    }

    private void vanillaTimeCompensation() {
        ((ServerLevel)this.level.get()).m_8615_(((ServerLevel)this.level.get()).m_46468_() - 1L);
    }

    private void preventTimeOverflow() {
        long time = ((ServerLevel)this.level.get()).m_46468_();
        if (time > 2147328000L) {
            ((ServerLevel)this.level.get()).m_8615_(time - 2147328000L);
        }
    }

    private Time tickTime() {
        Time time = this.getDayTime();
        Time timeDelta = new Time(this.getTimeSpeed(time));
        timeDelta = this.correctForOvershoot(time, timeDelta);
        this.setDayTime(time.add(timeDelta));
        return timeDelta;
    }

    private Time correctForOvershoot(Time time, Time timeDelta) {
        Time nextTime = time.add(timeDelta);
        Time timeOfDay = time.timeOfDay();
        Time nextTimeOfDay = nextTime.timeOfDay();
        if (this.sleepStatus.allAwake()) {
            if (NIGHT_START.betweenMod(timeOfDay, nextTimeOfDay)) {
                double nextTimeSpeed = this.getTimeSpeed(nextTime);
                Time timeUntilBreakpoint = NIGHT_START.subtract(timeOfDay);
                double breakpointRatio = 1.0 - timeUntilBreakpoint.divide(timeDelta);
                return timeUntilBreakpoint.add(nextTimeSpeed * breakpointRatio);
            }
            if (DAY_START.betweenMod(timeOfDay, nextTimeOfDay)) {
                double nextTimeSpeed = this.getTimeSpeed(nextTime);
                Time timeUntilBreakpoint = DAY_START.subtract(timeOfDay);
                double breakpointRatio = 1.0 - timeUntilBreakpoint.divide(timeDelta);
                return timeUntilBreakpoint.add(nextTimeSpeed * breakpointRatio);
            }
        } else {
            Time timeUntilMorning = Time.DAY_LENGTH.subtract(timeOfDay);
            if (timeUntilMorning.compareTo(timeDelta) < 0) {
                double nextTimeSpeed = ConfigHandler.Common.daySpeed();
                double breakpointRatio = 1.0 - timeUntilMorning.divide(timeDelta);
                return timeUntilMorning.add(nextTimeSpeed * breakpointRatio);
            }
        }
        return timeDelta;
    }

    public double getTimeSpeed(Time time) {
        if (!ConfigHandler.Common.enableSleepFeature() || this.sleepStatus.allAwake() || this.sleepStatus.ratio() < ConfigHandler.Common.percentPlayersForSleep()) {
            if (ConfigHandler.Common.enableInterpolatedTime()) {
                return monotonicInterpolator.evaluate(time.timeOfDay().longValue());
            }
            if (time.equals(DAY_START) || time.timeOfDay().betweenMod(DAY_START, NIGHT_START)) {
                return ConfigHandler.Common.daySpeed();
            }
            return ConfigHandler.Common.nightSpeed();
        }
        if (this.sleepStatus.allAsleep() && ConfigHandler.Common.sleepSpeedAll() >= 0.0) {
            return ConfigHandler.Common.sleepSpeedAll();
        }
        double sleepRatio = this.sleepStatus.ratio();
        double curve = ConfigHandler.Common.sleepSpeedCurve();
        double speedRatio = MathUtils.normalizedTunableSigmoid(sleepRatio, curve);
        double sleepSpeedMin = ConfigHandler.Common.sleepSpeedMin();
        double sleepSpeedMax = ConfigHandler.Common.sleepSpeedMax();
        double multiplier = MathUtils.lerp(speedRatio, sleepSpeedMin, sleepSpeedMax);
        return multiplier;
    }

    public Time getDayTime() {
        return new Time(((ServerLevel)this.level.get()).m_46468_(), this.timeDecimalAccumulator);
    }

    public Time setDayTime(Time time) {
        this.timeDecimalAccumulator = time.fractionalValue();
        ((ServerLevel)this.level.get()).m_8615_(time.longValue());
        return time;
    }

    public void broadcastTime() {
        TimePacketWrapper timePacket = TimePacketWrapper.create(this.level);
        ((ServerLevel)this.level.get()).m_7654_().m_6846_().m_11314_().stream().filter(player -> this.managesLevel(new ServerLevelWrapper((LevelAccessor)player.m_9236_()))).forEach(player -> player.f_8906_.m_9829_((Packet)timePacket.get()));
    }

    public boolean managesLevel(ServerLevelWrapper levelToCheck) {
        if (((ServerLevel)this.level.get()).equals(levelToCheck.get())) {
            return true;
        }
        return ((ServerLevel)this.level.get()).equals(((ServerLevel)this.level.get()).m_7654_().m_129783_()) && ServerLevelWrapper.isDerived((LevelAccessor)levelToCheck.get());
    }

    private Collection<RegistryObject<TimeEffect>> getActiveTimeEffects() {
        return TimeEffectsRegistry.TIME_EFFECT_REGISTRY.getEntries();
    }
}

