/*
 * Decompiled with CFR 0.152.
 */
package betterdays.config;

import betterdays.client.gui.ScreenAlignment;
import betterdays.config.SpeedMethod;
import betterdays.message.ChatTypeOptions;
import betterdays.message.TemplateMessage;
import betterdays.time.Time;
import betterdays.time.effects.EffectCondition;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;
import technology.roughness.whitenoise.platform.Services;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    public static void init() {
        for (String dimensionKey : (List)ConfigHandler.CLIENT.blacklistDimensions.get()) {
            Client.blacklistDimensionsSet.add(ResourceLocationHelper.mcLoc((String)dimensionKey));
        }
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Client {
        private final WhiteNoiseConfigSpec.EnumValue<ScreenAlignment> clockAlignment;
        private final WhiteNoiseConfigSpec.IntValue clockScale;
        private final WhiteNoiseConfigSpec.IntValue clockMargin;
        private final WhiteNoiseConfigSpec.BooleanValue preventClockWobble;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistDimensions;
        private static final List<String> blacklistDimensionsList = List.of("blacklistDimensions");
        private static final String[] defaultBlacklistDimensions = new String[]{"aether:the_aether"};
        private static final Set<ResourceLocation> blacklistDimensionsSet = Sets.newHashSet();
        private static final Predicate<Object> resourceLocationValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[:]{1}[a-z_]+");

        public Client(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("gui");
            this.clockAlignment = builder.comment("Sets the screen alignment of the bed clock.").defineEnum("clockAlignment", (Enum)ScreenAlignment.TOP_RIGHT);
            this.clockScale = builder.comment("Sets the scale of the bed clock.").defineInRange("clockScale", 64, 1, Integer.MAX_VALUE);
            this.clockMargin = builder.comment(new String[]{"Sets the distance between the clock and the edge of the screen.", "Unused if clockAlignment is CENTER_CENTER."}).defineInRange("clockMargin", 16, 0, Integer.MAX_VALUE);
            this.preventClockWobble = builder.comment(new String[]{"This setting prevents clock wobble when getting in bed by updating the clock's position every tick.", "As a side-effect, the clock won't wobble when first viewed as it does in vanilla. This setting is", "unused if displayBedClock is false."}).define("preventClockWobble", true);
            this.blacklistDimensions = builder.comment("This setting blacklists the sky rendering for specific dimensions. Like in the Aether if using /time set command, the sky jitters. Adding to the blacklist will prevent this behavior.").defineListAllowEmpty(blacklistDimensionsList, Client.getBlacklistDimensionsList(), resourceLocationValidator);
            builder.pop();
        }

        public static ScreenAlignment clockAlignment() {
            return (ScreenAlignment)((Object)ConfigHandler.CLIENT.clockAlignment.get());
        }

        public static int clockScale() {
            return (Integer)ConfigHandler.CLIENT.clockScale.get();
        }

        public static int clockMargin() {
            return (Integer)ConfigHandler.CLIENT.clockMargin.get();
        }

        public static boolean preventClockWobble() {
            return (Boolean)ConfigHandler.CLIENT.preventClockWobble.get();
        }

        public static Set<ResourceLocation> getBlacklistDimensions() {
            return blacklistDimensionsSet;
        }

        private static Supplier<List<? extends String>> getBlacklistDimensionsList() {
            return () -> Arrays.asList(defaultBlacklistDimensions);
        }
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.EnumValue<SpeedMethod> speedMethod;
        private final WhiteNoiseConfigSpec.DoubleValue daySpeed;
        private final WhiteNoiseConfigSpec.DoubleValue nightSpeed;
        private final WhiteNoiseConfigSpec.DoubleValue daySpeedMinutes;
        private final WhiteNoiseConfigSpec.DoubleValue nightSpeedMinutes;
        private final WhiteNoiseConfigSpec.DoubleValue dayStart;
        private final WhiteNoiseConfigSpec.DoubleValue nightStart;
        private final WhiteNoiseConfigSpec.BooleanValue enableInterpolatedTime;
        private final WhiteNoiseConfigSpec.DoubleValue interpolatedTimeSmoothingFactor;
        private final WhiteNoiseConfigSpec.TransformableValue<List<? extends String>, List<Pair<Integer, Double>>> interpolatedTimePairs;
        private static final List<String> defaultInterpolatedTimePairs = List.of(new String[]{"0,1.0", "24000,1.0"});
        private static final Predicate<Object> valuePairValidator = s -> s instanceof String && ((String)s).matches("\\d+,\\d*\\.?\\d+");
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> weatherEffect;
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> randomTickEffect;
        private final WhiteNoiseConfigSpec.IntValue baseRandomTickSpeed;
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> potionEffect;
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> hungerEffect;
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> blockEntityEffect;
        private final WhiteNoiseConfigSpec.BooleanValue enableSleepFeature;
        private final WhiteNoiseConfigSpec.DoubleValue sleepSpeedMin;
        private final WhiteNoiseConfigSpec.DoubleValue sleepSpeedMax;
        private final WhiteNoiseConfigSpec.DoubleValue sleepSpeedAll;
        private final WhiteNoiseConfigSpec.DoubleValue sleepSpeedCurve;
        private final WhiteNoiseConfigSpec.BooleanValue clearWeatherOnWake;
        private final WhiteNoiseConfigSpec.BooleanValue allowDaySleep;
        private final WhiteNoiseConfigSpec.BooleanValue displayBedClock;
        private final WhiteNoiseConfigSpec.DoubleValue ratioPlayersForSleep;
        private final WhiteNoiseConfigSpec.ConfigValue<String> morningMessage;
        private final WhiteNoiseConfigSpec.EnumValue<ChatTypeOptions> morningMessageType;
        private final WhiteNoiseConfigSpec.EnumValue<TemplateMessage.MessageTarget> morningMessageTarget;
        private final WhiteNoiseConfigSpec.ConfigValue<String> enterBedMessage;
        private final WhiteNoiseConfigSpec.EnumValue<ChatTypeOptions> enterBedMessageType;
        private final WhiteNoiseConfigSpec.EnumValue<TemplateMessage.MessageTarget> enterBedMessageTarget;
        private final WhiteNoiseConfigSpec.ConfigValue<String> leaveBedMessage;
        private final WhiteNoiseConfigSpec.EnumValue<ChatTypeOptions> leaveBedMessageType;
        private final WhiteNoiseConfigSpec.EnumValue<TemplateMessage.MessageTarget> leaveBedMessageTarget;
        private static final Function<List<? extends String>, List<Pair<Integer, Double>>> pairTransformer = list -> list.stream().map(entry -> {
            String[] parts = entry.split(",");
            if (parts.length == 2) {
                try {
                    int first = Integer.parseInt(parts[0].trim());
                    double second = Double.parseDouble(parts[1].trim());
                    return Pair.of((Object)first, (Object)second);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }).collect(Collectors.toList());

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("time");
            this.daySpeed = builder.comment(new String[]{"The speed at which time passes during the day.", "Day is defined as any time between dayStart (see below) and nightStart (see below) the next day.", "This is the RATIO of time passing relative to vanilla.", "Vanilla speed: 1.0"}).defineInRange("daySpeed", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.nightSpeed = builder.comment(new String[]{"The speed at which time passes during the night.", "Night is defined as any time between dayStart (see below) and nightStart (see below).", "This is the RATIO of time passing relative to vanilla.", "Vanilla speed: 1.0"}).defineInRange("nightSpeed", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.daySpeedMinutes = builder.comment(new String[]{"An alternative way to set day speed. This setting is mutually exclusive with daySpeed.", "If both are set, speedMethod (see below) determines which setting is used.", "This setting defines the length of the day in real-world minutes.", "Vanilla length: 10.0 minutes"}).defineInRange("daySpeedMinutes", 10.0, 0.1, 10000.0);
            this.nightSpeedMinutes = builder.comment(new String[]{"An alternative way to set night speed. This setting is mutually exclusive with nightSpeed.", "If both are set, speedMethod (see below) determines which setting is used.", "This setting defines the length of the night in real-world minutes.", "Vanilla length: 10.0 minutes"}).defineInRange("nightSpeedMinutes", 10.0, 0.1, 10000.0);
            this.speedMethod = builder.comment(new String[]{"Determines which method is used to set day and night speed.", "RATIO: Uses daySpeed and nightSpeed settings.", "MINUTES: Uses daySpeedMinutes and nightSpeedMinutes settings.", "REALTIME: Sets day and night to 12 real-world hours each."}).defineEnum("speedMethod", (Enum)SpeedMethod.RATIO);
            this.dayStart = builder.comment(new String[]{"The time to start day. This is configurable within the time the sun appears and day starts.", "Default: 23500"}).defineInRange("dayStart", 23500.0, 22300.0, 24000.0);
            this.nightStart = builder.comment(new String[]{"The time to start night. This is configurable within the time sunset starts and night starts.", "Default: 12500"}).defineInRange("nightStart", 12500.0, 12000.0, 13000.0);
            this.enableInterpolatedTime = builder.comment(new String[]{"Enabling this will allow the setting of an infinite amount of time speeds defined as pairs in the form:", "(currentTick, desiredSpeed)", "where between each value bezier spline interpolation is performed for smooth transitioning", "The two default pairs at 0 and 24000 are necessary as they act as bounds. However ", "The time speed value for each of them can be freely modified"}).define("enableInterpolatedTime", false);
            this.interpolatedTimeSmoothingFactor = builder.comment(new String[]{"The value that determines the smoothing factor in the interpolation algorithm.", "A high value will make the interpolation softer and curvier", "A low value will make the interpolation closer to a piecewise function"}).defineInRange("interpolatedTimeSmoothingFactor", 0.25, 0.0, 10.0);
            this.interpolatedTimePairs = builder.comment(new String[]{"These are the pairs that define what speed time should run at, at the specified day/night tick", "The two default pairs need to exist, but their time speed values can be modified"}).defineList("interpolatedTimeList", defaultInterpolatedTimePairs, valuePairValidator, pairTransformer);
            builder.push("effects");
            this.weatherEffect = builder.comment(new String[]{"When applied, this effect syncs the passage of weather with the current speed of time.", "I.e., as time moves faster, rain stops faster. Clear weather is not affected.", "When set to SLEEPING, this effect only applies when at least one player is sleeping in a dimension.", "Note: This setting is not applicable if game rule doWeatherCycle is false."}).defineEnum("weatherEffect", (Enum)EffectCondition.SLEEPING);
            this.randomTickEffect = builder.comment(new String[]{"When applied, this effect syncs the random tick speed with the current speed of time, forcing", "crop, tree, and grass growth to occur at baseRandomTickSpeed multiplied by the current time-speed.", "When set to SLEEPING, randomTickSpeed is set to baseRandomTickSpeed unless at least one player is sleeping in a dimension.", "More information on the effects of random tick speed can be found here: https://minecraft.wiki/w/Tick#Random_tick", "WARNING: This setting overwrites the randomTickSpeed game rule. To modify the base random tick speed,", "use the baseRandomTickSpeed setting instead of changing the game rule directly.", "This effect has a minimum randomTickSpeed of 1 if time speed is less than 1.0."}).defineEnum("randomTickEffect", (Enum)EffectCondition.NEVER);
            this.baseRandomTickSpeed = builder.comment("The base random tick speed used by the randomTickEffect time effect.").defineInRange("baseRandomTickSpeed", 3, 0, Integer.MAX_VALUE);
            this.potionEffect = builder.comment(new String[]{"When applied, this effect progresses potion effects to match the rate of the current time-speed.", "This effect does not apply if time speed is 1.0 or less.", "THIS MAY HAVE A NEGATIVE IMPACT ON PERFORMANCE IN SERVERS WITH MANY PLAYERS.", "When set to ALWAYS, this effect applies to all players in the dimension, day or night.", "When set to SLEEPING, this effect only applies to players who are sleeping."}).defineEnum("potionEffect", (Enum)EffectCondition.NEVER);
            this.hungerEffect = builder.comment(new String[]{"When applied, this effect progresses player hunger effects to match the rate of the current time-speed.", "This results in faster healing when food level is full, and faster harm when food level is too low.", "This effect does not apply if time speed is 1.0 or less.", "When set to ALWAYS, this effect applies to all players in the dimension, day or night. Not recommended on higher difficulty settings", "When set to SLEEPING, this effect only applies to players who are sleeping."}).defineEnum("hungerEffect", (Enum)EffectCondition.NEVER);
            this.blockEntityEffect = builder.comment(new String[]{"When applied, this effect progresses block entities like furnaces, hoppers, and spawners to match the rate of the current time-speed.", "WARNING: This time-effect has a significant impact on performance.", "This effect does not apply if time speed is 1.0 or less.", "When set to SLEEPING, this effect only applies when at least one player is sleeping in a dimension."}).defineEnum("blockEntityEffect", (Enum)EffectCondition.NEVER);
            builder.pop();
            builder.pop();
            builder.push("sleep");
            this.enableSleepFeature = builder.comment(new String[]{"Enables or disables the sleep feature of this mod. Enabling this setting will modify the vanilla sleep functionality", "and may conflict with other sleep mods. If disabled, all settings in the sleep section will not apply."}).define("enableSleepFeature", true);
            this.sleepSpeedMax = builder.comment(new String[]{"## THIS SETTING DEFINES THE SLEEP TIME-SPEED IN SINGLE-PLAYER GAMES ###", "The maximum speed at which time passes when all players are sleeping.", "A value of 110 is nearly equal to the time it takes to sleep in vanilla."}).defineInRange("sleepSpeedMax", 110.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedMin = builder.comment("The minimum speed at which time passes when only 1 player is sleeping in a full server.").defineInRange("sleepSpeedMin", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedAll = builder.comment(new String[]{"The speed at which time passes when all players are sleeping.", "Set to -1 to disable this feature (sleepSpeedMax will be used when all players are sleeping)."}).defineInRange("sleepSpeedAll", -1.0, -1.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedCurve = builder.comment(new String[]{"This parameter defines the curvature of the interpolation function that translates the sleeping player percentage into time-speed.", "The function used is a Normalized Tunable Sigmoid Function.", "A value of 0.5 represents a linear relationship.", "Smaller values bend the curve toward the X axis, while greater values bend it toward the Y axis.", "This graph may be used as a reference for tuning the curve: https://www.desmos.com/calculator/w8gntxzfow", "Credit to Dino Dini for the function: https://dinodini.wordpress.com/2010/04/05/normalized-tunable-sigmoid-functions/", "Credit to SmoothSleep for the idea: https://www.spigotmc.org/resources/smoothsleep.32043/"}).defineInRange("sleepSpeedCurve", 0.3, 0.0, 1.0);
            this.clearWeatherOnWake = builder.comment(new String[]{"Set to 'true' for the weather to clear when players wake up in the morning as it does in vanilla.", "Set to 'false' to force weather to pass naturally. Adds realism when accelerateWeather is enabled.", "Note: This setting is ignored if game rule doWeatherCycle is false."}).define("clearWeatherOnWake", true);
            this.allowDaySleep = builder.comment(new String[]{"When true, players are allowed to sleep at all times of day in dimensions controlled by Better Days.", "Note: Other mods may override this ability."}).define("allowDaySleep", false);
            this.displayBedClock = builder.comment("When true, a clock is displayed in the sleep interface.").define("displayBedClock", true);
            this.ratioPlayersForSleep = builder.comment(new String[]{"The ratio of players in a dimension that must be sleeping to skip to morning.", "A value of 1 means all players must be sleeping, 0.5 means half the players must be sleeping, etc.", "A value of 0 effectively disables this feature."}).defineInRange("ratioPlayersForSleep", 0.0, 0.0, 1.0);
            builder.comment(new String[]{"This section defines settings for notification messages.", "All messages support Minecraft formatting codes (https://minecraft.wiki/w/Formatting_codes).", "All messages have variables that can be inserted using the following format: ${variableName}", "The type option controls where the message appears:", "\tSYSTEM: Appears as a message in the chat. (e.g., \"Respawn point set\")", "\tGAME_INFO: Game information that appears above the hotbar (e.g., \"You may not rest now, the bed is too far away\").", "The target option controls to whom the message is sent:", "\tALL: Sends the message to all players on the server.", "\tDIMENSION: Sends the message to all players in the current dimension.", "\tSLEEPING: Sends the message to all players in the current dimension who are sleeping."}).push("messages");
            builder.comment("This message is sent after a sleep cycle has completed.").push("morning");
            this.morningMessage = builder.comment(new String[]{"Available variables:", "sleepingPlayers -> the number of players in the current dimension who were sleeping.", "totalPlayers -> the number of players in the current dimension (spectators are not counted).", "sleepingPercentage -> the percentage of players in the current dimension who were sleeping (does not include % symbol)."}).define("message", (Object)"\u00a7e\u00a7oTempus fugit!");
            this.morningMessageType = builder.comment("Sets where this message appears.").defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO);
            this.morningMessageTarget = builder.comment(new String[]{"Sets to whom this message is sent.", "A target of 'SLEEPING' will send the message to all players who just woke up."}).defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.comment("This message is sent when a player enters their bed.").push("enterBed");
            this.enterBedMessage = builder.comment(new String[]{"Available variables:", "player -> the player who started sleeping.", "sleepingPlayers -> the number of players in the current dimension who are sleeping.", "totalPlayers -> the number of players in the current dimension (spectators are not counted).", "sleepingPercentage -> the percentage of players in the current dimension who are sleeping (does not include % symbol)."}).define("message", (Object)"${player} is now sleeping. [${sleepingPlayers}/${totalPlayers}]");
            this.enterBedMessageType = builder.comment("Sets where this message appears.").defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO);
            this.enterBedMessageTarget = builder.comment("Sets to whom this message is sent.").defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.comment("This message is sent when a player leaves their bed (without being woken up naturally by morning).").push("leaveBed");
            this.leaveBedMessage = builder.comment(new String[]{"Available variables:", "player -> the player who left their bed.", "sleepingPlayers -> the number of players in the current dimension who are sleeping.", "totalPlayers -> the number of players in the current dimension (spectators are not counted).", "sleepingPercentage -> the percentage of players in the current dimension who are sleeping (does not include % symbol)."}).define("message", (Object)"${player} has left their bed. [${sleepingPlayers}/${totalPlayers}]");
            this.leaveBedMessageType = builder.comment("Sets where this message appears.").defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO);
            this.leaveBedMessageTarget = builder.comment("Sets to whom this message is sent. ").defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.pop();
            builder.pop();
        }

        public static double daySpeed() {
            if (ConfigHandler.COMMON.speedMethod.get() == SpeedMethod.MINUTES) {
                return 100.0 / (Double)ConfigHandler.COMMON.daySpeedMinutes.get() / 10.0;
            }
            if (ConfigHandler.COMMON.speedMethod.get() == SpeedMethod.REALTIME) {
                return 0.01388888992369175;
            }
            return (Double)ConfigHandler.COMMON.daySpeed.get();
        }

        public static double nightSpeed() {
            if (ConfigHandler.COMMON.speedMethod.get() == SpeedMethod.MINUTES) {
                return 100.0 / (Double)ConfigHandler.COMMON.nightSpeedMinutes.get() / 10.0;
            }
            if (ConfigHandler.COMMON.speedMethod.get() == SpeedMethod.REALTIME) {
                return 0.01388888992369175;
            }
            return (Double)ConfigHandler.COMMON.nightSpeed.get();
        }

        public static double dayStart() {
            return (Double)ConfigHandler.COMMON.dayStart.get();
        }

        public static double nightStart() {
            return (Double)ConfigHandler.COMMON.nightStart.get();
        }

        public static boolean enableInterpolatedTime() {
            return (Boolean)ConfigHandler.COMMON.enableInterpolatedTime.get();
        }

        public static double interpolatedTimeSmoothingFactor() {
            return (Double)ConfigHandler.COMMON.interpolatedTimeSmoothingFactor.get();
        }

        public static List<Pair<Integer, Double>> interpolatedTimePairs() {
            return (List)ConfigHandler.COMMON.interpolatedTimePairs.getTransformed();
        }

        public static EffectCondition weatherEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.weatherEffect.get());
        }

        public static EffectCondition randomTickEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.randomTickEffect.get());
        }

        public static int baseRandomTickSpeed() {
            return (Integer)ConfigHandler.COMMON.baseRandomTickSpeed.get();
        }

        public static EffectCondition potionEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.potionEffect.get());
        }

        public static EffectCondition hungerEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.hungerEffect.get());
        }

        public static EffectCondition blockEntityEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.blockEntityEffect.get());
        }

        public static boolean enableSleepFeature() {
            boolean sleepModLoaded = Services.PLATFORM.isModLoaded("sleepwarp") || Services.PLATFORM.isModLoaded("sleep_tight");
            return !sleepModLoaded ? (Boolean)ConfigHandler.COMMON.enableSleepFeature.get() : false;
        }

        public static double sleepSpeedMin() {
            return (Double)ConfigHandler.COMMON.sleepSpeedMin.get();
        }

        public static double sleepSpeedMax() {
            return (Double)ConfigHandler.COMMON.sleepSpeedMax.get();
        }

        public static double sleepSpeedAll() {
            return (Double)ConfigHandler.COMMON.sleepSpeedAll.get();
        }

        public static double sleepSpeedCurve() {
            return (Double)ConfigHandler.COMMON.sleepSpeedCurve.get();
        }

        public static boolean clearWeatherOnWake() {
            return (Boolean)ConfigHandler.COMMON.clearWeatherOnWake.get();
        }

        public static boolean allowDaySleep() {
            return (Boolean)ConfigHandler.COMMON.allowDaySleep.get();
        }

        public static boolean displayBedClock() {
            return (Boolean)ConfigHandler.COMMON.displayBedClock.get();
        }

        public static double percentPlayersForSleep() {
            return (Double)ConfigHandler.COMMON.ratioPlayersForSleep.get();
        }

        public static String morningMessage() {
            return (String)ConfigHandler.COMMON.morningMessage.get();
        }

        public static ChatTypeOptions morningMessageType() {
            return (ChatTypeOptions)((Object)ConfigHandler.COMMON.morningMessageType.get());
        }

        public static TemplateMessage.MessageTarget morningMessageTarget() {
            return (TemplateMessage.MessageTarget)((Object)ConfigHandler.COMMON.morningMessageTarget.get());
        }

        public static String enterBedMessage() {
            return (String)ConfigHandler.COMMON.enterBedMessage.get();
        }

        public static ChatTypeOptions enterBedMessageType() {
            return (ChatTypeOptions)((Object)ConfigHandler.COMMON.enterBedMessageType.get());
        }

        public static TemplateMessage.MessageTarget enterBedMessageTarget() {
            return (TemplateMessage.MessageTarget)((Object)ConfigHandler.COMMON.enterBedMessageTarget.get());
        }

        public static String leaveBedMessage() {
            return (String)ConfigHandler.COMMON.leaveBedMessage.get();
        }

        public static ChatTypeOptions leaveBedMessageType() {
            return (ChatTypeOptions)((Object)ConfigHandler.COMMON.leaveBedMessageType.get());
        }

        public static TemplateMessage.MessageTarget leaveBedMessageTarget() {
            return (TemplateMessage.MessageTarget)((Object)ConfigHandler.COMMON.leaveBedMessageTarget.get());
        }
    }
}

