/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.netjs.tasks.subtasks;

import dev.kostromdan.mods.netjs.tasks.AbstractNetJSTask;
import dev.kostromdan.mods.netjs.utils.NetJSUtils;
import java.io.IOException;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class PasteBinRawTask
extends AbstractNetJSTask {
    public PasteBinRawTask(String id) {
        super(id);
    }

    @Override
    public void run() {
        String raw_text;
        Connection.Response response;
        if (!NetJSUtils.isValidId(this.id, 8)) {
            this.exception(new RuntimeException("Non valid PasteBin id. It looks like you're doing something that this mod doesn't want to do."));
            return;
        }
        try {
            response = Jsoup.connect((String)("https://pastebin.com/raw/" + this.id)).ignoreContentType(true).execute();
            raw_text = response.body();
        }
        catch (IOException ioe) {
            this.exception(ioe);
            return;
        }
        int response_code = response.statusCode();
        this.result.put("response_code", response_code);
        if (response_code != 200) {
            this.result.put("raw_response_text", raw_text);
            this.exception(new RuntimeException("Response code " + response_code + " != 200! raw_response_text can contain more info."));
            return;
        }
        this.result.put("raw_text", raw_text);
        this.success();
    }
}

