/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.netjs.tasks.subtasks;

import dev.kostromdan.mods.netjs.tasks.AbstractNetJSTask;
import dev.kostromdan.mods.netjs.utils.NetJSUtils;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.io.IOException;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PasteBinMetaDataTask
extends AbstractNetJSTask {
    public PasteBinMetaDataTask(String id) {
        super(id);
    }

    @Override
    public void run() {
        Document doc;
        Connection.Response response;
        if (!NetJSUtils.isValidId(this.id, 8)) {
            this.exception(new RuntimeException("Non valid PasteBin id. It looks like you're doing something that this mod doesn't want to do."));
            return;
        }
        try {
            response = Jsoup.connect((String)("https://pastebin.com/" + this.id)).execute();
            doc = response.parse();
        }
        catch (IOException ioe) {
            this.exception(ioe);
            return;
        }
        int response_code = response.statusCode();
        this.result.put("response_code", response_code);
        if (response_code != 200) {
            this.result.put("raw_response_text", doc.body());
            this.exception(new RuntimeException("Response code " + response_code + " != 200! raw_response_text can contain more info."));
            return;
        }
        Element elems = doc.getElementsByClass("post-view js-post-view").first();
        if (elems == null) {
            this.result.put("raw_response_text", doc.body());
            this.exception(new RuntimeException("Can't parse pastebin page. PasteBin site changed? You using wrong pastebin id? raw_response_text can contain more info."));
            return;
        }
        try {
            Elements left_elems;
            Element post_name = elems.getElementsByClass("info-top").first();
            this.result.put("post_name", post_name != null ? post_name.text() : null);
            Element author_username = elems.getElementsByClass("username").first();
            this.result.put("author_username", author_username != null ? author_username.text() : null);
            Element date = elems.getElementsByClass("date").first();
            boolean is_edited = false;
            if (date != null) {
                Elements date_elems = date.select("span[title]");
                if (date_elems.size() >= 1) {
                    Element date_created = date_elems.first();
                    this.result.put("date_created", date_created != null ? date_created.attr("title") : null);
                }
                if (date_elems.size() >= 2) {
                    is_edited = true;
                    Element date_edited = (Element)date.select("span[title]").get(1);
                    this.result.put("date_edited", date_edited != null ? date_edited.attr("title").replace("Last edit on: ", "") : null);
                }
            }
            this.result.put("is_edited", is_edited);
            Element expire = elems.getElementsByClass("expire").first();
            this.result.put("date_expire", expire != null ? expire.text() : null);
            Element visits = elems.getElementsByClass("visits").first();
            this.result.put("visits_count", visits != null ? Integer.valueOf(Integer.parseInt(visits.text().replaceAll(",| ", ""))) : null);
            Element stars = elems.getElementsByClass("rating js-post-rating").first();
            this.result.put("stars_count", stars != null ? Integer.valueOf(Integer.parseInt(stars.text().replaceAll(",| ", ""))) : null);
            Element left = elems.getElementsByClass("left").first();
            String lang = null;
            String category = null;
            String size = null;
            if (left != null && (left_elems = left.children()).size() >= 2) {
                lang = ((Element)left_elems.get(0)).text();
                category = ((Element)left_elems.get(1)).text().replace("| ", "");
                size = left.text().replace(lang, "").split("\\|")[0].strip();
            }
            this.result.put("lang", lang);
            this.result.put("category", category);
            this.result.put("size", size);
            Element likes = elems.getElementsByClass("btn -small -like").first();
            this.result.put("likes_count", likes != null ? Integer.valueOf(Integer.parseInt(likes.text().replaceAll(",| ", ""))) : null);
            Element dislikes = elems.getElementsByClass("btn -small -dislike").first();
            this.result.put("dislikes_count", dislikes != null ? Integer.valueOf(Integer.parseInt(dislikes.text().replaceAll(",| ", ""))) : null);
        }
        catch (Exception e) {
            ConsoleJS.SERVER.log(new Object[]{"Error while parsing additional prams from pastebin, this shouldn't happen, report to NetJS authors:"});
            e.printStackTrace();
            this.exception(e);
            return;
        }
        this.success();
    }
}

