/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.netjs.tasks;

import dev.kostromdan.mods.netjs.callbacks.NetJSICallback;
import dev.kostromdan.mods.netjs.tasks.AbstractNetJSTask;
import dev.kostromdan.mods.netjs.utils.NetJSUtils;
import java.io.IOException;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class GistsTask
extends AbstractNetJSTask {
    public GistsTask(String id, NetJSICallback c) {
        super(id);
        this.callback = c;
    }

    @Override
    public void run() {
        String raw_text;
        Connection.Response response;
        if (!NetJSUtils.isValidId(this.id, 32)) {
            this.exception(new RuntimeException("Non valid Gists id. It looks like you're doing something that this mod doesn't want to do."));
            return;
        }
        try {
            response = Jsoup.connect((String)("https://api.github.com/gists/" + this.id)).ignoreContentType(true).execute();
            raw_text = response.body();
        }
        catch (IOException ioe) {
            this.exception(ioe);
            return;
        }
        int response_code = response.statusCode();
        this.result.put("response_code", response_code);
        if (response_code != 200) {
            this.result.put("raw_response_text", raw_text);
            this.exception(new RuntimeException("Response code " + response_code + " != 200! raw_response_text can contain more info."));
            return;
        }
        this.result.putAll(NetJSUtils.parseRawJsonToMap(raw_text));
        this.success();
    }
}

