/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.netjs.tasks;

import dev.kostromdan.mods.netjs.callbacks.NetJSICallback;
import dev.kostromdan.mods.netjs.results.NetJSResultMap;
import dev.kostromdan.mods.netjs.utils.TrustAllCertificates;
import dev.latvian.mods.kubejs.util.ConsoleJS;

public abstract class AbstractNetJSTask
extends TrustAllCertificates
implements Runnable {
    public String id = null;
    public NetJSResultMap<String, Object> result = new NetJSResultMap(this.getClass());
    protected NetJSICallback callback = null;

    public AbstractNetJSTask(String id) {
        this.id = id;
    }

    private boolean is_subtask() {
        return this.getClass().getPackage().toString().endsWith(".subtasks");
    }

    public void callback() {
        if (this.is_subtask()) {
            return;
        }
        try {
            this.callback.onCallback(this.result);
        }
        catch (Throwable ex) {
            ConsoleJS.SERVER.error((Object)("Error occurred while handling NetJS callback: " + ex.getMessage()));
        }
    }

    public void success() {
        this.result.put("success", true);
        this.callback();
    }

    public void exception(Exception err) {
        this.result.put("success", false);
        this.result.put("exception", err);
        this.callback();
        err.printStackTrace();
    }

    public boolean isSuccess() {
        return this.result.isSuccess();
    }

    public Exception getException() {
        return this.result.getException();
    }
}

