/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.PinkSaltClusterBlock;
import net.orcinus.galosphere.blocks.blockentities.PinkSaltChamberBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import org.jetbrains.annotations.Nullable;

public class PinkSaltChamberBlock
extends BaseEntityBlock {
    public static final EnumProperty<ChamberPhase> PHASE = EnumProperty.m_61587_((String)"chamber_phase", ChamberPhase.class);

    public PinkSaltChamberBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PHASE, (Comparable)((Object)ChamberPhase.INACTIVE)));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        boolean flag2 = false;
        for (Direction dir : Direction.values()) {
            boolean flag;
            BlockState relativeState = levelAccessor.m_8055_(blockPos.m_121945_(dir));
            boolean bl = flag = relativeState.m_60713_((Block)GBlocks.PINK_SALT_CLUSTER.get()) && relativeState.m_61143_((Property)PinkSaltClusterBlock.FACING) == dir;
            if (!flag) continue;
            flag2 = true;
            break;
        }
        if (blockState.m_61143_(PHASE) == ChamberPhase.COOLDOWN) {
            return blockState;
        }
        ChamberPhase phase = flag2 ? ChamberPhase.CHARGED : ChamberPhase.INACTIVE;
        return (BlockState)blockState.m_61124_(PHASE, (Comparable)((Object)phase));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PHASE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PinkSaltChamberBlockEntity(blockPos, blockState);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.m_6402_(world, pos, blockState, entity, itemStack);
        if (entity instanceof Player) {
            BlockEntity blockEntity;
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_ && (blockEntity = world.m_7702_(pos)) instanceof PinkSaltChamberBlockEntity) {
                PinkSaltChamberBlockEntity pinkSaltChamberBlockEntity = (PinkSaltChamberBlockEntity)blockEntity;
                pinkSaltChamberBlockEntity.setCooldown(pinkSaltChamberBlockEntity.maxCooldown);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : PinkSaltChamberBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)GBlockEntityTypes.PINK_SALT_CHAMBER.get()), PinkSaltChamberBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public static enum ChamberPhase implements StringRepresentable
    {
        INACTIVE("inactive"),
        CHARGED("charged"),
        COOLDOWN("cooldown");

        private final String name;

        private ChamberPhase(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

