/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.client;

import com.google.common.collect.Multimap;
import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.ObscureAPIConfig;
import com.obscuria.obscureapi.api.client.tooltips.ModifiedTooltip;
import com.obscuria.obscureapi.api.client.tooltips.Tooltip;
import com.obscuria.obscureapi.api.common.classes.Ability;
import com.obscuria.obscureapi.api.common.classes.Bonus;
import com.obscuria.obscureapi.api.utils.Icons;
import com.obscuria.obscureapi.registry.ObscureAPIMobEffects;
import com.obscuria.obscureapi.util.ClassUtils;
import com.obscuria.obscureapi.util.ItemUtils;
import com.obscuria.obscureapi.util.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class TooltipBuilder {
    public static void buildComponents(@Nonnull RenderTooltipEvent.GatherComponents event) {
    }

    public static void buildTooltip(@Nonnull ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List list = event.getToolTip();
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Modules.buildPerkNames(stack, list);
        Modules.putTooltip(stack, list, Tooltip.Type.BOTTOM);
        Modules.expandableTooltip(player, stack, list);
        Modules.buildKnowledge(player, stack, list);
        Modules.buildLore(stack, list);
        Modules.buildClass(stack, list);
        Modules.putTooltip(stack, list, Tooltip.Type.TOP);
        Modules.buildIcons(stack, list);
    }

    public static class Modules {
        private static void buildIcons(ItemStack stack, List<Component> list) {
            if (((Boolean)ObscureAPIConfig.Client.foodIcons.get()).booleanValue() && stack.m_41720_().m_41472_()) {
                AttributeIcons.putFoodIcons(list, stack);
            }
            if (((Boolean)ObscureAPIConfig.Client.equipmentIcons.get()).booleanValue() && (stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof ArmorItem) || Modules.hasTooltip(stack.m_41720_(), Tooltip.Type.ICONS_START) || Modules.hasTooltip(stack.m_41720_(), Tooltip.Type.ICONS_END)) {
                AttributeIcons.putIcons(list, stack);
            }
        }

        private static void buildClass(@Nonnull ItemStack stack, List<Component> list) {
            if (ClassUtils.isClassItem(stack) && !ObscureAPI.COLLECTION_MODS.containsKey("obscure_tooltips")) {
                list.add(1, (Component)TextUtils.component(Icons.STAR.get() + "\u00a76" + ClassUtils.getItemClass(stack).getLabel(ClassUtils.getItemType(stack))));
            }
        }

        private static void buildLore(ItemStack stack, List<Component> list) {
            if (Lore.contains(stack)) {
                list.addAll(1, TextUtils.buildLore(new ArrayList<Component>(), 34, TextUtils.translation(Lore.get(stack))));
            }
        }

        private static void buildKnowledge(@Nonnull Player player, ItemStack stack, List<Component> list) {
            if (player.m_21023_((MobEffect)ObscureAPIMobEffects.KNOWLEDGE.get()) && Knowledge.contains(stack)) {
                list.addAll(1, TextUtils.buildKnowledge(new ArrayList<Component>(), 30, TextUtils.translation(Knowledge.get(stack))));
            }
        }

        private static void expandableTooltip(Player player, @Nonnull ItemStack stack, List<Component> list) {
            boolean abilities = ClassUtils.hasVisibleAbilities(stack.m_41720_());
            boolean bonuses = ClassUtils.hasVisibleBonuses(stack);
            boolean perks = ItemUtils.hasPerks(stack);
            if (abilities || bonuses || perks || Modules.hasTooltip(stack.m_41720_(), Tooltip.Type.EXPAND_TOP) || Modules.hasTooltip(stack.m_41720_(), Tooltip.Type.EXPAND_BOTTOM)) {
                if (stack.m_41793_() || ItemUtils.hasPerks(stack)) {
                    list.add(1, (Component)Component.m_237119_());
                }
                if (Screen.m_96638_()) {
                    Modules.putTooltip(stack, list, Tooltip.Type.EXPAND_BOTTOM);
                    if (perks) {
                        Modules.buildPerks(stack, list);
                    }
                    if (abilities) {
                        Modules.buildAbilities(stack, player, list);
                    }
                    if (bonuses) {
                        Modules.buildBonuses(stack.m_41720_(), list);
                    }
                    Modules.putTooltip(stack, list, Tooltip.Type.EXPAND_TOP);
                    list.add(1, (Component)TextUtils.component(TextUtils.translation("obscure_api.tooltip.collapse")));
                } else {
                    list.add(1, (Component)TextUtils.component(TextUtils.translation("obscure_api.tooltip.expand")));
                }
            }
        }

        private static void buildAbilities(@Nonnull ItemStack stack, Player player, List<Component> list) {
            for (Ability ability : ClassUtils.getVisibleAbilities(stack.m_41720_())) {
                list.addAll(1, TextUtils.buildAbility(new ArrayList<Component>(), 30, ability, player));
            }
        }

        private static void buildBonuses(Item item, List<Component> list) {
            for (Bonus bonus : ClassUtils.getVisibleBonuses(item)) {
                list.add(1, (Component)TextUtils.component(Icons.STICK.get() + " " + bonus.getBonusString()));
                list.add(1, (Component)TextUtils.component(TextUtils.translation("icon.stick") + TextUtils.translation("obscure_api.ability.bonuses")));
            }
        }

        private static void buildPerkNames(ItemStack stack, List<Component> list) {
            if (ItemUtils.hasPerks(stack)) {
                for (String perk : ItemUtils.getOrCreatePerks(stack).m_128431_()) {
                    ResourceLocation registry = new ResourceLocation(perk);
                    list.add(1, (Component)Component.m_237115_((String)("perk." + registry.m_135827_() + "." + registry.m_135815_())).m_130948_(Style.f_131099_.m_131150_(registry)));
                }
            }
        }

        private static void buildPerks(ItemStack stack, List<Component> list) {
            for (String perk : ItemUtils.getOrCreatePerks(stack).m_128431_()) {
                list.addAll(1, TextUtils.buildPerk(new ArrayList<Component>(), 30, new ResourceLocation(perk)));
            }
        }

        private static void putTooltip(@Nonnull ItemStack stack, List<Component> list, Tooltip.Type type) {
            if (!Modules.hasTooltip(stack.m_41720_(), type)) {
                return;
            }
            for (Method method : stack.m_41720_().getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tooltip.class) || !method.getAnnotation(Tooltip.class).type().equals((Object)type)) continue;
                try {
                    list.addAll(1, TextUtils.buildLore(new ArrayList<Component>(), method.getAnnotation(Tooltip.class).wight(), (String)method.invoke((Object)stack.m_41720_(), stack, Minecraft.m_91087_().f_91074_), type.equals((Object)Tooltip.Type.EXPAND_TOP) || type.equals((Object)Tooltip.Type.EXPAND_BOTTOM) ? Icons.STICK.get() : ""));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Nonnull
        private static String getLine(@Nonnull ItemStack stack, Tooltip.Type type) {
            StringBuilder tooltip = new StringBuilder();
            if (!Modules.hasTooltip(stack.m_41720_(), type)) {
                return tooltip.toString();
            }
            for (Method method : stack.m_41720_().getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tooltip.class) || !method.getAnnotation(Tooltip.class).type().equals((Object)type)) continue;
                try {
                    tooltip.append((String)method.invoke((Object)stack.m_41720_(), stack, Minecraft.m_91087_().f_91074_));
                    tooltip.append(" ");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return tooltip.toString();
        }

        private static boolean hasTooltip(@Nonnull Item item, Tooltip.Type type) {
            if (!item.getClass().isAnnotationPresent(ModifiedTooltip.class)) {
                return false;
            }
            for (Method method : item.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tooltip.class) || !method.getAnnotation(Tooltip.class).type().equals((Object)type)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AttributeIcons {
        private AttributeIcons() {
        }

        private static void putIcons(List<Component> list, ItemStack stack) {
            Object icons = "";
            icons = (String)icons + Modules.getLine(stack, Tooltip.Type.ICONS_START);
            Multimap mainhandMap = stack.m_41638_(EquipmentSlot.MAINHAND);
            Multimap headMap = stack.m_41638_(EquipmentSlot.HEAD);
            Multimap chestMap = stack.m_41638_(EquipmentSlot.CHEST);
            Multimap legsMap = stack.m_41638_(EquipmentSlot.LEGS);
            Multimap feetMap = stack.m_41638_(EquipmentSlot.FEET);
            if (!mainhandMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.DAMAGE.get(), 1.0, mainhandMap.get((Object)Attributes.f_22281_)) + AttributeIcons.getAttackSpeedIcon(mainhandMap.get((Object)Attributes.f_22283_));
            }
            if (!headMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.ARMOR.get(), 0.0, headMap.get((Object)Attributes.f_22284_)) + AttributeIcons.getIcon(false, Icons.ARMOR_TOUGHNESS.get(), 0.0, headMap.get((Object)Attributes.f_22285_)) + AttributeIcons.getIcon(true, Icons.KNOCKBACK_RESISTANCE.get(), 0.0, headMap.get((Object)Attributes.f_22278_));
            }
            if (!chestMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.ARMOR.get(), 0.0, chestMap.get((Object)Attributes.f_22284_)) + AttributeIcons.getIcon(false, Icons.ARMOR_TOUGHNESS.get(), 0.0, chestMap.get((Object)Attributes.f_22285_)) + AttributeIcons.getIcon(true, Icons.KNOCKBACK_RESISTANCE.get(), 0.0, chestMap.get((Object)Attributes.f_22278_));
            }
            if (!legsMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.ARMOR.get(), 0.0, legsMap.get((Object)Attributes.f_22284_)) + AttributeIcons.getIcon(false, Icons.ARMOR_TOUGHNESS.get(), 0.0, legsMap.get((Object)Attributes.f_22285_)) + AttributeIcons.getIcon(true, Icons.KNOCKBACK_RESISTANCE.get(), 0.0, legsMap.get((Object)Attributes.f_22278_));
            }
            if (!feetMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.ARMOR.get(), 0.0, feetMap.get((Object)Attributes.f_22284_)) + AttributeIcons.getIcon(false, Icons.ARMOR_TOUGHNESS.get(), 0.0, feetMap.get((Object)Attributes.f_22285_)) + AttributeIcons.getIcon(true, Icons.KNOCKBACK_RESISTANCE.get(), 0.0, feetMap.get((Object)Attributes.f_22278_));
            }
            icons = (String)icons + AttributeIcons.getDurabilityIcon(stack);
            icons = (String)icons + Modules.getLine(stack, Tooltip.Type.ICONS_END);
            list.add(1, (Component)TextUtils.component((String)icons));
        }

        @Nonnull
        private static String getIcon(boolean percent, String icon, double base, Collection<AttributeModifier> modifier) {
            if (modifier != null && !modifier.isEmpty()) {
                double modAmount = 0.0;
                double modPercent = 0.0;
                for (AttributeModifier attribute : modifier) {
                    if (attribute.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        modAmount += attribute.m_22218_();
                        continue;
                    }
                    if (attribute.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
                    modPercent += attribute.m_22218_();
                }
                if ((modAmount += base + modAmount * modPercent) == 0.0) {
                    return "";
                }
                if (percent) {
                    return icon + (modPercent > 0.0 ? "\u00a72" : "") + new DecimalFormat("##.#").format(modAmount * 100.0).replace(".0", "") + "% ";
                }
                return icon + (modPercent > 0.0 ? "\u00a72" : "") + new DecimalFormat("##.#").format(modAmount).replace(".0", "") + " ";
            }
            return "";
        }

        @Nonnull
        private static String getAttackSpeedIcon(Collection<AttributeModifier> modifier) {
            if (modifier != null && !modifier.isEmpty()) {
                double modAmount = 0.0;
                double modPercent = 0.0;
                for (AttributeModifier attribute : modifier) {
                    if (attribute.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        modAmount += attribute.m_22218_();
                        continue;
                    }
                    if (attribute.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
                    modPercent += attribute.m_22218_();
                }
                if ((modAmount += 4.0 + modAmount * modPercent) <= 0.6) {
                    return Icons.ATTACK_SPEED_VERY_SLOW.get() + " ";
                }
                if (modAmount <= 1.0) {
                    return Icons.ATTACK_SPEED_SLOW.get() + " ";
                }
                if (modAmount <= 2.0) {
                    return Icons.ATTACK_SPEED_MEDIUM.get() + " ";
                }
                if (modAmount <= 3.0) {
                    return Icons.ATTACK_SPEED_FAST.get() + " ";
                }
                return Icons.ATTACK_SPEED_VERY_FAST.get() + " ";
            }
            return "";
        }

        @Nonnull
        private static String getDurabilityIcon(@Nonnull ItemStack stack) {
            if (stack.m_41776_() > 0) {
                return Icons.DURABILITY.get() + (stack.m_41776_() - stack.m_41773_()) + "\u00a78/" + stack.m_41776_() + "\u00a7f ";
            }
            return "";
        }

        private static void putFoodIcons(List<Component> list, @Nonnull ItemStack stack) {
            Object icons = "";
            if (Objects.requireNonNull(stack.m_41720_().getFoodProperties(stack, (LivingEntity)Minecraft.m_91087_().f_91074_)).m_38744_() > 0) {
                icons = (String)icons + Icons.FOOD.get() + Objects.requireNonNull(stack.m_41720_().getFoodProperties(stack, (LivingEntity)Minecraft.m_91087_().f_91074_)).m_38744_() + " ";
            }
            if (Objects.requireNonNull(stack.m_41720_().getFoodProperties(stack, (LivingEntity)Minecraft.m_91087_().f_91074_)).m_38745_() > 0.0f) {
                icons = (String)icons + Icons.FOOD_SATURATION.get() + (int)(Objects.requireNonNull(stack.m_41720_().getFoodProperties(stack, (LivingEntity)Minecraft.m_91087_().f_91074_)).m_38745_() * 100.0f) + "% ";
            }
            if (!((String)icons).equals("")) {
                list.add(1, (Component)TextUtils.component((String)icons));
            }
        }
    }

    public static class Knowledge {
        private static final HashMap<ResourceLocation, String> KNOWLEDGE = new HashMap();

        public static void add(String modID, String itemID, String translationKey) {
            KNOWLEDGE.put(new ResourceLocation(itemID), "knowledge." + modID + "." + translationKey);
        }

        public static boolean contains(@Nonnull ItemStack stack) {
            return KNOWLEDGE.containsKey(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }

        public static String get(@Nonnull ItemStack stack) {
            return KNOWLEDGE.get(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }
    }

    public static class Lore {
        private static final HashMap<ResourceLocation, String> LORE = new HashMap();

        public static void add(String modID, String itemID, String translationKey) {
            LORE.put(new ResourceLocation(itemID), "lore." + modID + "." + translationKey);
        }

        public static boolean contains(@Nonnull ItemStack stack) {
            return LORE.containsKey(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }

        public static String get(@Nonnull ItemStack stack) {
            return LORE.get(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }
    }
}

