/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.common;

import com.obscuria.obscureapi.registry.ObscureAPIEntities;
import com.obscuria.obscureapi.util.EntityUtils;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.Contract;

public class FlatVFX
extends Entity {
    private static final String BLANK_TEXTURE_LOC = "obscure_api";
    private static final String BLANK_TEXTURE_NAME = "blank";
    private static final UUID BLANK_OWNER = UUID.fromString("0-0-0-0-0");
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> FORWARD = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SIDE = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> UP = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_OFF = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_OFF = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_OFF_MOD = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_OFF_MOD = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_OFF_MOD_A = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_OFF_MOD_A = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_ROT_MAIN = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_ROT_MAIN = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_ROT = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_ROT = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Z_ROT = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_MOD = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_MOD = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Z_MOD = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_MOD_A = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_MOD_A = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Z_MOD_A = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE_MOD = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE_MOD_A = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ALPHA_MOD = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ALPHA_MOD_A = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> BOUND_POS = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BOUND_ROT = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANIMATED = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FRAMES = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FRAME_TIME = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TEXTURE_LOC = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> TEXTURE_NAME = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> RENDER_TYPE = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(FlatVFX.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Consumer<FlatVFX> action;
    private boolean created;
    private float xOff;
    private float xOffLerp;
    private float yOff;
    private float yOffLerp;
    private float xRot;
    private float xRotLerp;
    private float yRot;
    private float yRotLerp;
    private float zRot;
    private float zRotLerp;
    private float scale;
    private float scaleLerp;
    private float alpha;
    private float alphaLerp;
    private int frame;
    private int frameTime;

    public FlatVFX(PlayMessages.SpawnEntity message, Level level) {
        this((EntityType)ObscureAPIEntities.VFX.get(), level);
    }

    public FlatVFX(EntityType<?> type, Level level) {
        super(type, level);
        this.action = flatVfx -> {};
        this.created = false;
        this.frame = 1;
        this.frameTime = 0;
    }

    private FlatVFX(@Nonnull Builder builder, Level level) {
        super((EntityType)ObscureAPIEntities.VFX.get(), level);
        this.action = flatVfx -> {};
        this.created = false;
        this.frame = 1;
        this.frameTime = 0;
        if (builder.owner != null) {
            this.m_20088_().m_135381_(OWNER_UUID, Optional.of(builder.owner.m_20148_()));
        }
        this.m_20088_().m_135381_(FORWARD, (Object)Float.valueOf(builder.forward));
        this.m_20088_().m_135381_(SIDE, (Object)Float.valueOf(builder.side));
        this.m_20088_().m_135381_(UP, (Object)Float.valueOf(builder.up));
        this.m_20088_().m_135381_(X_OFF, (Object)Float.valueOf(builder.xOff));
        this.m_20088_().m_135381_(X_OFF_MOD, (Object)Float.valueOf(builder.xOffMod));
        this.m_20088_().m_135381_(X_OFF_MOD_A, (Object)Float.valueOf(builder.xOffModA));
        this.m_20088_().m_135381_(Y_OFF, (Object)Float.valueOf(builder.yOff));
        this.m_20088_().m_135381_(Y_OFF_MOD, (Object)Float.valueOf(builder.yOffMod));
        this.m_20088_().m_135381_(Y_OFF_MOD_A, (Object)Float.valueOf(builder.yOffModA));
        this.m_20088_().m_135381_(X_ROT_MAIN, (Object)Float.valueOf(builder.xRotMain));
        this.m_20088_().m_135381_(X_ROT, (Object)Float.valueOf(builder.xRot));
        this.m_20088_().m_135381_(X_MOD, (Object)Float.valueOf(builder.xMod));
        this.m_20088_().m_135381_(X_MOD_A, (Object)Float.valueOf(builder.xModA));
        this.m_20088_().m_135381_(Y_ROT_MAIN, (Object)Float.valueOf(builder.yRotMain));
        this.m_20088_().m_135381_(Y_ROT, (Object)Float.valueOf(builder.yRot));
        this.m_20088_().m_135381_(Y_MOD, (Object)Float.valueOf(builder.yMod));
        this.m_20088_().m_135381_(Y_MOD_A, (Object)Float.valueOf(builder.yModA));
        this.m_20088_().m_135381_(Z_ROT, (Object)Float.valueOf(builder.zRot));
        this.m_20088_().m_135381_(Z_MOD, (Object)Float.valueOf(builder.zMod));
        this.m_20088_().m_135381_(Z_MOD_A, (Object)Float.valueOf(builder.zModA));
        this.m_20088_().m_135381_(LIFETIME, (Object)builder.lifetime);
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(builder.scale));
        this.m_20088_().m_135381_(SCALE_MOD, (Object)Float.valueOf(builder.scaleMod));
        this.m_20088_().m_135381_(SCALE_MOD_A, (Object)Float.valueOf(builder.scaleModA));
        this.m_20088_().m_135381_(ALPHA, (Object)Float.valueOf(builder.alpha));
        this.m_20088_().m_135381_(ALPHA_MOD, (Object)Float.valueOf(builder.alphaMod));
        this.m_20088_().m_135381_(ALPHA_MOD_A, (Object)Float.valueOf(builder.alphaModA));
        this.m_20088_().m_135381_(BOUND_POS, (Object)builder.boundPos);
        this.m_20088_().m_135381_(BOUND_ROT, (Object)builder.boundRot);
        this.m_20088_().m_135381_(ANIMATED, (Object)builder.animated);
        this.m_20088_().m_135381_(FRAMES, (Object)builder.frames);
        this.m_20088_().m_135381_(FRAME_TIME, (Object)builder.frameTime);
        this.m_20088_().m_135381_(TEXTURE_LOC, (Object)builder.textureLoc);
        this.m_20088_().m_135381_(TEXTURE_NAME, (Object)builder.textureName);
        this.m_20088_().m_135381_(RENDER_TYPE, (Object)builder.renderType);
        this.action = builder.action;
        this.m_20219_(new Vec3((double)builder.x, (double)builder.y, (double)builder.z));
        level.m_7967_((Entity)this);
        if (builder.sound != null) {
            this.m_9236_().m_6269_(null, (Entity)this, builder.sound, SoundSource.MASTER, builder.volume, builder.pitch);
        }
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(LIFETIME, (Object)20);
        this.m_20088_().m_135372_(FORWARD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(SIDE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(UP, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_OFF, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_OFF_MOD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_OFF_MOD_A, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Y_OFF, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Y_OFF_MOD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Y_OFF_MOD_A, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_ROT_MAIN, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_ROT, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_MOD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_MOD_A, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Y_ROT_MAIN, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Y_ROT, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Y_MOD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Y_MOD_A, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Z_ROT, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Z_MOD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Z_MOD_A, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(SCALE_MOD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(SCALE_MOD_A, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(ALPHA, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(ALPHA_MOD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(ALPHA_MOD_A, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(OWNER_UUID, Optional.of(BLANK_OWNER));
        this.m_20088_().m_135372_(OWNER_ID, (Object)0);
        this.m_20088_().m_135372_(BOUND_POS, (Object)false);
        this.m_20088_().m_135372_(BOUND_ROT, (Object)false);
        this.m_20088_().m_135372_(AGE, (Object)0);
        this.m_20088_().m_135372_(ANIMATED, (Object)false);
        this.m_20088_().m_135372_(FRAMES, (Object)1);
        this.m_20088_().m_135372_(FRAME_TIME, (Object)20);
        this.m_20088_().m_135372_(TEXTURE_LOC, (Object)BLANK_TEXTURE_LOC);
        this.m_20088_().m_135372_(TEXTURE_NAME, (Object)BLANK_TEXTURE_NAME);
        this.m_20088_().m_135372_(RENDER_TYPE, (Object)0);
    }

    protected void m_7380_(@Nonnull CompoundTag data) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("lifetime", ((Integer)this.m_20088_().m_135370_(LIFETIME)).intValue());
        tag.m_128350_("forward", ((Float)this.m_20088_().m_135370_(FORWARD)).floatValue());
        tag.m_128350_("side", ((Float)this.m_20088_().m_135370_(SIDE)).floatValue());
        tag.m_128350_("up", ((Float)this.m_20088_().m_135370_(UP)).floatValue());
        tag.m_128350_("xOff", ((Float)this.m_20088_().m_135370_(X_OFF)).floatValue());
        tag.m_128350_("xOffMod", ((Float)this.m_20088_().m_135370_(X_OFF_MOD)).floatValue());
        tag.m_128350_("xOffModA", ((Float)this.m_20088_().m_135370_(X_OFF_MOD_A)).floatValue());
        tag.m_128350_("yOff", ((Float)this.m_20088_().m_135370_(Y_OFF)).floatValue());
        tag.m_128350_("yOffMod", ((Float)this.m_20088_().m_135370_(Y_OFF_MOD)).floatValue());
        tag.m_128350_("yOffModA", ((Float)this.m_20088_().m_135370_(Y_OFF_MOD_A)).floatValue());
        tag.m_128350_("xRotMain", ((Float)this.m_20088_().m_135370_(X_ROT_MAIN)).floatValue());
        tag.m_128350_("yRotMain", ((Float)this.m_20088_().m_135370_(Y_ROT_MAIN)).floatValue());
        tag.m_128350_("xRot", ((Float)this.m_20088_().m_135370_(X_ROT)).floatValue());
        tag.m_128350_("yRot", ((Float)this.m_20088_().m_135370_(Y_ROT)).floatValue());
        tag.m_128350_("zRot", ((Float)this.m_20088_().m_135370_(Z_ROT)).floatValue());
        tag.m_128350_("xMod", ((Float)this.m_20088_().m_135370_(X_MOD)).floatValue());
        tag.m_128350_("yMod", ((Float)this.m_20088_().m_135370_(Y_MOD)).floatValue());
        tag.m_128350_("zMod", ((Float)this.m_20088_().m_135370_(Z_MOD)).floatValue());
        tag.m_128350_("xModA", ((Float)this.m_20088_().m_135370_(X_MOD_A)).floatValue());
        tag.m_128350_("yModA", ((Float)this.m_20088_().m_135370_(Y_MOD_A)).floatValue());
        tag.m_128350_("zModA", ((Float)this.m_20088_().m_135370_(Z_MOD_A)).floatValue());
        tag.m_128350_("scale", ((Float)this.m_20088_().m_135370_(SCALE)).floatValue());
        tag.m_128350_("scaleMod", ((Float)this.m_20088_().m_135370_(SCALE_MOD)).floatValue());
        tag.m_128350_("scaleModA", ((Float)this.m_20088_().m_135370_(SCALE_MOD_A)).floatValue());
        tag.m_128350_("alpha", ((Float)this.m_20088_().m_135370_(ALPHA)).floatValue());
        tag.m_128350_("alphaMod", ((Float)this.m_20088_().m_135370_(ALPHA_MOD)).floatValue());
        tag.m_128350_("alphaModA", ((Float)this.m_20088_().m_135370_(ALPHA_MOD_A)).floatValue());
        tag.m_128362_("ownerUUID", ((Optional)this.m_20088_().m_135370_(OWNER_UUID)).orElse(BLANK_OWNER));
        tag.m_128405_("ownerID", ((Integer)this.m_20088_().m_135370_(OWNER_ID)).intValue());
        tag.m_128379_("boundPos", ((Boolean)this.m_20088_().m_135370_(BOUND_POS)).booleanValue());
        tag.m_128379_("boundRot", ((Boolean)this.m_20088_().m_135370_(BOUND_ROT)).booleanValue());
        tag.m_128405_("age", ((Integer)this.m_20088_().m_135370_(AGE)).intValue());
        tag.m_128379_("animated", ((Boolean)this.m_20088_().m_135370_(ANIMATED)).booleanValue());
        tag.m_128405_("frames", ((Integer)this.m_20088_().m_135370_(FRAMES)).intValue());
        tag.m_128405_("frameTime", ((Integer)this.m_20088_().m_135370_(FRAME_TIME)).intValue());
        tag.m_128359_("textureLoc", (String)this.m_20088_().m_135370_(TEXTURE_LOC));
        tag.m_128359_("textureName", (String)this.m_20088_().m_135370_(TEXTURE_NAME));
        tag.m_128405_("renderType", ((Integer)this.m_20088_().m_135370_(RENDER_TYPE)).intValue());
        data.m_128365_("FlatVFX", (Tag)tag);
    }

    protected void m_7378_(@Nonnull CompoundTag data) {
        if (!data.m_128441_("FlatVFX")) {
            return;
        }
        CompoundTag tag = data.m_128469_("FlatVFX");
        this.m_20088_().m_135381_(LIFETIME, (Object)tag.m_128451_("lifetime"));
        this.m_20088_().m_135381_(FORWARD, (Object)Float.valueOf(tag.m_128457_("forward")));
        this.m_20088_().m_135381_(SIDE, (Object)Float.valueOf(tag.m_128457_("side")));
        this.m_20088_().m_135381_(UP, (Object)Float.valueOf(tag.m_128457_("up")));
        this.m_20088_().m_135381_(X_OFF, (Object)Float.valueOf(tag.m_128457_("xOff")));
        this.m_20088_().m_135381_(X_OFF_MOD, (Object)Float.valueOf(tag.m_128457_("xOffMod")));
        this.m_20088_().m_135381_(X_OFF_MOD_A, (Object)Float.valueOf(tag.m_128457_("xOffModA")));
        this.m_20088_().m_135381_(Y_OFF, (Object)Float.valueOf(tag.m_128457_("yOff")));
        this.m_20088_().m_135381_(Y_OFF_MOD, (Object)Float.valueOf(tag.m_128457_("yOffMod")));
        this.m_20088_().m_135381_(Y_OFF_MOD_A, (Object)Float.valueOf(tag.m_128457_("yOffModA")));
        this.m_20088_().m_135381_(X_ROT_MAIN, (Object)Float.valueOf(tag.m_128457_("xRotMain")));
        this.m_20088_().m_135381_(X_ROT, (Object)Float.valueOf(tag.m_128457_("xRot")));
        this.m_20088_().m_135381_(X_MOD, (Object)Float.valueOf(tag.m_128457_("xMod")));
        this.m_20088_().m_135381_(X_MOD_A, (Object)Float.valueOf(tag.m_128457_("xModA")));
        this.m_20088_().m_135381_(Y_ROT_MAIN, (Object)Float.valueOf(tag.m_128457_("yRotMain")));
        this.m_20088_().m_135381_(Y_ROT, (Object)Float.valueOf(tag.m_128457_("yRot")));
        this.m_20088_().m_135381_(Y_MOD, (Object)Float.valueOf(tag.m_128457_("yMod")));
        this.m_20088_().m_135381_(Y_MOD_A, (Object)Float.valueOf(tag.m_128457_("yModA")));
        this.m_20088_().m_135381_(Z_ROT, (Object)Float.valueOf(tag.m_128457_("zRot")));
        this.m_20088_().m_135381_(Z_MOD, (Object)Float.valueOf(tag.m_128457_("zMod")));
        this.m_20088_().m_135381_(Z_MOD_A, (Object)Float.valueOf(tag.m_128457_("zModA")));
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(tag.m_128457_("scale")));
        this.m_20088_().m_135381_(SCALE_MOD, (Object)Float.valueOf(tag.m_128457_("scaleMod")));
        this.m_20088_().m_135381_(SCALE_MOD_A, (Object)Float.valueOf(tag.m_128457_("scaleModA")));
        this.m_20088_().m_135381_(ALPHA, (Object)Float.valueOf(tag.m_128457_("alpha")));
        this.m_20088_().m_135381_(ALPHA_MOD, (Object)Float.valueOf(tag.m_128457_("alphaMod")));
        this.m_20088_().m_135381_(ALPHA_MOD_A, (Object)Float.valueOf(tag.m_128457_("alphaModA")));
        this.m_20088_().m_135381_(OWNER_UUID, Optional.of(tag.m_128342_("ownerUUID")));
        this.m_20088_().m_135381_(OWNER_ID, (Object)tag.m_128451_("ownerID"));
        this.m_20088_().m_135381_(BOUND_POS, (Object)tag.m_128471_("boundPos"));
        this.m_20088_().m_135381_(BOUND_ROT, (Object)tag.m_128471_("boundRot"));
        this.m_20088_().m_135381_(AGE, (Object)tag.m_128451_("age"));
        this.m_20088_().m_135381_(ANIMATED, (Object)tag.m_128471_("animated"));
        this.m_20088_().m_135381_(FRAMES, (Object)tag.m_128451_("frames"));
        this.m_20088_().m_135381_(FRAME_TIME, (Object)tag.m_128451_("frameTime"));
        this.m_20088_().m_135381_(TEXTURE_LOC, (Object)tag.m_128461_("textureLoc"));
        this.m_20088_().m_135381_(TEXTURE_NAME, (Object)tag.m_128461_("textureName"));
        this.m_20088_().m_135381_(RENDER_TYPE, (Object)tag.m_128451_("renderType"));
    }

    public void m_8119_() {
        this.xOffLerp = this.xOff;
        this.yOffLerp = this.yOff;
        this.xRotLerp = this.xRot;
        this.yRotLerp = this.yRot;
        this.zRotLerp = this.zRot;
        this.scaleLerp = this.scale;
        this.alphaLerp = this.alpha;
        this.xOff = ((Float)this.m_20088_().m_135370_(X_OFF)).floatValue();
        this.yOff = ((Float)this.m_20088_().m_135370_(Y_OFF)).floatValue();
        this.xRot = ((Float)this.m_20088_().m_135370_(X_ROT)).floatValue();
        this.yRot = ((Float)this.m_20088_().m_135370_(Y_ROT)).floatValue();
        this.zRot = ((Float)this.m_20088_().m_135370_(Z_ROT)).floatValue();
        this.scale = ((Float)this.m_20088_().m_135370_(SCALE)).floatValue();
        this.alpha = ((Float)this.m_20088_().m_135370_(ALPHA)).floatValue();
        if (!this.created) {
            this.xOffLerp = this.xOff;
            this.yOffLerp = this.yOff;
            this.xRotLerp = this.xRot;
            this.yRotLerp = this.yRot;
            this.zRotLerp = this.zRot;
            this.scaleLerp = this.scale;
            this.alphaLerp = this.alpha;
            this.created = true;
            this.m_8119_();
        } else {
            this.action.accept(this);
        }
        if (!this.m_9236_().f_46443_) {
            UUID ownerUUID;
            ServerLevel server;
            Entity owner;
            this.m_20088_().m_135381_(AGE, (Object)((Integer)this.m_20088_().m_135370_(AGE) + 1));
            if ((Integer)this.m_20088_().m_135370_(AGE) >= (Integer)this.m_20088_().m_135370_(LIFETIME)) {
                this.m_146870_();
            }
            this.m_20088_().m_135381_(X_OFF, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(X_OFF)).floatValue() + ((Float)this.m_20088_().m_135370_(X_OFF_MOD)).floatValue()));
            this.m_20088_().m_135381_(Y_OFF, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(Y_OFF)).floatValue() + ((Float)this.m_20088_().m_135370_(Y_OFF_MOD)).floatValue()));
            this.m_20088_().m_135381_(X_ROT, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(X_ROT)).floatValue() + ((Float)this.m_20088_().m_135370_(X_MOD)).floatValue()));
            this.m_20088_().m_135381_(Y_ROT, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(Y_ROT)).floatValue() + ((Float)this.m_20088_().m_135370_(Y_MOD)).floatValue()));
            this.m_20088_().m_135381_(Z_ROT, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(Z_ROT)).floatValue() + ((Float)this.m_20088_().m_135370_(Z_MOD)).floatValue()));
            this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(SCALE)).floatValue() + ((Float)this.m_20088_().m_135370_(SCALE_MOD)).floatValue()));
            this.m_20088_().m_135381_(ALPHA, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(ALPHA)).floatValue() + ((Float)this.m_20088_().m_135370_(ALPHA_MOD)).floatValue()));
            this.m_20088_().m_135381_(X_OFF_MOD, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(X_OFF_MOD)).floatValue() + ((Float)this.m_20088_().m_135370_(X_OFF_MOD_A)).floatValue()));
            this.m_20088_().m_135381_(Y_OFF_MOD, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(Y_OFF_MOD)).floatValue() + ((Float)this.m_20088_().m_135370_(Y_OFF_MOD_A)).floatValue()));
            this.m_20088_().m_135381_(X_MOD, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(X_MOD)).floatValue() + ((Float)this.m_20088_().m_135370_(X_MOD_A)).floatValue()));
            this.m_20088_().m_135381_(Y_MOD, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(Y_MOD)).floatValue() + ((Float)this.m_20088_().m_135370_(Y_MOD_A)).floatValue()));
            this.m_20088_().m_135381_(Z_MOD, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(Z_MOD)).floatValue() + ((Float)this.m_20088_().m_135370_(Z_MOD_A)).floatValue()));
            this.m_20088_().m_135381_(SCALE_MOD, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(SCALE_MOD)).floatValue() + ((Float)this.m_20088_().m_135370_(SCALE_MOD_A)).floatValue()));
            this.m_20088_().m_135381_(ALPHA_MOD, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(ALPHA_MOD)).floatValue() + ((Float)this.m_20088_().m_135370_(ALPHA_MOD_A)).floatValue()));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel && (owner = (server = (ServerLevel)level).m_8791_(ownerUUID = ((Optional)this.m_20088_().m_135370_(OWNER_UUID)).orElse(BLANK_OWNER))) != null) {
                this.m_20088_().m_135381_(OWNER_ID, (Object)owner.m_19879_());
            }
            Entity owner2 = this.getOwner();
            if (((Boolean)this.m_20088_().m_135370_(BOUND_POS)).booleanValue() && owner2 != null) {
                this.m_20219_(this.getRelativePos(owner2));
            }
        } else if (((Boolean)this.m_20088_().m_135370_(ANIMATED)).booleanValue()) {
            ++this.frameTime;
            if (this.frameTime >= (Integer)this.m_20088_().m_135370_(FRAME_TIME)) {
                this.frameTime = 0;
                ++this.frame;
                if (this.frame > (Integer)this.m_20088_().m_135370_(FRAMES)) {
                    this.frame = 1;
                }
            }
        }
        super.m_8119_();
    }

    public int getAge() {
        return (Integer)this.m_20088_().m_135370_(AGE);
    }

    public int getLifeTime() {
        return (Integer)this.m_20088_().m_135370_(LIFETIME);
    }

    @Nullable
    public Entity getOwner() {
        return this.m_9236_().m_6815_(((Integer)this.m_20088_().m_135370_(OWNER_ID)).intValue());
    }

    public Vec3 getRelativePos(@Nonnull Entity entity) {
        Vec3 pos = entity.m_20182_();
        return new Vec3(pos.f_82479_ + Math.cos(Math.toRadians(entity.m_6080_() + 90.0f + ((Float)this.m_20088_().m_135370_(SIDE)).floatValue())) * (double)((Float)this.m_20088_().m_135370_(FORWARD)).floatValue(), pos.f_82480_ + (double)((Float)this.m_20088_().m_135370_(UP)).floatValue(), pos.f_82481_ + Math.sin(Math.toRadians(entity.m_6080_() + 90.0f + ((Float)this.m_20088_().m_135370_(SIDE)).floatValue())) * (double)((Float)this.m_20088_().m_135370_(FORWARD)).floatValue());
    }

    public ResourceLocation getTexture() {
        if (((Boolean)this.m_20088_().m_135370_(ANIMATED)).booleanValue()) {
            return new ResourceLocation((String)this.m_20088_().m_135370_(TEXTURE_LOC), "textures/vfx/" + (String)this.m_20088_().m_135370_(TEXTURE_NAME) + "_" + this.frame + ".png");
        }
        return new ResourceLocation((String)this.m_20088_().m_135370_(TEXTURE_LOC), "textures/vfx/" + (String)this.m_20088_().m_135370_(TEXTURE_NAME) + ".png");
    }

    public float getXOff(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.xOffLerp, (float)this.xOff);
    }

    public float getYOff(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.yOffLerp, (float)this.yOff);
    }

    public float getXRotMain() {
        return ((Float)this.m_20088_().m_135370_(X_ROT_MAIN)).floatValue();
    }

    public float getYRotMain() {
        return ((Float)this.m_20088_().m_135370_(Y_ROT_MAIN)).floatValue();
    }

    public float getXRot(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.xRotLerp, (float)this.xRot);
    }

    public float getYRot(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.yRotLerp, (float)this.yRot);
    }

    public float getZRot(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.zRotLerp, (float)this.zRot);
    }

    public float getScale(float partialTicks) {
        return Math.max(0.0f, Mth.m_14179_((float)partialTicks, (float)this.scaleLerp, (float)this.scale));
    }

    public float getAlpha(float partialTicks) {
        return Math.min(1.0f, Math.max(0.0f, Mth.m_14179_((float)partialTicks, (float)this.alphaLerp, (float)this.alpha)));
    }

    public int getRenderType() {
        return (Integer)this.m_20088_().m_135370_(RENDER_TYPE);
    }

    @Nonnull
    public AABB m_6921_() {
        return super.m_6921_().m_82400_(10.0);
    }

    public static class Builder {
        private final int lifetime;
        private float x;
        private float y;
        private float z;
        private float forward;
        private float side;
        private float up;
        private float xRotMain;
        private float yRotMain;
        private float xRot;
        private float yRot;
        private float zRot;
        private float xOff;
        private float xOffMod;
        private float xOffModA;
        private float yOff;
        private float yOffMod;
        private float yOffModA;
        private float xMod;
        private float yMod;
        private float zMod;
        private float xModA;
        private float yModA;
        private float zModA;
        private float scaleMod;
        private float scaleModA;
        private float alphaMod;
        private float alphaModA;
        private float scale;
        private float alpha = 1.0f;
        private Entity owner = null;
        private boolean boundPos;
        private boolean boundRot;
        private boolean animated = false;
        private int frames = 1;
        private int frameTime = 20;
        private String textureLoc = "obscure_api";
        private String textureName = "blank";
        private int renderType;
        private Consumer<FlatVFX> action = flatVfx -> {};
        private SoundEvent sound = null;
        private float volume;
        private float pitch = 1.0f;

        private Builder(int lifetime) {
            this.lifetime = lifetime;
        }

        @Nonnull
        @Contract(value="_ -> new", pure=true)
        public static Builder create(int lifetime) {
            return new Builder(lifetime);
        }

        public Builder pos(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder pos(@Nonnull Vec3 pos) {
            this.x = (float)pos.f_82479_;
            this.y = (float)pos.f_82480_;
            this.z = (float)pos.f_82481_;
            return this;
        }

        public Builder pos(double x, double y, double z) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            return this;
        }

        public Builder relativePos(LivingEntity entity, float forward, float left, float up) {
            Vec3 pos = EntityUtils.getRelativePos((Entity)entity, forward, left, up);
            this.x = (float)pos.f_82479_;
            this.y = (float)pos.f_82480_;
            this.z = (float)pos.f_82481_;
            return this;
        }

        public Builder moveForward(float offset, float mod2, float modA) {
            this.xOff = offset * -1.0f;
            this.xOffMod = mod2 * -1.0f;
            this.xOffModA = modA * -1.0f;
            return this;
        }

        public Builder moveUp(float offset, float mod2, float modA) {
            this.yOff = offset * -1.0f;
            this.yOffMod = mod2 * -1.0f;
            this.yOffModA = modA * -1.0f;
            return this;
        }

        public Builder xRot(float rot, float mod2, float modA) {
            this.xRot += rot;
            this.xMod = mod2;
            this.xModA = modA;
            return this;
        }

        public Builder yRot(float rot, float mod2, float modA) {
            this.yRot += rot;
            this.yMod = mod2;
            this.yModA = modA;
            return this;
        }

        public Builder zRot(float rot, float mod2, float modA) {
            this.zRot += rot;
            this.zMod = mod2;
            this.zModA = modA;
            return this;
        }

        public Builder mainRot(float xRot, float yRot) {
            if (xRot != 0.0f) {
                this.xRotMain = xRot;
            }
            if (yRot != 0.0f) {
                this.yRotMain = yRot;
            }
            return this;
        }

        public Builder relativeRot(LivingEntity entity, boolean x, boolean y) {
            if (x) {
                this.xRotMain = entity.m_5686_(1.0f);
            }
            if (y) {
                this.yRotMain = entity.m_5675_(1.0f) - 90.0f;
            }
            return this;
        }

        public Builder scale(float scale, float mod2, float modA) {
            this.scale = scale;
            this.scaleMod = mod2;
            this.scaleModA = modA;
            return this;
        }

        public Builder alpha(float alpha, float mod2, float modA) {
            this.alpha = alpha;
            this.alphaMod = mod2;
            this.alphaModA = modA;
            return this;
        }

        public Builder owner(Entity owner) {
            this.owner = owner;
            return this;
        }

        public Builder boundPos(boolean flag, float relativeFront, float relativeSide, float relativeUp) {
            this.boundPos = flag;
            this.forward = relativeFront;
            this.side = relativeSide;
            this.up = relativeUp;
            return this;
        }

        public Builder boundRot(boolean flag) {
            this.boundRot = flag;
            return this;
        }

        public Builder texture(String modID, String name) {
            this.textureLoc = modID;
            this.textureName = name;
            return this;
        }

        public Builder animatedTexture(String modID, String name, int frames, int frameTime) {
            this.animated = true;
            this.textureLoc = modID;
            this.textureName = name;
            this.frames = frames;
            this.frameTime = frameTime;
            return this;
        }

        public Builder render(@Nonnull RenderType type) {
            this.renderType = type.getValue();
            return this;
        }

        public Builder sound(SoundEvent sound, float volume, float pitch) {
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
            return this;
        }

        public Builder action(Consumer<FlatVFX> action) {
            this.action = action;
            return this;
        }

        public void build(@Nonnull Level level) {
            if (!level.f_46443_) {
                new FlatVFX(this, level);
            }
        }

        public static enum RenderType {
            TRANSLUCENT_EMISSIVE(0),
            EYES(1),
            END_GATEWAY(2),
            END_PORTAL(3);

            private final int VALUE;

            private RenderType(int value) {
                this.VALUE = value;
            }

            public int getValue() {
                return this.VALUE;
            }
        }
    }
}

