/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.common.glyph.EffectMark;
import com.github.jarva.arsadditions.common.glyph.MethodRecall;
import com.github.jarva.arsadditions.common.glyph.MethodRetaliate;
import com.github.jarva.arsadditions.common.ritual.RitualChunkLoading;
import com.github.jarva.arsadditions.common.ritual.RitualLocateStructure;
import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.github.jarva.arsadditions.setup.registry.recipes.LocateStructureRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.ImbuementRecipeRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ArsNouveauRegistry {
    public static List<AbstractSpellPart> GLYPHS = new ArrayList<AbstractSpellPart>();
    public static List<AbstractRitual> RITUALS = new ArrayList<AbstractRitual>();

    public static void init() {
        ArsNouveauRegistry.registerRituals();
        ArsNouveauRegistry.registerGlyphs();
        LocateStructureRegistry.INSTANCE = new LocateStructureRegistry();
        ImbuementRecipeRegistry.INSTANCE.addRecipeType(AddonRecipeRegistry.CHARM_CHARGING_TYPE);
        ImbuementRecipeRegistry.INSTANCE.addRecipeType(AddonRecipeRegistry.BULK_SCRIBING_TYPE);
        ImbuementRecipeRegistry.INSTANCE.addRecipeType(AddonRecipeRegistry.IMBUE_SCROLL_TYPE);
    }

    private static void registerGlyphs() {
        ArsNouveauRegistry.register((AbstractSpellPart)MethodRetaliate.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectMark.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)MethodRecall.INSTANCE);
    }

    private static void registerRituals() {
        ArsNouveauRegistry.register(new RitualChunkLoading());
        ArsNouveauRegistry.register(new RitualLocateStructure());
    }

    private static void register(AbstractRitual ritual) {
        RitualRegistry.registerRitual((AbstractRitual)ritual);
        RITUALS.add(ritual);
    }

    private static void register(AbstractSpellPart glyph) {
        GlyphRegistry.registerSpell((AbstractSpellPart)glyph);
        GLYPHS.add(glyph);
    }

    static {
        BasicSpellTurret.TURRET_BEHAVIOR_MAP.put(MethodRecall.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel serverLevel, BlockPos pos, Player fakePlayer, Position dispensePosition, Direction direction) {
                resolver.onCast(null, (Level)serverLevel);
            }
        });
    }
}

