/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.recipes;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.imbuement.CharmChargingRecipe;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public class CharmChargingProvider
extends SimpleDataProvider {
    public List<CharmChargingRecipe> recipes = new ArrayList<CharmChargingRecipe>();

    public CharmChargingProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (CharmChargingRecipe recipe : this.recipes) {
            Path path = CharmChargingProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, recipe.asRecipe(), path);
        }
    }

    protected void addEntries() {
        for (Map.Entry<CharmRegistry.CharmType, RegistryObject<Item>> entry : AddonItemRegistry.CHARMS.entrySet()) {
            CharmRegistry.CharmType type = entry.getKey();
            this.addEntry(type.m_7912_(), ResourceOrTag.item((Item)entry.getValue().get()), type.getCostPerCharge());
        }
    }

    private void addEntry(String id, ResourceOrTag<Item> reagent, int costPerCharge) {
        this.recipes.add(new CharmChargingRecipe(ArsAdditions.prefix(id), reagent, costPerCharge));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_additions/recipes/imbuement_charging/" + id + ".json");
    }

    public String m_6055_() {
        return "Imbuement Charging Datagen";
    }
}

