/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.conditions;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.setup.config.CommonConfig;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigCondition
implements ICondition {
    private static final ResourceLocation NAME = ArsAdditions.prefix("config");
    private final String configPath;

    public ConfigCondition(String configPath) {
        this.configPath = configPath;
    }

    public String toString() {
        return "config(\"" + this.configPath + "\")";
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext iContext) {
        return (Boolean)CommonConfig.COMMON.config.get(this.configPath).get();
    }

    public static class Serializer
    implements IConditionSerializer<ConfigCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject jsonObject, ConfigCondition iCondition) {
            jsonObject.addProperty("config", iCondition.configPath);
        }

        public ConfigCondition read(JsonObject jsonObject) {
            return new ConfigCondition(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"config"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

