/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.common.block.EnchantingWixieCauldron;
import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonBlockNames;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DefaultLootDatagen
extends LootTableProvider {
    public DefaultLootDatagen(PackOutput packOutput) {
        super(packOutput, new HashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTableProvider::new, LootContextParamSets.f_81421_)));
    }

    public static class BlockLootTableProvider
    extends BlockLootSubProvider {
        private final List<Block> list = new ArrayList<Block>();

        protected BlockLootTableProvider() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_(), new HashMap());
        }

        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> p_249322_) {
            this.m_245660_();
            HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceLocation resourcelocation;
                if (!block.m_245993_(this.f_243739_) || (resourcelocation = block.m_60589_()) == BuiltInLootTables.f_78712_ || !set.add(resourcelocation) || (loottable$builder = (LootTable.Builder)this.f_244441_.remove(resourcelocation)) == null) continue;
                p_249322_.accept(resourcelocation, loottable$builder);
            }
        }

        protected void m_245660_() {
            String[][] nameList;
            this.registerManaMachine(AddonBlockRegistry.ENDER_SOURCE_JAR, AddonBlockRegistry.ENDER_SOURCE_JAR_TILE);
            for (String[] names : nameList = new String[][]{AddonBlockNames.CHAINS, AddonBlockNames.MAGELIGHT_LANTERNS, AddonBlockNames.LANTERNS, AddonBlockNames.BUTTONS, AddonBlockNames.DECORATIVE_SOURCESTONES, AddonBlockNames.WALLS, AddonBlockNames.TRAPDOORS, AddonBlockNames.CARPETS}) {
                for (Block block : AddonBlockRegistry.getBlocks(names)) {
                    this.registerDropSelf(block);
                }
            }
            String[] doors = AddonBlockNames.DOORS;
            for (Block door : AddonBlockRegistry.getBlocks(doors)) {
                this.list.add(door);
                this.m_247577_(door, this.m_247398_(door));
            }
            this.registerDropSelf((Block)AddonBlockRegistry.SOURCE_SPAWNER.get());
            WarpNexus warpNexus = (WarpNexus)((Object)AddonBlockRegistry.WARP_NEXUS.get());
            LootPool.Builder nexusBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)warpNexus).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Inventory", "BlockEntityTag.Inventory", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("color", "BlockEntityTag.color", CopyNbtFunction.MergeStrategy.REPLACE)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)warpNexus).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(WarpNexus.HALF, (Comparable)DoubleBlockHalf.LOWER))));
            this.list.add(warpNexus);
            this.m_247577_(warpNexus, LootTable.m_79147_().m_79161_(nexusBuilder));
            EnchantingWixieCauldron enchantingWixieCauldron = (EnchantingWixieCauldron)((Object)AddonBlockRegistry.WIXIE_ENCHANTING.get());
            this.list.add((Block)enchantingWixieCauldron);
            this.m_246125_((Block)enchantingWixieCauldron, (ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK);
        }

        private void registerDropSelf(Block block) {
            this.list.add(block);
            this.m_245724_(block);
        }

        private <B extends Block, T extends BlockEntity> void registerManaMachine(RegistryObject<B> block, RegistryObject<BlockEntityType<T>> tile) {
            this.list.add((Block)block.get());
            this.m_247577_((Block)block.get(), this.createManaMachineTable((Block)block.get(), (BlockEntityType)tile.get()));
        }

        public LootTable.Builder createManaMachineTable(Block block, BlockEntityType<?> tile) {
            LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("source", "BlockEntityTag.source", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("max_source", "BlockEntityTag.max_source", CopyNbtFunction.MergeStrategy.REPLACE)));
            return LootTable.m_79147_().m_79161_(builder);
        }
    }
}

