/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.ritual;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.server.storage.ChunkLoadingData;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class RitualChunkLoading
extends AbstractRitual {
    private List<ChunkPos> chunks = null;
    private UUID activatedPlayer = null;
    private int ticksSinceStart = 0;
    public static ResourceLocation RESOURCE_LOCATION = ArsAdditions.prefix("ritual_chunk_loading");

    protected void tick() {
        Level world = this.getWorld();
        if (world == null || world.f_46443_ || this.getPos() == null) {
            return;
        }
        if (this.activatedPlayer == null) {
            BlockPos blockPos = this.getPos();
            Player nearby = this.getWorld().m_45924_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 5.0, true);
            if (nearby != null) {
                this.activatedPlayer = nearby.m_20148_();
            } else {
                return;
            }
        }
        if (this.chunks == null) {
            this.chunks = this.getChunks();
        }
        if (this.needsSourceNow()) {
            this.setChunkLoaded(false);
            return;
        }
        ++this.ticksSinceStart;
        if (this.ticksSinceStart % 20 == 0) {
            this.setChunkLoaded(true);
        }
        if (((Boolean)ServerConfig.SERVER.chunkloading_repeat_cost.get()).booleanValue() && this.ticksSinceStart % (Integer)ServerConfig.SERVER.chunkloading_cost_interval.get() == 0) {
            this.setNeedsSource(true);
        }
    }

    private List<ChunkPos> getChunks() {
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        if (this.getPos() == null) {
            return chunks;
        }
        int radius = this.getRadius();
        ChunkPos chunk = new ChunkPos(this.getPos());
        for (int x = chunk.f_45578_ - radius; x <= chunk.f_45578_ + radius; ++x) {
            for (int z = chunk.f_45579_ - radius; z <= chunk.f_45579_ + radius; ++z) {
                chunks.add(new ChunkPos(x, z));
            }
        }
        return chunks;
    }

    public int getRadius() {
        int initialRadius = (Integer)ServerConfig.SERVER.chunkloading_initial_radius.get();
        if (!((Boolean)ServerConfig.SERVER.chunkloading_radius_incremental.get()).booleanValue()) {
            return initialRadius;
        }
        return initialRadius + this.getConsumedCount();
    }

    public int getConsumedCount() {
        Item configured = this.getConfiguredItem();
        long consumedCount = this.getConsumedItems().stream().filter(item -> item.m_150930_(configured)).count();
        return (int)Math.min(consumedCount, (long)((Integer)ServerConfig.SERVER.chunkloading_radius_increment_max.get()).intValue());
    }

    public boolean canConsumeItem(ItemStack stack) {
        if (this.getWorld() == null) {
            return super.canConsumeItem(stack);
        }
        if (!((Boolean)ServerConfig.SERVER.chunkloading_radius_incremental.get()).booleanValue()) {
            return super.canConsumeItem(stack);
        }
        if (this.getConsumedCount() == ((Integer)ServerConfig.SERVER.chunkloading_radius_increment_max.get()).intValue()) {
            return super.canConsumeItem(stack);
        }
        Item configured = this.getConfiguredItem();
        return stack.m_150930_(configured);
    }

    public Item getConfiguredItem() {
        if (this.getWorld() == null) {
            return null;
        }
        ResourceLocation item = ResourceLocation.m_135820_((String)((String)ServerConfig.SERVER.chunkloading_radius_increment_item.get()));
        if (item == null) {
            return null;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)item);
        Optional optional = this.getWorld().m_246945_(Registries.f_256913_).m_254902_(key);
        return optional.map(Holder::get).orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canStart(Player player) {
        Level world = this.getWorld();
        BlockPos blockPos = this.getPos();
        if (world == null) return false;
        if (blockPos == null) {
            return false;
        }
        if (world.f_46443_) {
            return true;
        }
        if (player == null) {
            Player nearby = this.getWorld().m_45924_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 5.0, false);
            if (nearby == null) return false;
            this.activatedPlayer = nearby.m_20148_();
        } else {
            this.activatedPlayer = player.m_20148_();
        }
        if ((Integer)ServerConfig.SERVER.chunkloading_player_limit.get() <= ChunkLoadingData.countChunks(world.m_7654_(), this.activatedPlayer)) return false;
        return true;
    }

    public void onStart(Player player) {
        super.onStart(player);
        this.setNeedsSource(this.consumesSource());
    }

    public void onStatusChanged(boolean status) {
        this.setChunkLoaded(status);
    }

    public void onDestroy() {
        this.onEnd();
    }

    public void onEnd() {
        super.onEnd();
        this.setChunkLoaded(false);
    }

    public boolean consumesSource() {
        return (Boolean)ServerConfig.SERVER.chunkloading_has_cost.get();
    }

    public int getSourceCost() {
        return (Integer)ServerConfig.SERVER.chunkloading_cost.get();
    }

    public String getLangName() {
        return "Arcane Permanence";
    }

    public String getLangDescription() {
        return "The Ritual of Arcane Permanence force-loads surrounding chunks when provided with a constant stream of source.";
    }

    public ResourceLocation getRegistryName() {
        return RESOURCE_LOCATION;
    }

    private void setChunkLoaded(boolean shouldLoad) {
        Object object;
        if (this.getWorld() != null && (object = this.getWorld()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            if (this.getPos() != null) {
                if (this.chunks == null) {
                    this.chunks = this.getChunks();
                }
                for (ChunkPos chunk : this.chunks) {
                    ChunkLoadingData.updateChunk(serverLevel, this.activatedPlayer, chunk, shouldLoad);
                }
            }
        }
    }

    public void write(CompoundTag tag) {
        super.write(tag);
        tag.m_128405_("ticksSinceStart", this.ticksSinceStart);
        if (this.activatedPlayer != null) {
            tag.m_128362_("activatedPlayer", this.activatedPlayer);
        }
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.ticksSinceStart = tag.m_128451_("ticksSinceStart");
        if (tag.m_128441_("activatedPlayer")) {
            this.activatedPlayer = tag.m_128342_("activatedPlayer");
        }
    }
}

