/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.common.util.LangUtil;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedDominionWand
extends Item {
    public AdvancedDominionWand() {
        super(AddonItemRegistry.defaultItemProperties().m_41487_(1));
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        ServerLevel serverLevel;
        block6: {
            block5: {
                Level level = player.m_9236_();
                if (!(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (player != null) break block6;
            }
            return super.m_6880_(stack, player, interactionTarget, usedHand);
        }
        if (player.m_6144_()) {
            IWandable wand;
            AdvancedDominionData data = AdvancedDominionData.fromItemStack(stack);
            if (data.getPos() == null && data.getEntityId() == null) {
                data.setData(interactionTarget.m_19879_(), (ResourceKey<Level>)serverLevel.m_46472_());
                data.write(stack);
                PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.dominion_wand.stored_entity"));
                return InteractionResult.SUCCESS;
            }
            IWandable wandable = interactionTarget instanceof IWandable ? (wand = (IWandable)interactionTarget) : null;
            return this.attemptConnection(serverLevel.m_7654_(), data, player, (Triple<IWandable, LivingEntity, BlockPos>)Triple.of((Object)wandable, (Object)interactionTarget, null));
        }
        return super.m_6880_(stack, player, interactionTarget, usedHand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (!pPlayer.m_6144_()) {
            AdvancedDominionData data = AdvancedDominionData.fromItemStack(stack);
            data.toggleMode();
            data.write(stack);
            PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.m_237110_((String)"chat.ars_additions.advanced_dominion_wand.mode", (Object[])new Object[]{data.mode.getTranslatable()}));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ServerLevel serverLevel;
        block6: {
            block5: {
                Level level = context.m_43725_();
                if (!(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (context.m_43723_() != null) break block6;
            }
            return super.m_6225_(context);
        }
        Player player = context.m_43723_();
        if (player.m_6144_()) {
            IWandable wand;
            BlockPos pos = context.m_8083_();
            ItemStack stack = context.m_43722_();
            BlockEntity be = serverLevel.m_7702_(pos);
            AdvancedDominionData data = AdvancedDominionData.fromItemStack(stack);
            if (data.getPos() == null && data.getEntityId() == null) {
                data.setData(pos, (ResourceKey<Level>)serverLevel.m_46472_());
                data.write(stack);
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.dominion_wand.position_set"));
                return InteractionResult.SUCCESS;
            }
            IWandable wandable = be instanceof IWandable ? (wand = (IWandable)be) : null;
            return this.attemptConnection(serverLevel.m_7654_(), data, player, (Triple<IWandable, LivingEntity, BlockPos>)Triple.of((Object)wandable, null, (Object)pos));
        }
        return super.m_6225_(context);
    }

    private InteractionResult attemptConnection(MinecraftServer server, AdvancedDominionData data, Player player, Triple<IWandable, LivingEntity, BlockPos> target) {
        ServerLevel origin = server.m_129880_(data.getLevel());
        IWandable targetWandable = (IWandable)target.getLeft();
        LivingEntity targetLivingEntity = (LivingEntity)target.getMiddle();
        BlockPos targetBlock = (BlockPos)target.getRight();
        Triple<IWandable, LivingEntity, BlockPos> stored = this.getWandable(origin, data.getPos(), data.getEntityId());
        IWandable storedWandable = (IWandable)stored.getLeft();
        LivingEntity storedLivingEntity = (LivingEntity)stored.getMiddle();
        BlockPos storedBlock = (BlockPos)stored.getRight();
        switch (data.mode) {
            case LOCK_FIRST: {
                if (storedWandable != null) {
                    storedWandable.onFinishedConnectionFirst(targetBlock, null, targetLivingEntity, player);
                }
                if (targetWandable == null) break;
                targetWandable.onFinishedConnectionLast(storedBlock, null, storedLivingEntity, player);
                break;
            }
            case LOCK_SECOND: {
                if (storedWandable != null) {
                    storedWandable.onFinishedConnectionLast(targetBlock, null, targetLivingEntity, player);
                }
                if (targetWandable == null) break;
                targetWandable.onFinishedConnectionFirst(storedBlock, null, storedLivingEntity, player);
                break;
            }
            default: {
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.FAIL;
    }

    private Triple<IWandable, LivingEntity, BlockPos> getWandable(ServerLevel level, @Nullable BlockPos pos, @Nullable Integer entityId) {
        Entity wandable2;
        if (pos != null) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof IWandable) {
                IWandable wandable2 = (IWandable)be;
                return Triple.of((Object)wandable2, null, (Object)pos);
            }
            return Triple.of(null, null, (Object)pos);
        }
        if (entityId != null && (wandable2 = level.m_6815_(entityId.intValue())) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)wandable2;
            if (living instanceof IWandable) {
                wandable2 = (IWandable)living;
                return Triple.of((Object)wandable2, (Object)living, null);
            }
            return Triple.of(null, (Object)living, null);
        }
        return Triple.of(null, null, null);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        AdvancedDominionData data = AdvancedDominionData.fromItemStack(stack);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.ars_additions.advanced_dominion_wand.mode", (Object[])new Object[]{data.mode.getTranslatable()}));
        if (data.getPos() != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.ars_additions.warp_index.bound", (Object[])new Object[]{data.pos.m_123341_(), data.pos.m_123342_(), data.pos.m_123343_(), data.level.m_135782_().toString()}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"chat.ars_additions.warp_index.unbound", (Object[])new Object[]{Component.m_237117_((String)"key.sneak"), Component.m_237117_((String)"key.use"), LangUtil.container()}));
        }
    }

    public static class AdvancedDominionData {
        private Mode mode;
        private ResourceKey<Level> level;
        private BlockPos pos;
        private Integer entityId;
        public static final String TAG_KEY = "advanced_dominion";
        public static final Codec<AdvancedDominionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.optionalFieldOf("StoredPos").forGetter(AdvancedDominionData::pos), (App)Level.f_46427_.optionalFieldOf("StoredDim").forGetter(AdvancedDominionData::level), (App)Codec.INT.optionalFieldOf("StoredEntity").forGetter(AdvancedDominionData::entityId), (App)StringRepresentable.m_216439_(Mode::values).fieldOf("Mode").forGetter(AdvancedDominionData::mode)).apply((Applicative)instance, AdvancedDominionData::new));

        private AdvancedDominionData(Optional<BlockPos> pos, Optional<ResourceKey<Level>> level, Optional<Integer> entityId, Mode mode) {
            this.pos = pos.orElse(null);
            this.level = level.orElse(null);
            this.entityId = entityId.orElse(null);
            this.mode = mode;
        }

        private AdvancedDominionData(Mode mode) {
            this.pos = null;
            this.level = null;
            this.entityId = null;
            this.mode = mode;
        }

        public static AdvancedDominionData fromItemStack(ItemStack stack) {
            return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)stack.m_41784_().m_128469_(TAG_KEY)).result().orElse(new AdvancedDominionData(Mode.LOCK_FIRST));
        }

        public void write(ItemStack stack) {
            CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().ifPresent(tag -> stack.m_41784_().m_128365_(TAG_KEY, tag));
        }

        private Optional<BlockPos> pos() {
            return Optional.ofNullable(this.pos);
        }

        private BlockPos getPos() {
            return this.pos;
        }

        private Optional<ResourceKey<Level>> level() {
            return Optional.ofNullable(this.level);
        }

        private ResourceKey<Level> getLevel() {
            return this.level;
        }

        private Optional<Integer> entityId() {
            return Optional.ofNullable(this.entityId);
        }

        private Integer getEntityId() {
            return this.entityId;
        }

        public void setData(BlockPos pos, ResourceKey<Level> level) {
            this.pos = pos;
            this.level = level;
            this.entityId = null;
        }

        public void setData(Integer entityId, ResourceKey<Level> level) {
            this.entityId = entityId;
            this.level = level;
            this.pos = null;
        }

        private Mode mode() {
            return this.mode;
        }

        public void toggleMode() {
            this.mode = this.mode == Mode.LOCK_FIRST ? Mode.LOCK_SECOND : Mode.LOCK_FIRST;
        }

        static enum Mode implements StringRepresentable
        {
            LOCK_FIRST("tooltip.ars_additions.advanced_dominion_wand.mode.first"),
            LOCK_SECOND("tooltip.ars_additions.advanced_dominion_wand.mode.second");

            private final String translatable;

            private Mode(String translatable) {
                this.translatable = translatable;
            }

            @NotNull
            public String m_7912_() {
                return this.name().toLowerCase(Locale.ENGLISH);
            }

            public Component getTranslatable() {
                return Component.m_237115_((String)this.translatable);
            }
        }
    }
}

