/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.glyph;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.setup.registry.names.AddonGlyphNames;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodRetaliate
extends AbstractCastMethod {
    public static MethodRetaliate INSTANCE = new MethodRetaliate();

    private MethodRetaliate() {
        super(ArsAdditions.prefix(AddonGlyphNames.MethodRetaliate), "Retaliate");
    }

    public String getBookDescription() {
        return "Applies spells to the last entity that dealt damage to you. The damage must be within the last 5 seconds.";
    }

    public CastResolveType onCast(@Nullable ItemStack stack, LivingEntity playerEntity, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        return this.cast(playerEntity, resolver);
    }

    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Player player = context.m_43723_();
        if (player == null) {
            return CastResolveType.FAILURE;
        }
        return this.cast((LivingEntity)player, resolver);
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return this.cast(caster, resolver);
    }

    public CastResolveType onCastOnEntity(@Nullable ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return this.cast(caster, resolver);
    }

    public CastResolveType cast(LivingEntity caster, SpellResolver resolver) {
        LivingEntity lastHurtBy = caster.m_21232_();
        if (lastHurtBy == null) {
            return CastResolveType.FAILURE;
        }
        resolver.onResolveEffect(caster.m_9236_(), (HitResult)new EntityHitResult((Entity)lastHurtBy));
        return CastResolveType.SUCCESS;
    }

    protected int getDefaultManaCost() {
        return 25;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }
}

