/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.client.ColorSettings;
import dev.corgitaco.enhancedcelestials.mixin.access.ColorAccess;
import dev.corgitaco.enhancedcelestials.mixin.access.StyleAccess;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;

public class CodecUtil {
    public static final Codec<MobEffect> MOB_EFFECT = CodecUtil.createLoggedExceptionRegistryCodec(BuiltInRegistries.f_256974_);
    public static final Codec<EntityType<?>> ENTITY_TYPE = CodecUtil.createLoggedExceptionRegistryCodec(BuiltInRegistries.f_256780_);
    public static final Codec<ClickEvent.Action> CLICK_EVENT_ACTION_CODEC = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)ClickEvent.Action.valueOf((String)s));
        }
        catch (Exception e) {
            EnhancedCelestials.LOGGER.error(e.getMessage());
            return DataResult.error(e::getMessage);
        }
    }, Enum::name);
    public static final Codec<ClickEvent> CLICK_EVENT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CLICK_EVENT_ACTION_CODEC.fieldOf("action").forGetter(ClickEvent::m_130622_), (App)Codec.STRING.fieldOf("value").forGetter(ClickEvent::m_130623_)).apply((Applicative)builder, ClickEvent::new));
    public static final Codec<Style> STYLE_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.optionalFieldOf("color", (Object)"").forGetter(style -> style.m_131135_() != null ? Integer.toHexString(((ColorAccess)style.m_131135_()).getColorRaw()) : Integer.toHexString(ChatFormatting.WHITE.m_126665_())), (App)Codec.BOOL.optionalFieldOf("bold", (Object)false).forGetter(Style::m_131154_), (App)Codec.BOOL.optionalFieldOf("italic", (Object)false).forGetter(Style::m_131161_), (App)Codec.BOOL.optionalFieldOf("underlined", (Object)false).forGetter(Style::m_131171_), (App)Codec.BOOL.optionalFieldOf("strikethrough", (Object)false).forGetter(Style::m_131168_), (App)Codec.BOOL.optionalFieldOf("obfuscated", (Object)false).forGetter(Style::m_131176_), (App)CLICK_EVENT_CODEC.optionalFieldOf("click_event").forGetter(style -> style.m_131182_() != null ? Optional.of(style.m_131182_()) : Optional.empty())).apply((Applicative)builder, (color, bold, italic, underlined, strikethrough, obfuscated, clickEvent) -> StyleAccess.create(ColorAccess.create(ColorSettings.tryParseColor(color)), bold, italic, underlined, strikethrough, obfuscated, clickEvent.orElse(null), null, null, null)));

    public static <T> Codec<T> createLoggedExceptionRegistryCodec(Registry<T> registry) {
        return ResourceLocation.f_135803_.comapFlatMap(location -> {
            Optional result = registry.m_6612_(location);
            if (result.isEmpty()) {
                StringBuilder registryElements = new StringBuilder();
                for (int i = 0; i < registry.m_6579_().size(); ++i) {
                    Object object = registry.m_7942_(i);
                    registryElements.append(i).append(". \"").append(registry.m_7981_(object).toString()).append("\"\n");
                }
                return DataResult.error(() -> String.format("\"%s\" is not a valid entityType in registry: %s.\nCurrent Registry Values:\n\n%s\n", location.toString(), registry.toString(), registryElements.toString()));
            }
            return DataResult.success(result.get());
        }, arg_0 -> registry.m_7981_(arg_0));
    }

    public record LazyCodec<TYPE>(Supplier<Codec<TYPE>> delegate) implements Codec<TYPE>
    {
        public <T> DataResult<T> encode(TYPE input, DynamicOps<T> ops, T prefix) {
            return this.delegate().get().encode(input, ops, prefix);
        }

        public <T> DataResult<Pair<TYPE, T>> decode(DynamicOps<T> ops, T input) {
            return this.delegate().get().decode(ops, input);
        }
    }
}

