/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play.handler;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundSetUrlPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.core.mixin.client.LevelRendererAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EtchedClientPlayPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handlePlayMusicPacket(ClientboundPlayMusicPacket pkt, NetworkEvent.Context ctx) {
        Minecraft client = Minecraft.m_91087_();
        ClientLevel level = client.f_91073_;
        if (level == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            TrackData[] tracks;
            BlockPos pos = pkt.pos();
            Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)client.f_91060_).getPlayingRecords();
            SoundInstance soundInstance = playingRecords.get(pos);
            if (soundInstance != null) {
                client.m_91106_().m_120399_(soundInstance);
                playingRecords.remove(pos);
            }
            if ((tracks = pkt.tracks()).length == 0) {
                return;
            }
            SoundTracker.playBlockRecord(pos, tracks, 0);
        });
    }

    public static void handlePlayEntityMusicPacket(ClientboundPlayEntityMusicPacket pkt, NetworkEvent.Context ctx) {
        Minecraft client = Minecraft.m_91087_();
        ClientLevel level = client.f_91073_;
        if (level == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            int entityId = pkt.getEntityId();
            SoundInstance soundInstance = SoundTracker.getEntitySound(entityId);
            if (soundInstance != null) {
                if (soundInstance instanceof StopListeningSound) {
                    ((StopListeningSound)soundInstance).stopListening();
                }
                if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.RESTART && client.m_91106_().m_120403_(soundInstance)) {
                    return;
                }
                SoundTracker.setEntitySound(entityId, null);
            }
            if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.STOP) {
                return;
            }
            Entity entity = level.m_6815_(entityId);
            if (entity == null) {
                LOGGER.error("Server sent sound for nonexistent entity: " + entityId);
                return;
            }
            ItemStack record = pkt.getRecord();
            if (!PlayableRecord.isPlayableRecord(record)) {
                LOGGER.error("Server sent invalid music disc: " + String.valueOf(record));
                return;
            }
            Optional<? extends SoundInstance> sound = ((PlayableRecord)record.m_41720_()).createEntitySound(record, entity, 0);
            if (sound.isEmpty()) {
                LOGGER.error("Server sent invalid music disc: " + String.valueOf(record));
                return;
            }
            StopListeningSound entitySound = StopListeningSound.create(sound.get(), () -> client.m_6937_(() -> {
                SoundTracker.setEntitySound(entityId, null);
                SoundTracker.playEntityRecord(record, entityId, 1, false);
            }));
            SoundTracker.setEntitySound(entityId, entitySound);
        });
    }

    public static void handleSetInvalidEtch(ClientboundInvalidEtchUrlPacket pkt, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Screen patt0$temp = Minecraft.m_91087_().f_91080_;
            if (patt0$temp instanceof EtchingScreen) {
                EtchingScreen screen = (EtchingScreen)patt0$temp;
                screen.setReason(pkt.exception());
            }
        });
    }

    public static void handleSetUrl(ClientboundSetUrlPacket pkt, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Screen patt0$temp = Minecraft.m_91087_().f_91080_;
            if (patt0$temp instanceof RadioScreen) {
                RadioScreen screen = (RadioScreen)patt0$temp;
                screen.receiveUrl(pkt.url());
            }
        });
    }

    public static void handleSetAlbumJukeboxTrack(SetAlbumJukeboxTrackPacket pkt, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Screen patt0$temp;
            Minecraft client = Minecraft.m_91087_();
            if (client.f_91073_ != null && (patt0$temp = client.f_91080_) instanceof AlbumJukeboxScreen) {
                AlbumJukeboxScreen screen = (AlbumJukeboxScreen)patt0$temp;
                BlockPos pos = ((AlbumJukeboxMenu)screen.m_6262_()).getPos();
                if (((AlbumJukeboxMenu)screen.m_6262_()).setPlayingTrack((Level)client.f_91073_, pkt)) {
                    AlbumJukeboxBlockEntity entity = (AlbumJukeboxBlockEntity)Objects.requireNonNull(client.f_91073_.m_7702_(pos));
                    SoundTracker.playAlbum(entity, entity.m_58900_(), client.f_91073_, pos, true);
                }
            }
        });
    }
}

