/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.zepalesque.redux.mixin.common.world.PerlinNoiseAccessor;
import org.jetbrains.annotations.Nullable;

public class PerlinNoiseFunction
implements DensityFunction {
    public static final KeyDispatchDataCodec<PerlinNoiseFunction> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(p_208798_ -> p_208798_.group((App)NormalNoise.NoiseParameters.f_192851_.fieldOf("noise").forGetter(func -> func.params), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(func -> func.xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(func -> func.yScale), (App)Codec.LONG.fieldOf("seed").forGetter(func -> func.seed)).apply((Applicative)p_208798_, PerlinNoiseFunction::new)));
    @Nullable
    public PerlinNoise noise = null;
    private static final Map<Long, PerlinNoiseVisitor> VISITORS = new HashMap<Long, PerlinNoiseVisitor>();
    private final PerlinNoise fakeNoise;
    public final NormalNoise.NoiseParameters params;
    private final long seed;
    private final double xzScale;
    private final double yScale;

    public PerlinNoiseFunction(NormalNoise.NoiseParameters params, double xzScale, double yScale, long seed) {
        this.seed = seed;
        this.params = params;
        this.xzScale = xzScale;
        this.yScale = yScale;
        this.fakeNoise = PerlinNoise.m_230535_((RandomSource)new XoroshiroRandomSource(seed), (int)params.f_192853_(), (DoubleList)params.f_192854_());
    }

    public double m_207386_(DensityFunction.FunctionContext context) {
        if (this.noise == null) {
            throw new NullPointerException("PerlinNoiseFunction has not been initialized yet! Please initialize by running mapAll on this function or a parent function with a PerlinNoiseVisitor!");
        }
        return this.noise.m_75408_((double)context.m_207115_() * this.xzScale, (double)context.m_207114_() * this.yScale, (double)context.m_207113_() * this.xzScale);
    }

    public void m_207362_(double[] array, DensityFunction.ContextProvider contextProvider) {
        contextProvider.m_207207_(array, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)this);
    }

    public double m_207402_() {
        return -this.m_207401_();
    }

    public double m_207401_() {
        if (this.noise != null) {
            return ((PerlinNoiseAccessor)this.noise).callMaxValue();
        }
        return ((PerlinNoiseAccessor)this.fakeNoise).callMaxValue();
    }

    public PerlinNoiseFunction initialize(Function<Long, RandomSource> rand) {
        this.noise = PerlinNoise.m_230535_((RandomSource)rand.apply(this.seed), (int)this.params.f_192853_(), (DoubleList)this.params.f_192854_());
        return this;
    }

    public static PerlinNoiseVisitor createOrGetVisitor(long seed) {
        return VISITORS.computeIfAbsent(seed, l -> new PerlinNoiseVisitor(noise -> {
            if (noise.initialized()) {
                return noise;
            }
            return noise.initialize(offset -> new XoroshiroRandomSource(l + offset));
        }));
    }

    public boolean initialized() {
        return this.noise != null;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    public record PerlinNoiseVisitor(UnaryOperator<PerlinNoiseFunction> operator) implements DensityFunction.Visitor
    {
        public DensityFunction m_214017_(DensityFunction function) {
            if (function instanceof PerlinNoiseFunction) {
                PerlinNoiseFunction pnf = (PerlinNoiseFunction)function;
                return (DensityFunction)this.operator.apply(pnf);
            }
            return function;
        }
    }
}

