/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.RandomSource;
import net.zepalesque.redux.util.function.Functions;
import org.jetbrains.annotations.Nullable;

public class ArrayUtil {
    public static <T> T[] generateContents(T[] array, IntFunction<? extends T> factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.apply(index);
        }
        return array;
    }

    public static <T> T[] generate(Class<T> clazz, int length, IntFunction<? extends T> factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        Object[] array = (Object[])Array.newInstance(clazz, length);
        return ArrayUtil.generateContents(array, factory);
    }

    public static int[] generateContents(int[] array, IntUnaryOperator factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.applyAsInt(index);
        }
        return array;
    }

    public static int[] generateInts(int length, IntUnaryOperator factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        int[] array = new int[length];
        return ArrayUtil.generateContents(array, factory);
    }

    public static byte[] generateContents(byte[] array, Functions.Int2ByteFunc factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.applyAsByte(index);
        }
        return array;
    }

    public static byte[] generateBytes(int length, Functions.Int2ByteFunc factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        byte[] array = new byte[length];
        return ArrayUtil.generateContents(array, factory);
    }

    public static short[] generateContents(short[] array, Functions.Int2ShortFunc factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.applyAsShort(index);
        }
        return array;
    }

    public static short[] generateShorts(int length, Functions.Int2ShortFunc factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        short[] array = new short[length];
        return ArrayUtil.generateContents(array, factory);
    }

    public static long[] generateContents(long[] array, IntToLongFunction factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.applyAsLong(index);
        }
        return array;
    }

    public static long[] generateLongs(int length, IntToLongFunction factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        long[] array = new long[length];
        return ArrayUtil.generateContents(array, factory);
    }

    public static float[] generateContents(float[] array, Functions.Int2FloatFunc factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.applyAsFloat(index);
        }
        return array;
    }

    public static float[] generateFloats(int length, Functions.Int2FloatFunc factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        float[] array = new float[length];
        return ArrayUtil.generateContents(array, factory);
    }

    public static double[] generateContents(double[] array, IntToDoubleFunction factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.applyAsDouble(index);
        }
        return array;
    }

    public static double[] generateDoubles(int length, IntToDoubleFunction factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        double[] array = new double[length];
        return ArrayUtil.generateContents(array, factory);
    }

    public static boolean[] generateContents(boolean[] array, Functions.Int2BoolFunc factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.applyAsBoolean(index);
        }
        return array;
    }

    public static boolean[] generateBooleans(int length, Functions.Int2BoolFunc factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        boolean[] array = new boolean[length];
        return ArrayUtil.generateContents(array, factory);
    }

    public static char[] generateContents(char[] array, Functions.Int2CharFunc factory) {
        Objects.requireNonNull(factory, "Factory parameter must not be null!");
        Objects.requireNonNull(array, "Array parameter must not be null!");
        for (int index = 0; index < array.length; ++index) {
            array[index] = factory.applyAsChar(index);
        }
        return array;
    }

    public static char[] generateChars(int length, Functions.Int2CharFunc factory) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Length must be non-negative!");
        char[] array = new char[length];
        return ArrayUtil.generateContents(array, factory);
    }

    public static <T, O extends T> T[] copyFrom(T[] array, O[] toCopy, @Nullable T padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static <T, O extends T> T[] copyFrom(T[] array, O[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, null);
    }

    public static int[] copyFrom(int[] array, int[] toCopy, int padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static int[] copyFrom(int[] array, int[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, 0);
    }

    public static byte[] copyFrom(byte[] array, byte[] toCopy, byte padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static byte[] copyFrom(byte[] array, byte[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, (byte)0);
    }

    public static short[] copyFrom(short[] array, short[] toCopy, short padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static short[] copyFrom(short[] array, short[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, (short)0);
    }

    public static long[] copyFrom(long[] array, long[] toCopy, long padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static long[] copyFrom(long[] array, long[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, 0L);
    }

    public static float[] copyFrom(float[] array, float[] toCopy, float padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static float[] copyFrom(float[] array, float[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, 0.0f);
    }

    public static double[] copyFrom(double[] array, double[] toCopy, double padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static double[] copyFrom(double[] array, double[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, 0.0);
    }

    public static boolean[] copyFrom(boolean[] array, boolean[] toCopy, boolean padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static boolean[] copyFrom(boolean[] array, boolean[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, false);
    }

    public static char[] copyFrom(char[] array, char[] toCopy, char padding) {
        boolean shouldPad = array.length > toCopy.length;
        int split = shouldPad ? toCopy.length : array.length;
        System.arraycopy(toCopy, 0, array, 0, split);
        if (shouldPad) {
            Arrays.fill(array, split, array.length, padding);
        }
        return array;
    }

    public static char[] copyFrom(char[] array, char[] toCopy) {
        return ArrayUtil.copyFrom(array, toCopy, '\u0000');
    }

    public static <T> void shuffle(T[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            T element = array[i];
            array[i] = array[index];
            array[index] = element;
        }
    }

    public static void shuffle(int[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            int element = array[index];
            array[index] = array[i];
            array[i] = element;
        }
    }

    public static void shuffle(byte[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            byte element = array[index];
            array[index] = array[i];
            array[i] = element;
        }
    }

    public static void shuffle(short[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            short element = array[index];
            array[index] = array[i];
            array[i] = element;
        }
    }

    public static void shuffle(long[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            long element = array[index];
            array[index] = array[i];
            array[i] = element;
        }
    }

    public static void shuffle(float[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            float element = array[index];
            array[index] = array[i];
            array[i] = element;
        }
    }

    public static void shuffle(double[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            double element = array[index];
            array[index] = array[i];
            array[i] = element;
        }
    }

    public static void shuffle(boolean[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            boolean element = array[index];
            array[index] = array[i];
            array[i] = element;
        }
    }

    public static void shuffle(char[] array, RandomSource rand) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rand.m_188503_(i + 1);
            char element = array[index];
            array[index] = array[i];
            array[i] = element;
        }
    }
}

