/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.data.resource.biome.registry;

import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.entity.AetherEntityTypes;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.zepalesque.redux.client.audio.ReduxMusic;
import net.zepalesque.redux.data.resource.biome.registry.ReduxBiomes;

public interface BiomeGenerator {
    default public Biome generate(BootstapContext<Biome> context) {
        HolderGetter placed = context.m_255420_(Registries.f_256988_);
        HolderGetter config = context.m_255420_(Registries.f_257003_);
        return BiomeGenerator.biomeBase(this.features(new BiomeGenerationSettings.Builder(placed, config)), this.mobspawns(new MobSpawnSettings.Builder()), this.music(), this.water(), this.waterFog(), 11401668, this.sky(), this.skyFog(), this.precipitation(), this.temperature(), this.downfall());
    }

    default public Music music() {
        return ReduxMusic.DEFAULT_AETHER_MUSIC;
    }

    default public int water() {
        return 5403045;
    }

    default public int waterFog() {
        return 791347;
    }

    default public int sky() {
        return 0xC0C0FF;
    }

    default public int skyFog() {
        return 9671612;
    }

    default public boolean precipitation() {
        return false;
    }

    default public float temperature() {
        return 0.8f;
    }

    default public float downfall() {
        return 0.0f;
    }

    public MobSpawnSettings.Builder mobspawns(MobSpawnSettings.Builder var1);

    public BiomeGenerationSettings.Builder features(BiomeGenerationSettings.Builder var1);

    public static Biome biomeBase(BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder mobSpawns, Music music, int waterColor, int waterFogColor, int grassColor, int skyColor, int skyFogColor, boolean precip, float temp, float downfall) {
        return ReduxBiomes.fullDefinition(precip, temp, downfall, new BiomeSpecialEffects.Builder().m_48019_(skyFogColor).m_48040_(skyColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48045_(grassColor).m_48043_(11665355).m_48031_(BiomeSpecialEffects.GrassColorModifier.NONE).m_48021_(music).m_48018_(), mobSpawns.m_48381_(), gen.m_255380_(), Biome.TemperatureModifier.NONE);
    }

    public static MobSpawnSettings.Builder defaultMobs(MobSpawnSettings.Builder builder) {
        return builder.m_48370_((EntityType)AetherEntityTypes.COCKATRICE.get(), 0.5, 0.15).m_48370_((EntityType)AetherEntityTypes.ZEPHYR.get(), 0.6, 0.16).m_48370_((EntityType)AetherEntityTypes.AECHOR_PLANT.get(), 0.4, 0.11).m_48370_((EntityType)AetherEntityTypes.BLUE_SWET.get(), 0.5, 0.1).m_48370_((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), 0.5, 0.1).m_48370_((EntityType)AetherEntityTypes.WHIRLWIND.get(), 0.4, 0.1).m_48370_((EntityType)AetherEntityTypes.EVIL_WHIRLWIND.get(), 0.4, 0.1).m_48370_((EntityType)AetherEntityTypes.AERWHALE.get(), 0.5, 0.11).m_48376_(AetherMobCategory.AETHER_DARKNESS_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.COCKATRICE.get(), 8, 1, 1)).m_48376_(AetherMobCategory.AETHER_SKY_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.ZEPHYR.get(), 20, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AECHOR_PLANT.get(), 7, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.BLUE_SWET.get(), 6, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), 6, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.WHIRLWIND.get(), 3, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.EVIL_WHIRLWIND.get(), 1, 1, 1)).m_48376_(AetherMobCategory.AETHER_AERWHALE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERWHALE.get(), 10, 1, 1)).m_48368_(0.25f).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.PHYG.get(), 10, 3, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.SHEEPUFF.get(), 12, 3, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.FLYING_COW.get(), 12, 2, 5)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERBUNNY.get(), 11, 3, 3)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.MOA.get(), 8, 1, 3));
    }
}

