/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.client.render.ReduxModelLayers;
import net.zepalesque.redux.client.render.entity.layer.entity.ShimmercowEmissiveLayer;
import net.zepalesque.redux.client.render.entity.model.entity.ShimmercowModel;
import net.zepalesque.redux.entity.passive.Shimmercow;

public class ShimmercowRenderer
extends MobRenderer<Shimmercow, ShimmercowModel<Shimmercow>> {
    private static final ResourceLocation SHIMMERCOW_TEX = Redux.locate("textures/entity/mobs/shimmercow/shimmercow.png");
    private static final ResourceLocation CRAZY_COW_TEX = Redux.locate("textures/entity/mobs/shimmercow/crazy_cow.png");

    public ShimmercowRenderer(EntityRendererProvider.Context context) {
        super(context, new ShimmercowModel(context.m_174023_(ReduxModelLayers.GLIMMERCOW)), 0.7f);
        this.m_115326_((RenderLayer)new ShimmercowEmissiveLayer(this));
    }

    public void render(Shimmercow cow, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85841_(1.25f, 1.25f, 1.25f);
        super.m_7392_((Mob)cow, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(Shimmercow shimmerCow) {
        return shimmerCow.isCrazy() ? CRAZY_COW_TEX : SHIMMERCOW_TEX;
    }

    protected boolean isShaking(Shimmercow entity) {
        return super.m_5936_((LivingEntity)entity) || entity.isCrazy();
    }
}

