/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.event.listener;

import com.aetherteam.aether.entity.AetherEntityTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.stream.StreamSupport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.client.render.entity.IPostRenderer;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderListener {
    @SubscribeEvent
    public static void renderPost(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            LevelRenderer renderer = event.getLevelRenderer();
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            ClientLevel level = minecraft.f_91073_;
            if (level == null || player == null) {
                return;
            }
            Frustum frustum = event.getFrustum();
            Camera camera = event.getCamera();
            EntityRenderDispatcher dispatch = minecraft.m_91290_();
            float partial = Minecraft.m_91087_().getPartialTick();
            RenderBuffers buffers = minecraft.m_91269_();
            Vec3 vec3 = camera.m_90583_();
            double x = vec3.m_7096_();
            double y = vec3.m_7098_();
            double z = vec3.m_7094_();
            PoseStack posestack = event.getPoseStack();
            Iterable allEntities = level.m_104735_();
            Iterable whirlwinds = () -> StreamSupport.stream(allEntities.spliterator(), false).filter(e -> e.m_6095_() == AetherEntityTypes.EVIL_WHIRLWIND.get() || e.m_6095_() == AetherEntityTypes.WHIRLWIND.get()).iterator();
            for (Entity entity : whirlwinds) {
                BlockPos blockpos;
                if (!dispatch.m_114397_(entity, frustum, x, y, z) && !entity.m_20367_((Entity)player) || !level.m_151562_((blockpos = entity.m_20183_()).m_123342_()) && !renderer.m_202430_(blockpos) || entity == camera.m_90592_() && !camera.m_90594_() && (!(camera.m_90592_() instanceof LivingEntity) || !((LivingEntity)camera.m_90592_()).m_5803_())) continue;
                MultiBufferSource.BufferSource multibuffersource = buffers.m_110104_();
                RenderListener.renderEntity(entity, x, y, z, partial, posestack, multibuffersource, dispatch);
            }
        }
    }

    private static void renderEntity(Entity entity, double camX, double camY, double camZ, float partialTick, PoseStack poseStack, MultiBufferSource.BufferSource buffer, EntityRenderDispatcher dispatcher) {
        double x = Mth.m_14139_((double)partialTick, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTick, (double)entity.f_19791_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)partialTick, (double)entity.f_19792_, (double)entity.m_20189_());
        float f = Mth.m_14179_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
        RenderListener.render(entity, x - camX, y - camY, z - camZ, f, partialTick, poseStack, buffer, dispatcher);
    }

    private static <E extends Entity> void render(E entity, double x, double y, double z, float rotationYaw, float partialTicks, PoseStack poseStack, MultiBufferSource.BufferSource buffer, EntityRenderDispatcher dispatcher) {
        EntityRenderer entityrenderer = dispatcher.m_114382_(entity);
        if (entityrenderer instanceof IPostRenderer) {
            IPostRenderer post = (IPostRenderer)entityrenderer;
            Vec3 vec3 = entityrenderer.m_7860_(entity, partialTicks);
            double d2 = x + vec3.m_7096_();
            double d3 = y + vec3.m_7098_();
            double d0 = z + vec3.m_7094_();
            poseStack.m_85836_();
            poseStack.m_85837_(d2, d3, d0);
            if (!post.actuallyRender(entity, rotationYaw, partialTicks, poseStack, (MultiBufferSource)buffer, dispatcher.m_114394_(entity, partialTicks))) {
                Redux.LOGGER.debug("Did not render entity: {}", entity);
            } else {
                buffer.m_109911_();
            }
            poseStack.m_85849_();
        }
    }
}

