/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.block.redstone;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import net.zepalesque.redux.block.util.state.ReduxStates;
import net.zepalesque.redux.block.util.state.enums.LogicatorMode;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.util.block.StateUtil;

public class LogicatorBlock
extends DiodeBlock {
    public static final EnumProperty<LogicatorMode> MODE = ReduxStates.MODE_LOGICATOR;
    public static final BooleanProperty LEFT = ReduxStates.LEFT_INPUT;
    public static final BooleanProperty RIGHT = ReduxStates.RIGHT_INPUT;

    public LogicatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState b = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_52496_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_(MODE, (Comparable)((Object)LogicatorMode.AND));
        this.m_49959_(b);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        float f = ((LogicatorMode)((Object)(state = StateUtil.mapValue(state, MODE, LogicatorMode::flipOperationType)).m_61143_(MODE))).isOr() ? 0.55f : 0.5f;
        level.m_5594_(player, pos, (SoundEvent)ReduxSoundEvents.LOGICATOR_CLICK.get(), SoundSource.BLOCKS, 0.3f, f);
        level.m_7731_(pos, state, 2);
        this.refreshOutputState(level, state, pos);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected static int getLeftInput(SignalGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        Direction left = direction.m_122427_();
        return level.m_277185_(pos.m_121945_(left), left);
    }

    protected static int getRightInput(SignalGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        Direction right = direction.m_122428_();
        return level.m_277185_(pos.m_121945_(right), right);
    }

    protected static int getBackInput(SignalGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return level.m_277185_(pos.m_121945_(direction), direction);
    }

    protected boolean shouldHaveLeftInput(SignalGetter level, BlockPos pos, BlockState state) {
        return LogicatorBlock.getLeftInput(level, pos, state) > 0;
    }

    protected boolean shouldHaveRightInput(SignalGetter level, BlockPos pos, BlockState state) {
        return LogicatorBlock.getRightInput(level, pos, state) > 0;
    }

    protected boolean shouldBeExclusive(SignalGetter level, BlockPos pos, BlockState state) {
        return LogicatorBlock.getBackInput(level, pos, state) > 0;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.shouldUpdateOnPlacement(level, pos, state)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    protected boolean m_7320_(Level level, BlockPos pos, BlockState state) {
        LogicatorMode mode = (LogicatorMode)((Object)state.m_61143_(MODE));
        boolean l = this.shouldHaveLeftInput((SignalGetter)level, pos, state);
        boolean r = this.shouldHaveRightInput((SignalGetter)level, pos, state);
        return mode.operate(l, r);
    }

    protected boolean shouldUpdateOnPlacement(Level level, BlockPos pos, BlockState state) {
        LogicatorMode mode = (LogicatorMode)((Object)state.m_61143_(MODE));
        boolean exclusive = this.shouldBeExclusive((SignalGetter)level, pos, state);
        LogicatorMode correct = mode.withExclusivity(exclusive);
        boolean l = this.shouldHaveLeftInput((SignalGetter)level, pos, state);
        boolean r = this.shouldHaveRightInput((SignalGetter)level, pos, state);
        return correct != mode || l || r || correct.operate(false, false);
    }

    protected void refreshOutputState(Level level, BlockState state, BlockPos pos) {
        if (!this.m_7346_((LevelReader)level, pos, state)) {
            BlockState oldState = state;
            boolean l = this.shouldHaveLeftInput((SignalGetter)level, pos, state);
            boolean r = this.shouldHaveRightInput((SignalGetter)level, pos, state);
            boolean exclusive = this.shouldBeExclusive((SignalGetter)level, pos, state);
            boolean or = ((LogicatorMode)((Object)state.m_61143_(MODE))).isOr();
            boolean powered = this.m_7320_(level, pos, state);
            if ((state = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(MODE, (Comparable)((Object)LogicatorMode.getMode(exclusive, or)))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(l))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(r))).m_61124_((Property)f_52496_, (Comparable)Boolean.valueOf(powered))) != oldState) {
                level.m_7731_(pos, state, 2);
                level.m_186464_(pos, (Block)this, this.m_6112_(state), TickPriority.VERY_HIGH);
                this.m_52580_(level, pos, state);
            }
        }
    }

    protected void m_7321_(Level level, BlockPos pos, BlockState state) {
        if (!this.m_7346_((LevelReader)level, pos, state)) {
            boolean wasOn = (Boolean)state.m_61143_((Property)f_52496_);
            boolean shouldTurnOn = this.m_7320_(level, pos, state);
            boolean hadInputL = (Boolean)state.m_61143_((Property)LEFT);
            boolean shouldHaveInputL = this.shouldHaveLeftInput((SignalGetter)level, pos, state);
            boolean hadInputR = (Boolean)state.m_61143_((Property)RIGHT);
            boolean shouldHaveInputR = this.shouldHaveRightInput((SignalGetter)level, pos, state);
            boolean wasExclusive = ((LogicatorMode)((Object)state.m_61143_(MODE))).isExclusive();
            boolean shouldBeExclusive = this.shouldBeExclusive((SignalGetter)level, pos, state);
            if (!(wasOn == shouldTurnOn && hadInputL == shouldHaveInputL && hadInputR == shouldHaveInputR && wasExclusive == shouldBeExclusive || level.m_183326_().m_183588_(pos, (Object)this))) {
                TickPriority tickpriority = TickPriority.HIGH;
                if (this.m_52573_((BlockGetter)level, pos, state)) {
                    tickpriority = TickPriority.EXTREMELY_HIGH;
                } else if (wasOn) {
                    tickpriority = TickPriority.VERY_HIGH;
                }
                level.m_186464_(pos, (Block)this, this.m_6112_(state), tickpriority);
            }
        }
    }

    public boolean getWeakChanges(BlockState state, LevelReader level, BlockPos pos) {
        return super.getWeakChanges(state, level, pos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.refreshOutputState((Level)level, state, pos);
    }

    protected int m_6112_(BlockState state) {
        return 2;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, MODE, LEFT, RIGHT, f_52496_});
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((LogicatorMode)((Object)state.m_61143_(MODE))).isOr()) {
            double d0 = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.2;
            double d1 = (double)pos.m_123342_() + 0.4 + (random.m_188500_() - 0.5) * 0.2;
            double d2 = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.2;
            if (random.m_188499_()) {
                level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }
}

