/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.block.natural;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.zepalesque.redux.mixin.common.block.ReduxWallBlockAccessor;

public class ReduxDoubleDropsWall
extends WallBlock {
    public ReduxDoubleDropsWall(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(false)));
        this.fixShapeMaps();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    private void fixShapeMaps() {
        ReduxWallBlockAccessor reduxWallBlockAccessor = (ReduxWallBlockAccessor)((Object)this);
        Map<BlockState, VoxelShape> shapeByIndex = reduxWallBlockAccessor.getShapeByIndex();
        shapeByIndex = ReduxDoubleDropsWall.fixShapeMap(shapeByIndex);
        reduxWallBlockAccessor.setShapeByIndex(shapeByIndex);
        Map<BlockState, VoxelShape> collisionShapeByIndex = reduxWallBlockAccessor.getCollisionShapeByIndex();
        collisionShapeByIndex = ReduxDoubleDropsWall.fixShapeMap(collisionShapeByIndex);
        reduxWallBlockAccessor.setCollisionShapeByIndex(collisionShapeByIndex);
    }

    private static Map<BlockState, VoxelShape> fixShapeMap(Map<BlockState, VoxelShape> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(map);
        for (BlockState state : map.keySet()) {
            builder.put((Object)((BlockState)state.m_61122_((Property)AetherBlockStateProperties.DOUBLE_DROPS)), (Object)map.get(state));
        }
        return builder.build();
    }
}

