/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.packconfig;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.packconfig.Category;
import org.jetbrains.annotations.Nullable;

public class PackConfigBootstrap {
    private static final Map<String, Category> configFiles = Maps.newHashMap();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static boolean hasStarted = false;

    public static void bootstrap() {
        if (!hasStarted) {
            if (FMLLoader.getDist() == Dist.CLIENT) {
                for (Map.Entry<String, Category> entry : configFiles.entrySet()) {
                    JsonElement read = PackConfigBootstrap.read(entry.getKey());
                    entry.getValue().read(read);
                    JsonElement written = entry.getValue().write();
                    PackConfigBootstrap.write(entry.getKey(), written);
                }
            }
            hasStarted = true;
        } else {
            Redux.LOGGER.warn("Already started PackConfig bootstrap, but method was called again! Ignoring...");
        }
    }

    @Nullable
    public static <T> T register(String id, Function<Category, T> constructor) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            Category base = new Category(id, null);
            T finalized = constructor.apply(base);
            configFiles.put(id, base);
            return finalized;
        }
        return null;
    }

    public static JsonElement read(String filename) {
        Path config;
        Path path = Minecraft.m_91087_().f_91069_.toPath().resolve(Paths.get("config", new String[0]));
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!Files.exists(config = path.resolve(Paths.get(filename + ".json", new String[0])), new LinkOption[0])) {
            Redux.LOGGER.info("Found no pack settings config, Creating...");
            try {
                Files.createFile(config, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new JsonObject();
        }
        try {
            String s = Files.readString(config);
            return (JsonElement)gson.fromJson(s, JsonElement.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(String id, JsonElement json) {
        Path config;
        Path path = Minecraft.m_91087_().f_91069_.toPath().resolve(Paths.get("config", new String[0]));
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!Files.exists(config = path.resolve(Paths.get(id + ".json", new String[0])), new LinkOption[0])) {
            Redux.LOGGER.info("Found no pack settings config, Creating...");
            try {
                Files.createFile(config, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Files.write(config, List.of(gson.toJson(json)), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

