/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.dispenser.DispenseUsableItemBehavior;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether_genesis.entity.GenesisEntityTypes;
import com.aetherteam.aether_genesis.item.GenesisItems;
import com.aetherteam.cumulus.CumulusConfig;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.builderdog.ancient_aether.entity.AncientAetherEntityTypes;
import net.minecraft.SharedConstants;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.resource.PathPackResources;
import net.zepalesque.redux.advancement.ReduxAdvancementSounds;
import net.zepalesque.redux.advancement.trigger.ReduxAdvancementTriggers;
import net.zepalesque.redux.api.blockhandler.WoodHandler;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.api.condition.ConditionSerializers;
import net.zepalesque.redux.api.packconfig.PackConfigBootstrap;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.block.util.ReduxSoundTypes;
import net.zepalesque.redux.block.util.dispenser.ShellShinglesDispenserBehavior;
import net.zepalesque.redux.blockentity.ReduxBlockEntityTypes;
import net.zepalesque.redux.blockhandlers.WoodHandlers;
import net.zepalesque.redux.builtin.BuiltinPackUtils;
import net.zepalesque.redux.client.ReduxClient;
import net.zepalesque.redux.client.ReduxColors;
import net.zepalesque.redux.client.ReduxMenus;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import net.zepalesque.redux.client.render.ReduxRenderers;
import net.zepalesque.redux.client.render.entity.BlightbunnyRenderer;
import net.zepalesque.redux.client.render.geo.MykapodRenderer;
import net.zepalesque.redux.client.resource.ReduxOverridesPackResources;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.AACompatType;
import net.zepalesque.redux.config.pack.ReduxPackConfig;
import net.zepalesque.redux.data.ReduxAdvancementData;
import net.zepalesque.redux.data.ReduxBlockstateData;
import net.zepalesque.redux.data.ReduxItemModelData;
import net.zepalesque.redux.data.ReduxLanguageData;
import net.zepalesque.redux.data.ReduxLootModifierData;
import net.zepalesque.redux.data.ReduxRecipeData;
import net.zepalesque.redux.data.ReduxRegistrySets;
import net.zepalesque.redux.data.ReduxSoundData;
import net.zepalesque.redux.data.loot.ReduxLootData;
import net.zepalesque.redux.data.tags.ReduxAdvancementOverrideTagData;
import net.zepalesque.redux.data.tags.ReduxBiomeTagsData;
import net.zepalesque.redux.data.tags.ReduxBlockTagsData;
import net.zepalesque.redux.data.tags.ReduxDamageTypeTagData;
import net.zepalesque.redux.data.tags.ReduxEntityTypeTagData;
import net.zepalesque.redux.data.tags.ReduxItemTagsData;
import net.zepalesque.redux.data.tags.ReduxSoundEventTagData;
import net.zepalesque.redux.effect.ReduxEffects;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import net.zepalesque.redux.entity.dataserializer.ReduxDataSerializers;
import net.zepalesque.redux.event.hook.SwetHooks;
import net.zepalesque.redux.event.listener.MobSoundListener;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.loot.condition.ReduxLootConditions;
import net.zepalesque.redux.loot.functions.ReduxLootFunctions;
import net.zepalesque.redux.loot.modifiers.ReduxLootModifiers;
import net.zepalesque.redux.misc.ReduxPackSources;
import net.zepalesque.redux.misc.ReduxPotions;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.recipe.ReduxRecipeTypes;
import net.zepalesque.redux.recipe.condition.DataRecipeCondition;
import net.zepalesque.redux.recipe.serializer.ReduxRecipeSerializers;
import net.zepalesque.redux.world.biome.ReduxRegion;
import net.zepalesque.redux.world.biome.modifier.ReduxBiomeModifierCodecs;
import net.zepalesque.redux.world.biome.surfacerule.ReduxConditionSources;
import net.zepalesque.redux.world.carver.ReduxCarvers;
import net.zepalesque.redux.world.density.ReduxDensityFunctionTypes;
import net.zepalesque.redux.world.feature.ReduxFeatures;
import net.zepalesque.redux.world.placement.ReduxPlacementModifiers;
import net.zepalesque.redux.world.stateprov.ReduxStateProviders;
import net.zepalesque.redux.world.structure.ReduxStructureTypes;
import net.zepalesque.redux.world.tree.decorator.ReduxTreeDecorators;
import net.zepalesque.redux.world.tree.foliage.ReduxFoliagePlacers;
import net.zepalesque.redux.world.tree.root.ReduxRootPlacers;
import net.zepalesque.redux.world.tree.trunk.ReduxTrunkPlacers;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import teamrazor.aeroblender.AeroBlenderConfig;
import terrablender.api.Region;
import terrablender.api.Regions;

@Mod(value="aether_redux")
public class Redux {
    public static final String MODID = "aether_redux";
    public static final String DISPLAY = ((IModInfo)ModList.get().getModFileById("aether_redux").getMods().get(0)).getDisplayName();
    public static final String DISPLAY_LOWERCASE_THE = DISPLAY.replace("The", "the");
    public static final String VERSION_ID = ModList.get().getModFileById("aether_redux").versionString();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final int REDUX_PURPLE = 9667828;
    public static final RandomSource RAND = RandomSource.m_216327_();
    public static final Collection<WoodHandler> WOOD_HANDLERS = new ArrayList<WoodHandler>();
    @Nullable
    public static ReduxPackConfig packConfig;

    public Redux() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventPriority.LOW, this::commonSetup);
        bus.addListener(this::clientSetup);
        DistExecutor.unsafeRunForDist(() -> () -> {
            bus.addListener(EventPriority.LOWEST, ReduxColors::blockColors);
            bus.addListener(ReduxColors::itemColors);
            bus.addListener(ReduxColors::resolvers);
            ReduxMenus.MENUS.register(bus);
            ReduxClient.registerMolangQueries();
            return true;
        }, () -> () -> false);
        bus.addListener(EventPriority.HIGH, this::packSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::registerRecipeSerializers);
        packConfig = PackConfigBootstrap.register("aether_redux_pack_config", ReduxPackConfig::new);
        ReduxBlocks.BLOCKS.register(bus);
        ReduxItems.ITEMS.register(bus);
        ReduxSoundEvents.SOUNDS.register(bus);
        ReduxBlockEntityTypes.BLOCK_ENTITY_TYPES.register(bus);
        ReduxEntityTypes.ENTITY_TYPES.register(bus);
        ConditionSerializers.CODECS.register(bus);
        ReduxBiomeModifierCodecs.CODECS.register(bus);
        ReduxLootModifiers.LOOT_MODIFIERS.register(bus);
        ReduxEffects.EFFECTS.register(bus);
        ReduxRecipeTypes.RECIPE_TYPES.register(bus);
        ReduxRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        ReduxCarvers.CARVERS.register(bus);
        ReduxParticleTypes.PARTICLES.register(bus);
        ReduxFoliagePlacers.FOLIAGE_PLACERS.register(bus);
        ReduxFeatures.FEATURES.register(bus);
        ReduxDensityFunctionTypes.DENSITY_FUNCTIONS.register(bus);
        ReduxTreeDecorators.TREE_DECORATORS.register(bus);
        ReduxTrunkPlacers.TRUNK_PLACERS.register(bus);
        ReduxRootPlacers.ROOT_PLACERS.register(bus);
        ReduxLootConditions.LOOT_CONDITION_TYPES.register(bus);
        ReduxStructureTypes.STRUCTURE_TYPES.register(bus);
        ReduxConditionSources.CONDITIONS.register(bus);
        ReduxStateProviders.PROVIDERS.register(bus);
        ReduxDataSerializers.SERIALIZERS.register(bus);
        ReduxPotions.POTIONS.register(bus);
        ReduxAdvancementSounds.SOUNDS.register(bus);
        ReduxBlocks.registerPots();
        ReduxLootFunctions.LOOT_FUNCTION_TYPES.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(MobSoundListener.class);
        WoodHandlers.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ReduxConfig.COMMON_SPEC, "aether_redux_common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ReduxConfig.CLIENT_SPEC, "aether_redux_client.toml");
    }

    private void replaceBlockSounds() {
        Blocks.f_50141_.f_60446_ = ReduxSoundTypes.GLOWSTONE;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ReduxAdvancementTriggers.init();
        DistExecutor.unsafeRunForDist(() -> () -> {
            ReduxBlocks.registerWoodTypes(true);
            return true;
        }, () -> () -> {
            ReduxBlocks.registerWoodTypes(false);
            return true;
        });
        ReduxPlacementModifiers.init();
        ReduxPacketHandler.register();
        event.enqueueWork(() -> {
            if (((Boolean)ReduxConfig.COMMON.first_startup_aeroblender_setup.get()).booleanValue()) {
                AeroBlenderConfig.COMMON.vanillaAetherRegionWeight.set((Object)0);
                AeroBlenderConfig.COMMON.vanillaAetherRegionWeight.save();
            }
            ReduxBlocks.registerFlammability();
            this.registerDispenserBehaviors();
            this.replaceBlockSounds();
            this.registerComposting();
            Regions.register((Region)new ReduxRegion(new ResourceLocation(MODID, "aether_redux_region"), (Integer)ReduxConfig.COMMON.region_size.get()));
            if (((Boolean)ReduxConfig.COMMON.smaller_mimic_hitbox.get()).booleanValue()) {
                ((EntityType)AetherEntityTypes.MIMIC.get()).m_20680_().f_20378_ = 1.25f;
                if (Redux.aetherGenesisCompat()) {
                    ((EntityType)GenesisEntityTypes.SKYROOT_MIMIC.get()).m_20680_().f_20378_ = 1.25f;
                }
            }
            PotionBrewing.m_43513_((Potion)Potions.f_43584_, (Item)((Item)ReduxItems.BLIGHTED_SPORES.get()), (Potion)((Potion)ReduxPotions.INTOXICATION.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43586_, (Item)((Item)ReduxItems.BLIGHTED_SPORES.get()), (Potion)((Potion)ReduxPotions.INTOXICATION.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43585_, (Item)((Item)ReduxItems.BLIGHTED_SPORES.get()), (Potion)((Potion)ReduxPotions.LONG_INTOXICATION.get()));
            PotionBrewing.m_43513_((Potion)((Potion)ReduxPotions.INTOXICATION.get()), (Item)Items.f_42451_, (Potion)((Potion)ReduxPotions.LONG_INTOXICATION.get()));
            SwetHooks.registerParticle((EntityType)AetherEntityTypes.BLUE_SWET.get(), (Item)AetherItems.SWET_BALL.get());
            SwetHooks.registerParticle((EntityType)ReduxEntityTypes.VANILLA_SWET.get(), (Item)ReduxItems.VANILLA_SWET_BALL.get());
            if (Redux.aetherGenesisCompat()) {
                SwetHooks.registerParticle((EntityType)GenesisEntityTypes.DARK_SWET.get(), (Item)GenesisItems.DARK_SWET_BALL.get());
                SwetHooks.registerParticle((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), (Item)GenesisItems.GOLDEN_SWET_BALL.get());
            } else {
                SwetHooks.registerParticle((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), (Item)ReduxItems.GOLDEN_SWET_BALL.get());
            }
            if (Redux.ancientAetherCompat()) {
                SwetHooks.registerParticle((EntityType)AncientAetherEntityTypes.FESTIVE_SWET.get(), (Item)AetherItems.SWET_BALL.get());
            }
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)ReduxEntityTypes.MYKAPOD.get()), MykapodRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ReduxEntityTypes.BLIGHTBUNNY.get()), BlightbunnyRenderer::new);
        ReduxRenderers.registerCuriosRenderers();
        event.enqueueWork(() -> {
            if (((Boolean)ReduxConfig.CLIENT.first_startup_lightmap_changes.get()).booleanValue()) {
                AetherConfig.CLIENT.colder_lightmap.set((Object)true);
                AetherConfig.CLIENT.colder_lightmap.save();
                ReduxConfig.CLIENT.first_startup_lightmap_changes.set((Object)false);
                ReduxConfig.CLIENT.first_startup_lightmap_changes.save();
            }
            if (((Boolean)ReduxConfig.CLIENT.first_startup_menu_setup.get()).booleanValue() && ((Boolean)CumulusConfig.CLIENT.enable_menu_api.get()).booleanValue()) {
                CumulusConfig.CLIENT.active_menu.set((Object)ReduxMenus.REDUX_MENU.getId().toString());
                CumulusConfig.CLIENT.active_menu.save();
                CumulusConfig.CLIENT.enable_menu_list_button.set((Object)true);
                CumulusConfig.CLIENT.active_menu.save();
                AetherConfig.CLIENT.enable_aether_menu_button.set((Object)false);
                AetherConfig.CLIENT.enable_aether_menu_button.save();
                AetherConfig.CLIENT.should_disable_cumulus_button.set((Object)false);
                AetherConfig.CLIENT.should_disable_cumulus_button.save();
                ReduxConfig.CLIENT.first_startup_menu_setup.set((Object)false);
                ReduxConfig.CLIENT.first_startup_menu_setup.save();
            }
            ReduxMenus.cycle();
            ReduxClient.registerItemModelProperties();
            this.versionRefresh();
        });
    }

    public void versionRefresh() {
        if (!((String)ReduxConfig.CLIENT.version_id.get()).equals(VERSION_ID)) {
            ReduxConfig.CLIENT.version_id.set((Object)VERSION_ID);
        }
    }

    private void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxItems.BLIGHTED_SPORES.get()), (DispenseItemBehavior)new DispenseUsableItemBehavior((RecipeType)ReduxRecipeTypes.SPORE_BLIGHTING.get()));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxBlocks.SHELL_SHINGLES.get()), (DispenseItemBehavior)new ShellShinglesDispenserBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxBlocks.SHELL_SHINGLE_STAIRS.get()), (DispenseItemBehavior)new ShellShinglesDispenserBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxBlocks.SHELL_SHINGLE_SLAB.get()), (DispenseItemBehavior)new ShellShinglesDispenserBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxBlocks.SHELL_SHINGLE_WALL.get()), (DispenseItemBehavior)new ShellShinglesDispenserBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxBlocks.ENCHANTED_SHELL_SHINGLES.get()), (DispenseItemBehavior)new ShellShinglesDispenserBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxBlocks.ENCHANTED_SHELL_SHINGLE_STAIRS.get()), (DispenseItemBehavior)new ShellShinglesDispenserBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxBlocks.ENCHANTED_SHELL_SHINGLE_SLAB.get()), (DispenseItemBehavior)new ShellShinglesDispenserBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ReduxBlocks.ENCHANTED_SHELL_SHINGLE_WALL.get()), (DispenseItemBehavior)new ShellShinglesDispenserBehavior());
    }

    public void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals(ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((IConditionSerializer)DataRecipeCondition.Serializer.INSTANCE);
        }
    }

    private void registerComposting() {
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxItems.WYND_OATS);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.WYNDSPROUTS);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.SKYSPROUTS);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.LUXWEED);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxItems.WYND_OAT_PANICLE);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.GILDED_OAK_LEAVES);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.GILDED_LEAF_PILE);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.GOLDEN_LEAF_PILE);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTWILLOW_LEAF_PILE);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTED_SKYROOT_LEAVES);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTWILLOW_LEAVES);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTWILLOW_LEAF_PILE);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.FIELDSPROOT_LEAVES);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.GLACIA_LEAVES);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.PURPLE_GLACIA_LEAVES);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.FIELDSPROOT_PETALS);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.AVELIUM_ROOTS);
        this.addCompost(0.5f, (Supplier<? extends ItemLike>)ReduxBlocks.AVELIUM_SPROUTS);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.JELLYSHROOM);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.SHIMMERSTOOL);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.IRIDIA);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.SPIROLYCTIL);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.GOLDEN_CLOVER);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.AURUM);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.ZYATRIX);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.DAGGERBLOOM);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.THERATIP);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTSHADE);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.CLOUDCAP_MUSHLING);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.LUMINA);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.ZANBERRY_BUSH_STEM);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.ZANBERRY_BUSH);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.SPLITFERN);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.INFERNIA);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.XAELIA_PATCH);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxBlocks.CLOUD_CAP_BLOCK);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxBlocks.JELLYSHROOM);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.CLOUDCAP_SPORES);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)WoodHandlers.CLOUDCAP.log);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)WoodHandlers.JELLYSHROOM.log);
        this.addCompost(0.5f, (Supplier<? extends ItemLike>)ReduxBlocks.LIGHTROOTS);
        this.addCompost(0.5f, (Supplier<? extends ItemLike>)ReduxBlocks.CORRUPTED_VINES);
        this.addCompost(0.5f, (Supplier<? extends ItemLike>)ReduxBlocks.GILDED_VINES);
        this.addCompost(0.5f, (Supplier<? extends ItemLike>)ReduxBlocks.GOLDEN_VINES);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTMOSS_BLOCK);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTMOSS_CARPET);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.SHORT_AETHER_GRASS);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTWILLOW_SAPLING);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.CRYSTAL_SAPLING);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.CRYSTAL_FRUIT_SAPLING);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.PURPLE_CRYSTAL_FRUIT_SAPLING);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.FIELDSPROOT_SAPLING);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.GLACIA_SAPLING);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.PURPLE_GLACIA_SAPLING);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.GILDED_OAK_SAPLING);
        this.addCompost(0.3f, (Supplier<? extends ItemLike>)ReduxBlocks.BLIGHTED_SKYROOT_SAPLING);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxBlocks.FLAREBLOSSOM);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxBlocks.FUNGAL_GROWTH);
        this.addCompost(0.5f, (Supplier<? extends ItemLike>)ReduxBlocks.FUNGAL_CARPET);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxItems.WYND_BAGEL);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxItems.BLUEBERRY_BAGEL);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxItems.ZANBERRY);
        this.addCompost(1.0f, (Supplier<? extends ItemLike>)ReduxItems.BLUEBERRY_PIE);
        this.addCompost(1.0f, (Supplier<? extends ItemLike>)ReduxItems.ENCHANTED_BLUEBERRY_PIE);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxItems.BLUE_SWET_JELLY);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxItems.GOLDEN_SWET_JELLY);
        this.addCompost(0.85f, (Supplier<? extends ItemLike>)ReduxItems.VANILLA_SWET_JELLY);
        this.addCompost(0.65f, (Supplier<? extends ItemLike>)ReduxItems.OATMEAL);
    }

    private void addCompost(float chance, Supplier<? extends ItemLike> item) {
        ComposterBlock.f_51914_.put((Object)item.get().m_5456_(), chance);
    }

    public void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxRegistrySets(packOutput, lookupProvider, ReduxRegistrySets.BUILDER, MODID, new String[0]));
        generator.addProvider(event.includeClient(), (DataProvider)new ReduxBlockstateData(packOutput, MODID, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ReduxItemModelData(packOutput, MODID, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ReduxLanguageData(packOutput, MODID));
        generator.addProvider(event.includeClient(), (DataProvider)new ReduxSoundData(packOutput, MODID, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxRecipeData(packOutput, MODID));
        generator.addProvider(event.includeServer(), (DataProvider)ReduxLootData.loot(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxDamageTypeTagData(packOutput, lookupProvider, MODID, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxSoundEventTagData(packOutput, lookupProvider, MODID, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxAdvancementOverrideTagData(packOutput, lookupProvider, MODID, fileHelper));
        ReduxBlockTagsData block = new ReduxBlockTagsData(packOutput, lookupProvider, MODID, fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)block);
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxItemTagsData(packOutput, lookupProvider, MODID, block.m_274426_(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxBiomeTagsData(packOutput, lookupProvider, MODID, ReduxRegistrySets::patchLookup, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxEntityTypeTagData(packOutput, lookupProvider, MODID, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxAdvancementData(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ReduxLootModifierData(packOutput, MODID));
        PackMetadataGenerator packMeta = new PackMetadataGenerator(packOutput);
        Map<PackType, Integer> packTypes = Map.of(PackType.SERVER_DATA, SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
        packMeta.m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Aether: Redux data/resources"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES), packTypes));
        generator.addProvider(true, (DataProvider)packMeta);
        Path builtinData = packOutput.m_245114_().resolve("packs").resolve("data");
        DataGenerator dataGenerator = generator;
        Objects.requireNonNull(dataGenerator);
        DataGenerator.PackGenerator noisePack = new DataGenerator.PackGenerator(dataGenerator, event.includeServer(), "reduxnoise", new PackOutput(builtinData.resolve("redux_noise")));
        noisePack.m_253108_(output -> new ReduxRegistrySets.NoisePack(output, lookupProvider, MODID, new String[0]));
    }

    public void packSetup(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            PackConfigBootstrap.bootstrap();
            this.overridesPack(event);
            if (ModList.get().isLoaded("tipsmod")) {
                this.setupMandatoryPack(event, "resource/redux_tips", "Tips Mod Compat", "Tips for the Aether: Redux");
            }
        } else if (event.getPackType() == PackType.SERVER_DATA) {
            if (Redux.aetherGenesisCompat()) {
                this.setupMandatoryDataPack(event, "data/genesis_data", "Genesis Compat", "Compatibility with the Aether: Genesis");
            }
            if (Redux.lostAetherCompat()) {
                this.setupMandatoryDataPack(event, "data/lost_content_data", "Lost Content Compat", "Compatibility with the Aether: Lost Content");
            }
            if (Redux.deepAetherCompat()) {
                this.setupMandatoryDataPack(event, "data/deep_aether_data", "Deep Aether Compat", "Compatibility with Deep Aether");
            }
            if (Redux.ancientAetherCompat()) {
                this.setupMandatoryDataPack(event, "data/ancient_aether_data", "Ancient Aether Compat", "Compatibility with Ancient Aether");
            }
            String desc = "See config/aether_redux_common.toml";
            if (((Boolean)ReduxConfig.COMMON.cloud_layer_gen.get()).booleanValue()) {
                this.setupBuiltinDatapack(event, "data/cloudbed", "Redux - Cloudbed", desc);
            }
            if (((Boolean)ReduxConfig.COMMON.bronze_dungeon_upgrade.get()).booleanValue()) {
                this.setupMandatoryDataPack(event, "data/dungeon_upgrades/bronze", "Bronze Dungeon Upgrade", desc);
            }
            if (((Boolean)ReduxConfig.COMMON.gravitite_ingot.get()).booleanValue()) {
                this.setupMandatoryDataPack(event, "data/gravitite_ingot", "Redux - Gravitite Ingot", desc);
            }
            if (((Boolean)ReduxConfig.COMMON.dungeon_stone_recipes.get()).booleanValue()) {
                this.setupMandatoryDataPack(event, "data/dungeon_stone_recipes", "Redux - Light Dungeon Stone Recipes", desc);
            }
            if (((AACompatType)ReduxConfig.COMMON.redux_noise.get()).get().booleanValue()) {
                this.setupMandatoryDataPack(event, "data/redux_noise", "Redux - New Island Noise", desc);
            }
        }
    }

    public void overridesPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES && packConfig != null) {
            String id = "resource/overrides_pack";
            String title = "pack.aether_redux.overrides.title";
            MutableComponent desc = Component.m_237115_((String)"pack.aether_redux.overrides.description");
            ReduxOverridesPackResources combined = ReduxPackConfig.generate(id, title, (Component)desc);
            BuiltinPackUtils.mandatory(event, combined, id, title, (Component)desc);
        }
    }

    private void setupMandatoryPack(AddPackFindersEvent event, String path, String displayName, String desc) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/" + path});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)desc), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
            event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)("builtin/" + path), (Component)Component.m_237113_((String)("Redux - " + displayName)), (boolean)true, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupOptionalPack(AddPackFindersEvent event, String path, String displayName, String desc) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/" + path});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)desc), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
            event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)("builtin/" + path), (Component)Component.m_237113_((String)("Redux - " + displayName)), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupMandatoryDataPack(AddPackFindersEvent event, String path, String displayName, String desc) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/" + path});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)desc), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)("builtin/" + path), (Component)Component.m_237113_((String)("Redux - " + displayName)), (boolean)true, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }

    private void setupBuiltinDatapack(AddPackFindersEvent event, String path, String displayName, String desc) {
        this.setupDatapack(event, path, displayName, desc, PackSource.f_10528_);
    }

    private void setupFeatureDatapack(AddPackFindersEvent event, String path, String displayName, String desc) {
        this.setupDatapack(event, path, displayName, desc, PackSource.f_244201_);
    }

    private void setupOptionalDatapack(AddPackFindersEvent event, String path, String displayName, String desc) {
        this.setupDatapack(event, path, displayName, desc, ReduxPackSources.OPTIONAL_DATAPACK);
    }

    private void setupDatapack(AddPackFindersEvent event, String path, String displayName, String desc, PackSource source) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/" + path});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)desc), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)("builtin/" + path), (Component)Component.m_237113_((String)("Redux - " + displayName)), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), pack.isHidden()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)source)));
        }
    }

    private void setupDatapackFeatureFlags(AddPackFindersEvent event, String path, String displayName, String desc, PackSource source, FeatureFlag flag, FeatureFlag ... otherFlags) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/" + path});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237115_((String)desc), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)("builtin/" + path), (Component)Component.m_237113_((String)("Redux - " + displayName)), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_245702_((FeatureFlag)flag, (FeatureFlag[])otherFlags), pack.isHidden()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)source)));
        }
    }

    public static ResourceLocation locate(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static boolean deepAetherCompat() {
        return ModList.get().isLoaded("deep_aether");
    }

    public static boolean lostAetherCompat() {
        return ModList.get().isLoaded("lost_aether_content");
    }

    public static boolean aetherGenesisCompat() {
        return ModList.get().isLoaded("aether_genesis");
    }

    public static boolean ancientAetherCompat() {
        return ModList.get().isLoaded("ancient_aether");
    }

    public static boolean galosphereCompat() {
        return ModList.get().isLoaded("galosphere");
    }

    public static boolean protectCompat() {
        return ModList.get().isLoaded("aether_protect_your_moa");
    }

    public static class Keys {
        public static final ResourceKey<Registry<Codec<? extends AbstractCondition<?>>>> CONDITION_SERIALIZER = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("aether_redux", "condition_serializer"));
    }
}

