/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.blockswap.swapper;

import com.mojang.serialization.Codec;
import corgitaco.blockswap.config.BlockSwapConfig;
import corgitaco.blockswap.mixin.access.StateHolderAccess;
import corgitaco.blockswap.util.CodecUtil;
import corgitaco.blockswap.util.CommentedCodec;
import corgitaco.blockswap.util.TickHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class Swapper {
    public static final Codec<BlockState> COMMENTED_STATE_CODEC = Swapper.codec(CodecUtil.BLOCK_CODEC, Block::m_49966_);
    public static final Codec<FluidState> COMMENTED_FLUID_CODEC = Swapper.codec(CodecUtil.FLUID_CODEC, Fluid::m_76145_);
    public static Reference2ReferenceOpenHashMap<Block, Int2ObjectOpenHashMap<Property<?>>> cache = new Reference2ReferenceOpenHashMap();

    protected static <O, S extends StateHolder<O, S>> Codec<S> codec(Codec<O> object, Function<O, S> defaultVal) {
        return object.dispatch("Name", stateHolder -> ((StateHolderAccess)stateHolder).blockSwap_GetOwner(), o -> {
            StateHolder stateProperty = (StateHolder)defaultVal.apply(o);
            return stateProperty.m_61148_().isEmpty() ? Codec.unit((Object)stateProperty) : CommentedCodec.optionalOf(((StateHolderAccess)stateProperty).blockSwap_getPropertiesCodec().codec(), "Properties", "Properties define the state of this block/fluid.", stateProperty).codec();
        });
    }

    public static BlockState remapState(BlockState incomingState) {
        BlockState newState;
        BlockSwapConfig config = BlockSwapConfig.getConfig(false);
        if (config.blockStateBlockStateMap().containsKey(incomingState)) {
            return config.blockStateBlockStateMap().get(incomingState);
        }
        BlockState finalNewState = newState = config.blockBlockMap().get(incomingState.m_60734_()).m_49966_();
        Int2ObjectOpenHashMap newStateProperties = (Int2ObjectOpenHashMap)cache.computeIfAbsent((Object)newState.m_60734_(), block1 -> (Int2ObjectOpenHashMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), set -> {
            for (Property property : finalNewState.m_61147_()) {
                set.put(property.m_6310_(), (Object)property);
            }
        }));
        for (Property property : incomingState.m_61147_()) {
            Property newProperty = (Property)newStateProperties.get(property.m_6310_());
            if (newProperty == null) continue;
            newState = (BlockState)newState.m_61124_(newProperty, incomingState.m_61143_(newProperty));
        }
        return newState;
    }

    public static void runRetroGenerator(Level world, LevelChunkSection[] sections, LevelChunk chunk) {
        BlockSwapConfig config = BlockSwapConfig.getConfig(false);
        if (config.retroGen() && !((TickHelper)chunk).markTickDirty()) {
            for (int i = 0; i < sections.length; ++i) {
                LevelChunkSection section = sections[i];
                if (section == null) continue;
                int bottomY = SectionPos.m_123223_((int)chunk.m_151568_(i));
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            BlockPos blockPos = new BlockPos(SectionPos.m_123223_((int)chunk.m_7697_().f_45578_) + x, bottomY + y, SectionPos.m_123223_((int)chunk.m_7697_().f_45579_) + z);
                            BlockState state = world.m_8055_(blockPos);
                            if (config.blockBlockMap().containsKey(state.m_60734_())) {
                                world.m_7731_(blockPos, Swapper.remapState(state), 2);
                            }
                            if (!config.blockStateBlockStateMap().containsKey(state)) continue;
                            world.m_7731_(blockPos, config.blockStateBlockStateMap().get(state), 2);
                        }
                    }
                }
            }
            ((TickHelper)chunk).setTickDirty();
        }
    }
}

