/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityDataRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.Nullable;

public class SpinningPeppermintEntity
extends Entity {
    private static EntityDataAccessor<Optional<Vec3>> SPIN_AROUND = SynchedEntityData.m_135353_(SpinningPeppermintEntity.class, (EntityDataSerializer)((EntityDataSerializer)ACEntityDataRegistry.OPTIONAL_VEC_3.get()));
    private static final EntityDataAccessor<Float> SPIN_RADIUS = SynchedEntityData.m_135353_(SpinningPeppermintEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPIN_SPEED = SynchedEntityData.m_135353_(SpinningPeppermintEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_ANGLE = SynchedEntityData.m_135353_(SpinningPeppermintEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> STRAIGHT = SynchedEntityData.m_135353_(SpinningPeppermintEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(SpinningPeppermintEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEEKING_ENTITY = SynchedEntityData.m_135353_(SpinningPeppermintEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public ItemStack peppermintRenderStack = new ItemStack((ItemLike)ACBlockRegistry.SMALL_PEPPERMINT.get());
    private int despawnsIn = -1;
    private int prevDespawnsIn;
    @javax.annotation.Nullable
    private LivingEntity owner;
    @javax.annotation.Nullable
    private UUID ownerUUID;
    private float startAngle;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private float spinAngle;

    public SpinningPeppermintEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public SpinningPeppermintEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.SPINNING_PEPPERMINT.get(), level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPIN_AROUND, Optional.empty());
        this.f_19804_.m_135372_(SPIN_RADIUS, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(SPIN_SPEED, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(START_ANGLE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STRAIGHT, (Object)false);
        this.f_19804_.m_135372_(LIFESPAN, (Object)200);
        this.f_19804_.m_135372_(SEEKING_ENTITY, (Object)-1);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setOwner(@javax.annotation.Nullable LivingEntity living) {
        this.owner = living;
        this.ownerUUID = living == null ? null : living.m_20148_();
    }

    @javax.annotation.Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.despawnsIn == -1) {
            this.despawnsIn = this.getLifespan();
        }
        this.prevDespawnsIn = this.despawnsIn;
        if (this.despawnsIn > 0) {
            --this.despawnsIn;
        } else if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
        this.setSpinRadius(3.0f);
        this.setSpinSpeed(7.0f);
        Vec3 encirclePos = this.getSpinAroundPosition();
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
        } else {
            this.m_20090_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
            LivingEntity owner = this.getOwner();
            if (owner instanceof Mob) {
                Mob mob = (Mob)owner;
                LivingEntity target = mob.m_5448_();
                if (target != null && encirclePos != null) {
                    Vec3 add = target.m_146892_().m_82546_(encirclePos);
                    if (add.m_82553_() > 1.0) {
                        add = add.m_82541_();
                    }
                    this.setSpinAroundPosition(encirclePos.m_82549_(add.m_82490_((double)0.05f)));
                }
            } else if (owner instanceof Player) {
                Entity seeking;
                Player player = (Player)owner;
                Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() * 0.45f), 0.0);
                Entity entity = seeking = this.getSeekingEntityId() == -1 ? null : this.m_9236_().m_6815_(this.getSeekingEntityId());
                if (seeking != null) {
                    Vec3 add = seeking.m_146892_().m_82546_(this.m_20182_());
                    if (add.m_82553_() > 1.0) {
                        add = add.m_82541_();
                    }
                    this.setSpinRadius(4.0f - 4.0f * Math.min(1.0f, (float)this.f_19797_ / 30.0f));
                    this.setSpinAroundPosition(this.m_20182_().m_82549_(add));
                } else {
                    this.setSpinAroundPosition(playerPos);
                }
            }
        }
        if (this.isStraight()) {
            if (!this.m_9236_().f_46443_) {
                Vec3 vec3 = new Vec3(0.0, 0.0, (double)(-0.01f * this.getSpinSpeed())).m_82524_((float)(-Math.toRadians(this.m_146908_())));
                this.m_20256_(this.m_20184_().m_82549_(vec3));
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82490_((double)0.9f).m_82520_(0.0, -0.08, 0.0));
                }
                if (this.f_19863_) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.9f, 0.0).m_82542_(0.4, 1.0, 0.4));
                }
                this.m_6478_(MoverType.SELF, this.m_20184_());
            }
        } else if (encirclePos == null) {
            this.setSpinAroundPosition(this.m_20182_());
        } else if (!this.m_9236_().f_46443_) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            float f = Math.min(1.0f, (float)this.f_19797_ / 30.0f);
            Vec3 angle = new Vec3(0.0, 0.0, (double)(f * this.getSpinRadius())).m_82524_((float)(-Math.toRadians(this.getStartAngle() + this.spinAngle)));
            Vec3 encircle = encirclePos.m_82549_(angle);
            Vec3 newDelta = encircle.m_82546_(this.m_20182_());
            this.m_20256_(newDelta.m_82490_(0.05 * (double)this.getSpinSpeed()));
            this.spinAngle += this.getSpinSpeed();
        }
        this.hurtEntities();
    }

    public void setDespawnsIn(int i) {
        this.despawnsIn = i;
    }

    public float getDespawnTime(float partialTicks) {
        return (float)this.prevDespawnsIn + (float)(this.despawnsIn - this.prevDespawnsIn) * partialTicks;
    }

    @Nullable
    public Vec3 getSpinAroundPosition() {
        return ((Optional)this.f_19804_.m_135370_(SPIN_AROUND)).orElse(null);
    }

    public void setSpinAroundPosition(@Nullable Vec3 vec3) {
        this.f_19804_.m_135381_(SPIN_AROUND, Optional.ofNullable(vec3));
    }

    public float getSpinSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPIN_SPEED)).floatValue();
    }

    public void setSpinSpeed(float spinSpeed) {
        this.f_19804_.m_135381_(SPIN_SPEED, (Object)Float.valueOf(spinSpeed));
    }

    public float getSpinRadius() {
        return ((Float)this.f_19804_.m_135370_(SPIN_RADIUS)).floatValue();
    }

    public void setSpinRadius(float spinRadius) {
        this.f_19804_.m_135381_(SPIN_RADIUS, (Object)Float.valueOf(spinRadius));
    }

    public boolean isStraight() {
        return (Boolean)this.f_19804_.m_135370_(STRAIGHT);
    }

    public void setStraight(boolean straight) {
        this.f_19804_.m_135381_(STRAIGHT, (Object)straight);
    }

    public float getStartAngle() {
        return ((Float)this.f_19804_.m_135370_(START_ANGLE)).floatValue();
    }

    public void setStartAngle(float f) {
        this.f_19804_.m_135381_(START_ANGLE, (Object)Float.valueOf(f));
    }

    public void setLifespan(int lifespan) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)lifespan);
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setSeekingEntityId(int seekingEntityId) {
        this.f_19804_.m_135381_(SEEKING_ENTITY, (Object)seekingEntityId);
    }

    public int getSeekingEntityId() {
        return (Integer)this.f_19804_.m_135370_(SEEKING_ENTITY);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.setStraight(compoundTag.m_128471_("Straight"));
        if (compoundTag.m_128441_("DespawnsIn")) {
            this.despawnsIn = compoundTag.m_128451_("DespawnsIn");
        }
        this.setLifespan(compoundTag.m_128451_("Lifespan"));
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
        if (compoundTag.m_128441_("AroundX") && compoundTag.m_128441_("AroundY") && compoundTag.m_128441_("AroundZ")) {
            this.setSpinAroundPosition(new Vec3(compoundTag.m_128459_("AroundX"), compoundTag.m_128459_("AroundZ"), compoundTag.m_128459_("AroundZ")));
        }
        this.setSpinSpeed(compoundTag.m_128457_("SpinSpeed"));
        this.setSpinRadius(compoundTag.m_128457_("SpinRadius"));
        this.setStartAngle(compoundTag.m_128457_("StartAngle"));
        this.spinAngle = compoundTag.m_128457_("SpinAngle");
    }

    protected void m_7380_(CompoundTag compoundTag) {
        Vec3 vec3;
        compoundTag.m_128405_("DespawnsIn", this.despawnsIn);
        compoundTag.m_128379_("Straight", this.isStraight());
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        if ((vec3 = this.getSpinAroundPosition()) != null) {
            compoundTag.m_128347_("AroundX", vec3.f_82479_);
            compoundTag.m_128347_("AroundY", vec3.f_82480_);
            compoundTag.m_128347_("AroundZ", vec3.f_82481_);
        }
        compoundTag.m_128350_("SpinSpeed", this.getSpinSpeed());
        compoundTag.m_128350_("SpinRadius", this.getSpinRadius());
        compoundTag.m_128350_("StartAngle", this.getStartAngle());
        compoundTag.m_128350_("SpinAngle", this.spinAngle);
        compoundTag.m_128405_("Lifespan", this.getLifespan());
    }

    private void hurtEntities() {
        AABB bashBox = this.m_20191_();
        DamageSource source = this.m_269291_().m_269299_((Entity)this, this.owner);
        boolean flag = false;
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
            LicowitchEntity licowitch;
            LivingEntity livingEntity;
            if (this.m_7307_((Entity)entity) || this.owner == null || entity.m_7306_((Entity)this.owner) || (this.owner instanceof LicowitchEntity || entity.m_7307_((Entity)this.owner)) && (!((livingEntity = this.owner) instanceof LicowitchEntity) || (licowitch = (LicowitchEntity)livingEntity).isFriendlyFire(entity)) || !entity.m_6469_(source, 3.0f)) continue;
            flag = true;
            entity.m_147240_((double)0.3f, this.m_20185_() - entity.m_20185_(), this.m_20189_() - entity.m_20189_());
        }
        if (flag && this.getSeekingEntityId() != -1) {
            this.m_146870_();
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }
}

