/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.GloomothEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VesperEntity;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;

public class VesperAttackGoal
extends Goal {
    private VesperEntity entity;
    private Vec3 startOrbitFrom;
    private int orbitTime;
    private int maxOrbitTime;
    private boolean clockwise;

    public VesperAttackGoal(VesperEntity entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.entity = entity;
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        return target != null && target.m_6084_() && !this.entity.m_20159_();
    }

    public void m_8037_() {
        if (this.entity.groundedFor <= 0) {
            if (this.entity.isHanging()) {
                this.entity.setHanging(false);
                this.entity.setFlying(true);
            } else if (!this.entity.isFlying()) {
                this.entity.setFlying(true);
            }
        } else {
            this.entity.setFlying(false);
        }
        LivingEntity target = this.entity.m_5448_();
        if (target != null && target.m_6084_()) {
            double distance = this.entity.m_20270_((Entity)target);
            float f = this.entity.m_20205_() + target.m_20205_();
            if (this.startOrbitFrom == null) {
                this.entity.m_21573_().m_5624_((Entity)target, this.entity.isFlying() ? 2.5 : 1.0);
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
            } else if (this.orbitTime < this.maxOrbitTime && this.entity.groundedFor <= 0) {
                ++this.orbitTime;
                float zoomIn = 1.0f - (float)this.orbitTime / (float)this.maxOrbitTime;
                Vec3 orbitPos = this.orbitAroundPos(3.0f + zoomIn * 5.0f).m_82520_(0.0, (double)(4.0f + zoomIn * 3.0f), 0.0);
                this.entity.m_21573_().m_26519_(orbitPos.f_82479_, orbitPos.f_82480_, orbitPos.f_82481_, this.entity.isFlying() ? 2.5 : 1.0);
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, orbitPos);
            } else {
                this.orbitTime = 0;
                this.startOrbitFrom = null;
            }
            if (distance < (double)f + 0.5) {
                if (this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    this.entity.setAnimation(VesperEntity.ANIMATION_BITE);
                } else if (this.entity.getAnimationTick() == 8 && this.entity.m_142582_((Entity)target)) {
                    boolean flag = target.m_21254_();
                    if (target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.entity), (float)this.entity.m_21051_(Attributes.f_22281_).m_22135_()) && !target.m_6084_() && target instanceof GloomothEntity) {
                        GloomothEntity gloomothEntity = (GloomothEntity)target;
                        if (gloomothEntity.lightPos != null && gloomothEntity.m_20238_(Vec3.m_82512_((Vec3i)gloomothEntity.lightPos)) < 32.0) {
                            this.entity.groundedFor = 100 + this.entity.m_217043_().m_188503_(40);
                            this.entity.setFlying(false);
                        }
                    }
                    this.maxOrbitTime = 60 + this.entity.m_217043_().m_188503_(80);
                    this.startOrbitFrom = target.m_146892_();
                    if (flag) {
                        if (target instanceof Player) {
                            Player player = (Player)target;
                            this.damageShieldFor(player, (float)this.entity.m_21051_(Attributes.f_22281_).m_22115_());
                        }
                        this.entity.groundedFor = 60 + this.entity.m_217043_().m_188503_(40);
                        this.entity.setFlying(false);
                        this.startOrbitFrom = null;
                    }
                }
            }
        }
    }

    public void m_8056_() {
        this.orbitTime = 0;
        this.maxOrbitTime = 80;
        this.startOrbitFrom = null;
    }

    public Vec3 orbitAroundPos(float circleDistance) {
        float angle = 3.0f * (float)Math.toRadians((float)(this.clockwise ? -this.orbitTime : this.orbitTime) * 3.0f);
        double extraX = circleDistance * Mth.m_14031_((float)angle);
        double extraZ = circleDistance * Mth.m_14089_((float)angle);
        return this.startOrbitFrom.m_82520_(extraX, 0.0, extraZ);
    }

    protected void damageShieldFor(Player holder, float damage) {
        if (holder.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            if (!this.entity.m_9236_().f_46443_) {
                holder.m_36246_(Stats.f_12982_.m_12902_((Object)holder.m_21211_().m_41720_()));
            }
            if (damage >= 3.0f) {
                int i = 1 + Mth.m_14143_((float)damage);
                InteractionHand hand = holder.m_7655_();
                holder.m_21211_().m_41622_(i, (LivingEntity)holder, p_213833_1_ -> {
                    p_213833_1_.m_21190_(hand);
                    ForgeEventFactory.onPlayerDestroyItem((Player)holder, (ItemStack)holder.m_21211_(), (InteractionHand)hand);
                });
                if (holder.m_21211_().m_41619_()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        holder.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    } else {
                        holder.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                    holder.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.entity.m_9236_().f_46441_.m_188501_() * 0.4f);
                }
            }
        }
    }
}

