/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.TephraEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SauropodBaseEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VolcanicCoreBlockEntity
extends BlockEntity {
    private int battleTime = 0;
    private int bossSpawnCooldown = 0;
    private int tephraSpawnCooldown = 0;
    private final Predicate<ItemEntity> itemAttracted = item -> item.m_32055_().m_150930_((Item)ACItemRegistry.OMINOUS_CATALYST.get());

    public VolcanicCoreBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ACBlockEntityRegistry.VOLCANIC_CORE.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, VolcanicCoreBlockEntity entity) {
        if (entity.bossSpawnCooldown > 0) {
            --entity.bossSpawnCooldown;
        } else {
            Vec3 vec3 = Vec3.m_82512_((Vec3i)blockPos);
            AABB aabb = new AABB(vec3.m_82492_(20.0, 100.0, 20.0), vec3.m_82520_(20.0, 100.0, 20.0));
            double maxDist = 100.0;
            for (ItemEntity item : level.m_6443_(ItemEntity.class, aabb, entity.itemAttracted)) {
                double dist = Mth.m_14116_((float)((float)item.m_20238_(vec3)));
                if (dist < maxDist) {
                    Vec3 sub = vec3.m_82546_(item.m_20182_()).m_82541_().m_82490_((double)0.2f);
                    Vec3 delta = item.m_20184_().m_82490_((double)0.8f);
                    item.m_20256_(sub.m_82549_(delta));
                }
                if (!(dist < (double)0.66f) || !entity.spawnBoss()) continue;
                item.m_32055_().m_41774_(1);
                if (level.f_46443_) continue;
                for (Player player : level.m_6443_(Player.class, aabb, EntitySelector.f_20408_)) {
                    ACAdvancementTriggerRegistry.SUMMON_LUXTRUCTOSAURUS.triggerForEntity((Entity)player);
                }
            }
        }
        if (AlexsCaves.PROXY.isPrimordialBossActive(level)) {
            if (entity.tephraSpawnCooldown-- <= 0) {
                entity.spawnTephra(true);
                entity.tephraSpawnCooldown = 120 + level.f_46441_.m_188503_(120);
            }
        } else {
            entity.battleTime = 0;
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tephraSpawnCooldown = tag.m_128451_("TephraSpawnCooldown");
        this.bossSpawnCooldown = tag.m_128451_("BossSpawnCooldown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("TephraSpawnCooldown", this.tephraSpawnCooldown);
        tag.m_128405_("BossSpawnCooldown", this.bossSpawnCooldown);
    }

    public boolean spawnBoss() {
        if (this.bossSpawnCooldown > 0) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos volcanoTop = this.m_58899_();
        for (int i = -5; i <= -5; ++i) {
            for (int j = -5; j <= -5; ++j) {
                BlockPos.MutableBlockPos localTop = this.getTopOfVolcano((BlockPos)mutableBlockPos.m_122178_(this.m_58899_().m_123341_() + i, this.m_58899_().m_123342_(), this.m_58899_().m_123343_() + j));
                if (localTop.m_123342_() <= volcanoTop.m_123342_()) continue;
                volcanoTop = volcanoTop.m_175288_(localTop.m_123342_());
            }
        }
        LuxtructosaurusEntity luxtructosaurus = (LuxtructosaurusEntity)((EntityType)ACEntityRegistry.LUXTRUCTOSAURUS.get()).m_20615_(this.f_58857_);
        luxtructosaurus.m_146884_(Vec3.m_82514_((Vec3i)volcanoTop, (double)2.0));
        luxtructosaurus.m_6842_(true);
        luxtructosaurus.setAnimation(SauropodBaseEntity.ANIMATION_SUMMON);
        luxtructosaurus.enragedFor = 100;
        luxtructosaurus.setEnraged(true);
        this.f_58857_.m_7967_((Entity)luxtructosaurus);
        this.bossSpawnCooldown = 24000;
        return true;
    }

    private BlockPos.MutableBlockPos getTopOfVolcano(BlockPos posIn) {
        BlockPos.MutableBlockPos volcanoTop = new BlockPos.MutableBlockPos();
        volcanoTop.m_122190_((Vec3i)posIn);
        while (this.f_58857_.m_8055_((BlockPos)volcanoTop).m_204336_(ACTagRegistry.VOLCANO_BLOCKS) && volcanoTop.m_123342_() < this.f_58857_.m_151558_()) {
            volcanoTop.m_122184_(0, 1, 0);
        }
        volcanoTop.m_122184_(0, -1, 0);
        return volcanoTop;
    }

    private void spawnTephra(boolean big) {
        BlockPos volcanoTop = this.getTopOfVolcano(this.m_58899_()).m_7949_();
        if (this.f_58857_.m_8055_(volcanoTop).m_60713_((Block)ACBlockRegistry.VOLCANIC_CORE.get()) || this.f_58857_.m_8055_(volcanoTop).m_60713_((Block)ACBlockRegistry.PRIMAL_MAGMA.get()) || this.f_58857_.m_8055_(volcanoTop).m_60713_((Block)ACBlockRegistry.FISSURE_PRIMAL_MAGMA.get()) || this.f_58857_.m_6425_(volcanoTop).m_205070_(FluidTags.f_13132_)) {
            Vec3 volcanoVec = Vec3.m_82514_((Vec3i)volcanoTop, (double)3.0);
            Player nearestPlayer = this.f_58857_.m_45924_(volcanoVec.f_82479_, volcanoVec.f_82480_, volcanoVec.f_82481_, 400.0, true);
            if (big) {
                Vec3 targetVec;
                TephraEntity bigTephra = (TephraEntity)((EntityType)ACEntityRegistry.TEPHRA.get()).m_20615_(this.f_58857_);
                bigTephra.m_146884_(volcanoVec);
                bigTephra.setMaxScale(2.0f + this.f_58857_.f_46441_.m_188501_());
                if (nearestPlayer == null) {
                    targetVec = new Vec3((double)(this.f_58857_.f_46441_.m_188501_() - 0.5f), 0.0, (double)(this.f_58857_.f_46441_.m_188501_() - 0.5f)).m_82541_().m_82490_((double)(this.f_58857_.f_46441_.m_188503_(50) + 20));
                } else {
                    targetVec = nearestPlayer.m_20182_().m_82546_(volcanoVec);
                    bigTephra.setArcingTowards(nearestPlayer.m_20148_());
                }
                double d4 = Math.sqrt(targetVec.f_82479_ * targetVec.f_82479_ + targetVec.f_82481_ * targetVec.f_82481_);
                double d5 = nearestPlayer == null ? (double)this.f_58857_.f_46441_.m_188501_() : 0.0;
                bigTephra.m_6686_(targetVec.f_82479_, targetVec.f_82480_ + 0.5 + d4 * 0.75 + d5, targetVec.f_82481_, (float)(d4 * (double)0.1f + d5), 1.0f + this.f_58857_.f_46441_.m_188501_() * 0.5f);
                this.f_58857_.m_7967_((Entity)bigTephra);
            }
            for (int smalls = 0; smalls < 3 + this.f_58857_.f_46441_.m_188503_(3); ++smalls) {
                TephraEntity smallTephra = (TephraEntity)((EntityType)ACEntityRegistry.TEPHRA.get()).m_20615_(this.f_58857_);
                smallTephra.m_146884_(volcanoVec);
                smallTephra.setMaxScale(0.6f + 0.6f * this.f_58857_.f_46441_.m_188501_());
                Vec3 targetVec = new Vec3((double)(this.f_58857_.f_46441_.m_188501_() - 0.5f), 0.0, (double)(this.f_58857_.f_46441_.m_188501_() - 0.5f)).m_82541_().m_82490_((double)(this.f_58857_.f_46441_.m_188503_(30) + 30));
                double d4 = Math.sqrt(targetVec.f_82479_ * targetVec.f_82479_ + targetVec.f_82481_ * targetVec.f_82481_);
                smallTephra.m_6686_(targetVec.f_82479_, targetVec.f_82480_ + 0.5 + d4 * 0.75 + (double)this.f_58857_.f_46441_.m_188501_(), targetVec.f_82481_, (float)(d4 * (double)0.1f + (double)this.f_58857_.f_46441_.m_188501_()), 1.0f);
                this.f_58857_.m_7967_((Entity)smallTephra);
            }
        }
    }
}

