/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui.book;

import com.github.alexmodguy.alexscaves.client.gui.book.BookEntry;
import com.github.alexmodguy.alexscaves.client.gui.book.BookLink;
import com.github.alexmodguy.alexscaves.client.gui.book.CaveBookScreen;
import com.github.alexmodguy.alexscaves.client.gui.book.widget.BookWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class PageRenderer {
    public boolean enteringNewPageFlag;
    public boolean leavingNewPageFlag;
    private int relativePageNumber;
    private int entryPageNumber;
    private BookEntry entry;

    public PageRenderer(int relativePageNumber) {
        this.relativePageNumber = relativePageNumber;
    }

    public void setEntryPageNumber(int entryPageNumber) {
        this.entryPageNumber = entryPageNumber;
    }

    public int getDisplayPageNumber() {
        int i = this.relativePageNumber;
        if (this.enteringNewPageFlag) {
            i -= 2;
        }
        if (this.leavingNewPageFlag) {
            i += 2;
        }
        return 1 + i + this.entryPageNumber * 2;
    }

    public void setEntry(BookEntry entry) {
        this.entry = entry;
    }

    protected void renderPage(CaveBookScreen screen, PoseStack poseStack, int mouseX, int mouseY, float partialTicks, boolean onFlippingPage) {
        int pgNumber = this.getDisplayPageNumber();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        if (this.entry != null) {
            if (pgNumber == 1 && !this.entry.getTranslatableTitle().isEmpty()) {
                MutableComponent title = Component.m_237115_((String)this.entry.getTranslatableTitle());
                poseStack.m_85836_();
                int titleLength = Math.max(screen.getMinecraft().f_91062_.m_92852_((FormattedText)title), 1);
                float titleScale = Math.min(135.0f / (float)titleLength, 2.5f);
                poseStack.m_252880_(65.0f, 7.0f - 5.0f * titleScale, 0.0f);
                poseStack.m_85841_(titleScale, titleScale, 1.0f);
                poseStack.m_252880_((float)(-titleLength) / 2.0f, 0.0f, 0.0f);
                screen.getMinecraft().f_91062_.m_168645_(title.m_7532_(), 0.0f, 0.0f, 16771007, 11179903, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, 0xF000F0);
                poseStack.m_85849_();
            }
            if (!this.entry.getEntryText().isEmpty()) {
                int startReadingAt = (pgNumber - 1) * 15;
                this.printLinesFromEntry(screen.getMinecraft().f_91062_, poseStack, bufferSource, this.entry, startReadingAt);
            }
            int numberWidth = screen.getMinecraft().f_91062_.m_92895_(String.valueOf(pgNumber));
            poseStack.m_85836_();
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            screen.getMinecraft().f_91062_.m_271703_(String.valueOf(pgNumber), 86.0f - (float)numberWidth * 0.5f, 210.0f, 8546881, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.m_85849_();
            for (BookWidget widget : this.entry.getWidgets()) {
                if (widget.getDisplayPage() != pgNumber) continue;
                widget.render(poseStack, bufferSource, partialTicks, onFlippingPage);
            }
        }
    }

    private void printLinesFromEntry(Font font, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, BookEntry bookEntry, int startReadingAt) {
        if (startReadingAt >= 0) {
            for (int i = startReadingAt; i < startReadingAt + 15; ++i) {
                if (bookEntry.getEntryText().size() <= i) continue;
                String printLine = bookEntry.getEntryText().get(i);
                font.m_271703_(printLine, 0.0f, (float)((i - startReadingAt) * 10), 8546881, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                for (BookLink bookLink : bookEntry.getEntryLinks()) {
                    if (bookLink.getLineNumber() != i) continue;
                    int fontWidth = font.m_92895_(printLine.substring(0, bookLink.getCharacterStartsAt()));
                    MutableComponent component = Component.m_237113_((String)bookLink.getDisplayText()).m_130940_(ChatFormatting.UNDERLINE);
                    font.m_272077_((Component)component, (float)fontWidth, (float)((i - startReadingAt) * 10), bookLink.isEnabled() ? (bookLink.isHovered() ? 38143 : 0x111111) : 13879723, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
            }
        }
    }
}

